/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.util.nbt;

import java.util.Arrays;
import java.util.Objects;
import me.filoghost.chestcommands.util.nbt.NBTTag;
import me.filoghost.chestcommands.util.nbt.NBTType;

public final class NBTIntArray
extends NBTTag
implements Cloneable {
    private final int[] value;

    public NBTIntArray(int[] value) {
        this.value = Objects.requireNonNull(value);
    }

    public NBTIntArray(Number[] numbers) {
        this.value = new int[numbers.length];
        for (int i = 0; i < numbers.length; ++i) {
            this.value[i] = numbers[i].intValue();
        }
    }

    public int length() {
        return this.value.length;
    }

    public int[] getValue() {
        return this.value;
    }

    @Override
    public NBTType getType() {
        return NBTType.INT_ARRAY;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof NBTIntArray && this.equals((NBTIntArray)obj);
    }

    public boolean equals(NBTIntArray tag) {
        return Arrays.equals(this.value, tag.value);
    }

    @Override
    public String toMSONString() {
        StringBuilder stringbuilder = new StringBuilder("[I;");
        for (int i = 0; i < this.value.length; ++i) {
            if (i != 0) {
                stringbuilder.append(',');
            }
            stringbuilder.append(this.value[i]);
        }
        return stringbuilder.append(']').toString();
    }

    public NBTIntArray clone() {
        return new NBTIntArray(this.value);
    }
}

