/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.util.nbt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import me.filoghost.chestcommands.util.nbt.NBTTag;
import me.filoghost.chestcommands.util.nbt.NBTType;

public final class NBTList
extends NBTTag
implements Iterable<NBTTag>,
Cloneable {
    private NBTType type;
    private final List<NBTTag> list = new ArrayList<NBTTag>();

    public NBTList(NBTType type, List<? extends NBTTag> value) {
        this.type = type;
        for (NBTTag nBTTag : value) {
            this.add(nBTTag);
        }
    }

    public NBTList(NBTType type, NBTTag ... value) {
        this(type, Arrays.asList(value));
    }

    public NBTList(NBTType type) {
        this.type = type;
    }

    public NBTList() {
        this(null);
    }

    public int size() {
        return this.list.size();
    }

    @Override
    public List<NBTTag> getValue() {
        return this.list;
    }

    @Override
    public NBTType getType() {
        return NBTType.LIST;
    }

    public NBTType getElementType() {
        return this.type;
    }

    public NBTTag get(int index) {
        return this.list.get(index);
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public void add(NBTTag value) {
        if (this.type == null) {
            this.type = value.getType();
        } else if (this.type != value.getType()) {
            throw new IllegalArgumentException((Object)((Object)value.getType()) + " is not of expected type " + (Object)((Object)this.type));
        }
        this.list.add(value);
    }

    public void add(int index, NBTTag value) {
        if (index < 0 || index >= this.list.size()) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        if (this.type == null) {
            this.type = value.getType();
        } else if (this.type != value.getType()) {
            throw new IllegalArgumentException((Object)((Object)value.getType()) + " is not of expected type " + (Object)((Object)this.type));
        }
        this.list.add(index, value);
    }

    public void addAll(Collection<? extends NBTTag> values) {
        for (NBTTag nBTTag : values) {
            this.add(nBTTag);
        }
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof NBTList && this.equals((NBTList)obj);
    }

    public boolean equals(NBTList tag) {
        return this.isEmpty() && tag.isEmpty() || this.type == tag.type && this.list.equals(tag.list);
    }

    @Override
    public Iterator<NBTTag> iterator() {
        return this.list.iterator();
    }

    @Override
    public String toMSONString() {
        StringBuilder builder = new StringBuilder("[");
        Iterator<NBTTag> iter = this.iterator();
        boolean first = true;
        while (iter.hasNext()) {
            if (first) {
                first = false;
            } else {
                builder.append(',');
            }
            builder.append(iter.next().toMSONString());
        }
        return builder.append("]").toString();
    }

    public NBTList clone() {
        return new NBTList(this.type, this.list);
    }
}

