/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.util.nbt;

import me.filoghost.chestcommands.util.nbt.NBTTag;
import me.filoghost.chestcommands.util.nbt.NBTType;

public final class NBTString
extends NBTTag
implements Cloneable {
    private String value;

    public NBTString(String value) {
        this.setValue(value);
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public NBTType getType() {
        return NBTType.STRING;
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public String toMSONString() {
        return NBTString.toMSONString(this.value);
    }

    public NBTString clone() {
        return new NBTString(this.value);
    }

    public static String toMSONString(String str) {
        char[] chars;
        StringBuilder builder = new StringBuilder("\"");
        for (char c : chars = str.toCharArray()) {
            if (c == '\\' || c == '\"') {
                builder.append('\\');
            }
            builder.append(c);
        }
        return builder.append('\"').toString();
    }
}

