/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.util.nbt;

public enum NBTType {
    END("TAG_End", false, false, false),
    BYTE("TAG_Byte", true, true, false),
    SHORT("TAG_Short", true, true, false),
    INT("TAG_Int", true, true, false),
    LONG("TAG_Long", true, true, false),
    FLOAT("TAG_Float", true, true, false),
    DOUBLE("TAG_Double", true, true, false),
    BYTE_ARRAY("TAG_Byte_Array", false, false, true),
    STRING("TAG_String", true, false, false),
    LIST("TAG_List", false, false, false),
    COMPOUND("TAG_Compound", false, false, false),
    INT_ARRAY("TAG_Int_Array", false, false, true),
    LONG_ARRAY("TAG_Long_Array", false, false, true);

    private final String name;
    private final boolean numeric;
    private final boolean primitive;
    private final boolean array;
    private final byte id;

    private NBTType(String name, boolean primitive, boolean numeric, boolean array) {
        this.name = name;
        this.id = (byte)this.ordinal();
        this.numeric = numeric;
        this.primitive = primitive;
        this.array = array;
    }

    public static NBTType getById(byte id) {
        return NBTType.values()[id];
    }

    public byte getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean isNumeric() {
        return this.numeric;
    }

    public boolean isPrimitive() {
        return this.primitive;
    }

    public boolean isArray() {
        return this.array;
    }

    public String toString() {
        return this.getName();
    }
}

