/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.util.nbt.parser;

import java.util.ArrayList;
import java.util.regex.Pattern;
import me.filoghost.chestcommands.util.nbt.NBTByte;
import me.filoghost.chestcommands.util.nbt.NBTByteArray;
import me.filoghost.chestcommands.util.nbt.NBTCompound;
import me.filoghost.chestcommands.util.nbt.NBTDouble;
import me.filoghost.chestcommands.util.nbt.NBTFloat;
import me.filoghost.chestcommands.util.nbt.NBTInt;
import me.filoghost.chestcommands.util.nbt.NBTIntArray;
import me.filoghost.chestcommands.util.nbt.NBTList;
import me.filoghost.chestcommands.util.nbt.NBTLong;
import me.filoghost.chestcommands.util.nbt.NBTLongArray;
import me.filoghost.chestcommands.util.nbt.NBTShort;
import me.filoghost.chestcommands.util.nbt.NBTString;
import me.filoghost.chestcommands.util.nbt.NBTTag;
import me.filoghost.chestcommands.util.nbt.NBTType;
import me.filoghost.chestcommands.util.nbt.parser.MojangsonParseException;

public final class MojangsonParser {
    private static final Pattern DOUBLE_NS = Pattern.compile("[-+]?(?:[0-9]+[.]|[0-9]*[.][0-9]+)(?:e[-+]?[0-9]+)?", 2);
    private static final Pattern DOUBLE_S = Pattern.compile("[-+]?(?:[0-9]+[.]?|[0-9]*[.][0-9]+)(?:e[-+]?[0-9]+)?d", 2);
    private static final Pattern FLOAT = Pattern.compile("[-+]?(?:[0-9]+[.]?|[0-9]*[.][0-9]+)(?:e[-+]?[0-9]+)?f", 2);
    private static final Pattern BYTE = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)b", 2);
    private static final Pattern LONG = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)l", 2);
    private static final Pattern SHORT = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)s", 2);
    private static final Pattern INT = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)");
    private final String str;
    private int index;

    public static NBTCompound parse(String mson) throws MojangsonParseException {
        return new MojangsonParser(mson).parseRootCompound();
    }

    private MojangsonParser(String str) {
        this.str = str;
    }

    private NBTCompound parseRootCompound() throws MojangsonParseException {
        this.skipWhitespace();
        NBTCompound result = this.parseCompound();
        this.expectNoTrail();
        return result;
    }

    private String parseCompoundKey() throws MojangsonParseException {
        this.skipWhitespace();
        if (!this.hasNext()) {
            throw this.parseException("Expected key");
        }
        return this.currentChar() == '\"' ? this.parseQuotedString() : this.parseSimpleString();
    }

    private NBTTag parseStringOrLiteral() throws MojangsonParseException {
        this.skipWhitespace();
        if (this.currentChar() == '\"') {
            return new NBTString(this.parseQuotedString());
        }
        String str = this.parseSimpleString();
        if (str.isEmpty()) {
            throw this.parseException("Expected value");
        }
        return this.parseLiteral(str);
    }

    private NBTTag parseLiteral(String str) {
        try {
            if (FLOAT.matcher(str).matches()) {
                return new NBTFloat(Float.parseFloat(str.substring(0, str.length() - 1)));
            }
            if (BYTE.matcher(str).matches()) {
                return new NBTByte(Byte.parseByte(str.substring(0, str.length() - 1)));
            }
            if (LONG.matcher(str).matches()) {
                return new NBTLong(Long.parseLong(str.substring(0, str.length() - 1)));
            }
            if (SHORT.matcher(str).matches()) {
                return new NBTShort(Short.parseShort(str.substring(0, str.length() - 1)));
            }
            if (INT.matcher(str).matches()) {
                return new NBTInt(Integer.parseInt(str));
            }
            if (DOUBLE_S.matcher(str).matches()) {
                return new NBTDouble(Double.parseDouble(str.substring(0, str.length() - 1)));
            }
            if (DOUBLE_NS.matcher(str).matches()) {
                return new NBTDouble(Double.parseDouble(str));
            }
            if ("true".equalsIgnoreCase(str)) {
                return new NBTByte(1);
            }
            if ("false".equalsIgnoreCase(str)) {
                return new NBTByte(0);
            }
        }
        catch (NumberFormatException ex) {
            return new NBTString(str);
        }
        return new NBTString(str);
    }

    private String parseQuotedString() throws MojangsonParseException {
        int j = ++this.index;
        StringBuilder builder = null;
        boolean escape = false;
        while (this.hasNext()) {
            char c = this.nextChar();
            if (escape) {
                if (c != '\\' && c != '\"') {
                    throw this.parseException("Invalid escape of '" + c + "'");
                }
                escape = false;
            } else {
                if (c == '\\') {
                    escape = true;
                    if (builder != null) continue;
                    builder = new StringBuilder(this.str.substring(j, this.index - 1));
                    continue;
                }
                if (c == '\"') {
                    return builder == null ? this.str.substring(j, this.index - 1) : builder.toString();
                }
            }
            if (builder == null) continue;
            builder.append(c);
        }
        throw this.parseException("Missing termination quote");
    }

    private String parseSimpleString() {
        int j = this.index;
        while (this.hasNext() && MojangsonParser.isSimpleChar(this.currentChar())) {
            ++this.index;
        }
        return this.str.substring(j, this.index);
    }

    private NBTTag parseAnything() throws MojangsonParseException {
        this.skipWhitespace();
        if (!this.hasNext()) {
            throw this.parseException("Expected value");
        }
        char c = this.currentChar();
        if (c == '{') {
            return this.parseCompound();
        }
        if (c == '[') {
            return this.parseDetectedArray();
        }
        return this.parseStringOrLiteral();
    }

    private NBTTag parseDetectedArray() throws MojangsonParseException {
        if (this.hasCharsLeft(2) && this.getChar(1) != '\"' && this.getChar(2) == ';') {
            return this.parseNumArray();
        }
        return this.parseList();
    }

    private NBTCompound parseCompound() throws MojangsonParseException {
        this.expectChar('{');
        NBTCompound compound = new NBTCompound();
        this.skipWhitespace();
        while (this.hasNext() && this.currentChar() != '}') {
            String str = this.parseCompoundKey();
            if (str.isEmpty()) {
                throw this.parseException("Expected non-empty key");
            }
            this.expectChar(':');
            compound.put(str, this.parseAnything());
            if (!this.advanceToNextArrayElement()) break;
            if (this.hasNext()) continue;
            throw this.parseException("Expected key");
        }
        this.expectChar('}');
        return compound;
    }

    private NBTList parseList() throws MojangsonParseException {
        this.expectChar('[');
        this.skipWhitespace();
        if (!this.hasNext()) {
            throw this.parseException("Expected value");
        }
        NBTList list = new NBTList();
        NBTType listType = null;
        while (this.currentChar() != ']') {
            NBTTag element = this.parseAnything();
            NBTType elementType = element.getType();
            if (listType == null) {
                listType = elementType;
            } else if (elementType != listType) {
                throw this.parseException("Unable to insert " + (Object)((Object)elementType) + " into ListTag of type " + (Object)((Object)listType));
            }
            list.add(element);
            if (!this.advanceToNextArrayElement()) break;
            if (this.hasNext()) continue;
            throw this.parseException("Expected value");
        }
        this.expectChar(']');
        return list;
    }

    private NBTTag parseNumArray() throws MojangsonParseException {
        this.expectChar('[');
        char arrayType = this.nextChar();
        this.expectChar(';');
        this.skipWhitespace();
        if (!this.hasNext()) {
            throw this.parseException("Expected value");
        }
        if (arrayType == 'B') {
            return new NBTByteArray(this.parseNumArray(NBTType.BYTE_ARRAY, NBTType.BYTE));
        }
        if (arrayType == 'L') {
            return new NBTLongArray(this.parseNumArray(NBTType.LONG_ARRAY, NBTType.LONG));
        }
        if (arrayType == 'I') {
            return new NBTIntArray(this.parseNumArray(NBTType.INT_ARRAY, NBTType.INT));
        }
        throw this.parseException("Invalid array type '" + arrayType + "' found");
    }

    private Number[] parseNumArray(NBTType arrayType, NBTType primType) throws MojangsonParseException {
        ArrayList<Number> result = new ArrayList<Number>();
        while (this.currentChar() != ']') {
            NBTTag element = this.parseAnything();
            NBTType elementType = element.getType();
            if (elementType != primType) {
                throw this.parseException("Unable to insert " + (Object)((Object)elementType) + " into " + (Object)((Object)arrayType));
            }
            if (primType == NBTType.BYTE) {
                result.add(((NBTByte)element).getValue());
            } else if (primType == NBTType.LONG) {
                result.add(((NBTLong)element).getValue());
            } else {
                result.add(((NBTInt)element).getValue());
            }
            if (!this.advanceToNextArrayElement()) break;
            if (this.hasNext()) continue;
            throw this.parseException("Expected value");
        }
        this.expectChar(']');
        return result.toArray(new Number[0]);
    }

    private boolean advanceToNextArrayElement() {
        this.skipWhitespace();
        if (this.hasNext() && this.currentChar() == ',') {
            ++this.index;
            this.skipWhitespace();
            return true;
        }
        return false;
    }

    private void skipWhitespace() {
        while (this.hasNext() && Character.isWhitespace(this.currentChar())) {
            ++this.index;
        }
    }

    private boolean hasCharsLeft(int paramInt) {
        return this.index + paramInt < this.str.length();
    }

    private boolean hasNext() {
        return this.hasCharsLeft(0);
    }

    private char getChar(int offset) {
        return this.str.charAt(this.index + offset);
    }

    private char currentChar() {
        return this.getChar(0);
    }

    private char nextChar() {
        return this.str.charAt(this.index++);
    }

    private void expectChar(char c) throws MojangsonParseException {
        this.skipWhitespace();
        boolean hasNext = this.hasNext();
        if (hasNext && this.currentChar() == c) {
            ++this.index;
            return;
        }
        throw new MojangsonParseException("Expected '" + c + "' but got '" + (hasNext ? Character.valueOf(this.currentChar()) : "<End of string>") + "'", this.str, this.index + 1);
    }

    private void expectNoTrail() throws MojangsonParseException {
        this.skipWhitespace();
        if (this.hasNext()) {
            ++this.index;
            throw this.parseException("Trailing data found");
        }
    }

    private MojangsonParseException parseException(String paramString) {
        return new MojangsonParseException(paramString, this.str, this.index);
    }

    private static boolean isSimpleChar(char paramChar) {
        return paramChar >= '0' && paramChar <= '9' || paramChar >= 'A' && paramChar <= 'Z' || paramChar >= 'a' && paramChar <= 'z' || paramChar == '_' || paramChar == '-' || paramChar == '.' || paramChar == '+';
    }
}

