/*
 * Decompiled with CFR 0.152.
 */
package com.eickmung.bedwars.leavedelay;

import com.andrei1058.bedwars.api.BedWars;
import com.eickmung.bedwars.leavedelay.configuration.Config;
import com.eickmung.bedwars.leavedelay.configuration.Messages;
import com.eickmung.bedwars.leavedelay.listeners.ArenaListener;
import com.eickmung.bedwars.leavedelay.listeners.InventoryListener;
import com.eickmung.bedwars.leavedelay.listeners.PlayerInteractListener;
import com.eickmung.bedwars.leavedelay.listeners.PlayerListener;
import com.eickmung.bedwars.leavedelay.manager.PlayerDataManager;
import com.eickmung.bedwars.leavedelay.runnable.GamePlayerQuitRunnable;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Main
extends JavaPlugin {
    public static BedWars bw;
    public static Main plugin;
    public PlayerDataManager playermanager;

    public void onEnable() {
        if (Bukkit.getPluginManager().getPlugin("BedWars1058") == null) {
            this.getLogger().severe("BedWars1058 was not found. Disabling...");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        try {
            Class.forName("com.andrei1058.bedwars.api.BedWars");
        }
        catch (Exception ex) {
            this.getLogger().severe("Your BedWars1058 version is outdated. Please download the latest version!");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        try {
            bw = (BedWars)Bukkit.getServicesManager().getRegistration(BedWars.class).getProvider();
        }
        catch (Exception ex) {
            this.getLogger().severe("Can't hook into BedWars1058.");
            ex.printStackTrace();
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.getLogger().info("Hook into BedWars1058!");
        plugin = this;
        Config.addDefaultConfig();
        Messages.setupMessages();
        Main.registerListeners(new PlayerListener(), new InventoryListener(), new ArenaListener(), new PlayerInteractListener());
        this.playermanager = new PlayerDataManager();
        this.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this, (BukkitRunnable)new GamePlayerQuitRunnable(), 20L, 20L);
    }

    public static void registerListeners(Listener ... listeners) {
        PluginManager pm = Bukkit.getPluginManager();
        Listener[] listenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Listener l = listenerArray[n2];
            pm.registerEvents(l, (Plugin)plugin);
            ++n2;
        }
    }

    public static PlayerDataManager getPDM() {
        return Main.plugin.playermanager;
    }
}

