/*
 * Decompiled with CFR 0.152.
 */
package com.eickmung.bedwars.leavedelay.listeners;

import com.andrei1058.bedwars.BedWars;
import com.andrei1058.bedwars.api.arena.GameState;
import com.andrei1058.bedwars.api.arena.IArena;
import com.andrei1058.bedwars.api.events.player.PlayerJoinArenaEvent;
import com.andrei1058.bedwars.api.language.Language;
import com.andrei1058.bedwars.arena.Arena;
import com.eickmung.bedwars.leavedelay.Main;
import com.eickmung.bedwars.leavedelay.configuration.Config;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class ArenaListener
implements Listener {
    @EventHandler
    public void onBwArenaJoin(PlayerJoinArenaEvent e) {
        if (e.isCancelled()) {
            return;
        }
        if (e.isSpectator()) {
            return;
        }
        if (e.getArena() == null) {
            return;
        }
        if (e.getArena().getStatus() == GameState.waiting || e.getArena().getStatus() == GameState.starting) {
            Bukkit.getScheduler().runTaskLater((Plugin)Main.plugin, () -> this.giveItem(e.getPlayer()), 10L);
        }
    }

    @EventHandler
    public void onBwArenaDeath(PlayerRespawnEvent e) {
        Player p = e.getPlayer();
        IArena arena = Arena.getArenaByPlayer((Player)p);
        if (arena.isSpectator(p)) {
            return;
        }
        if (arena.getStatus() == GameState.playing) {
            Bukkit.getScheduler().runTaskLater((Plugin)Main.plugin, () -> p.getInventory().clear(), 15L);
            Bukkit.getScheduler().runTaskLater((Plugin)Main.plugin, () -> p.getInventory().setArmorContents(new ItemStack[p.getInventory().getArmorContents().length]), 15L);
        }
    }

    public void giveItem(Player p) {
        ItemStack i;
        String material = Config.config.getString("arena-leave-item-stack");
        try {
            i = BedWars.nms.createItemStack(material, 1, (short)0);
        }
        catch (Exception ex) {
            Main.plugin.getLogger().severe("Leave-Delay Material is invalid!");
            ex.printStackTrace();
            i = BedWars.nms.createItemStack(BedWars.nms.woolMaterial().toString(), 1, (short)0);
        }
        ItemMeta im = i.getItemMeta();
        im.setLore(Language.getList((Player)p, (String)"addons.leave-delay-lore"));
        im.setDisplayName(Language.getMsg((Player)p, (String)"addons.leave-delay-name"));
        im.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        i.setItemMeta(im);
        i = BedWars.nms.addCustomData(i, "BWLEAVEDELAY");
        p.getInventory().setItem(Config.config.getInt("arena-leave-slot"), i);
    }
}

