/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.net.bytebuddy.matcher;

import com.comphenix.net.bytebuddy.build.HashCodeAndEqualsPlugin;
import com.comphenix.net.bytebuddy.description.type.TypeDefinition;
import com.comphenix.net.bytebuddy.description.type.TypeDescription;
import com.comphenix.net.bytebuddy.matcher.ElementMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@HashCodeAndEqualsPlugin.Enhance
public class HasSuperClassMatcher<T extends TypeDescription>
extends ElementMatcher.Junction.AbstractBase<T> {
    private final ElementMatcher<? super TypeDescription.Generic> matcher;

    public HasSuperClassMatcher(ElementMatcher<? super TypeDescription.Generic> matcher) {
        this.matcher = matcher;
    }

    @Override
    public boolean matches(T target) {
        if (target.isInterface()) {
            return this.matcher.matches(TypeDescription.Generic.OBJECT);
        }
        for (TypeDefinition typeDefinition : target) {
            if (!this.matcher.matches(typeDefinition.asGenericType())) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "hasSuperClass(" + this.matcher + ")";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        return this.matcher.equals(((HasSuperClassMatcher)object).matcher);
    }

    public int hashCode() {
        return this.getClass().hashCode() * 31 + this.matcher.hashCode();
    }
}

