/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.injector;

import com.comphenix.protocol.async.AsyncFilterManager;
import com.comphenix.protocol.error.ErrorReporter;
import com.comphenix.protocol.injector.DelayedSingleTask;
import com.comphenix.protocol.injector.InternalManager;
import com.comphenix.protocol.injector.PacketFilterManager;
import com.comphenix.protocol.utility.MinecraftVersion;
import javax.annotation.Nonnull;
import org.bukkit.Server;
import org.bukkit.plugin.Plugin;

public class PacketFilterBuilder {
    private ClassLoader classLoader;
    private Server server;
    private Plugin library;
    private MinecraftVersion mcVersion;
    private DelayedSingleTask unhookTask;
    private ErrorReporter reporter;
    private AsyncFilterManager asyncManager;
    private boolean nettyEnabled;

    public PacketFilterBuilder classLoader(@Nonnull ClassLoader classLoader) {
        if (classLoader == null) {
            throw new IllegalArgumentException("classLoader cannot be NULL.");
        }
        this.classLoader = classLoader;
        return this;
    }

    public PacketFilterBuilder server(@Nonnull Server server) {
        if (server == null) {
            throw new IllegalArgumentException("server cannot be NULL.");
        }
        this.server = server;
        return this;
    }

    public PacketFilterBuilder library(@Nonnull Plugin library) {
        if (library == null) {
            throw new IllegalArgumentException("library cannot be NULL.");
        }
        this.library = library;
        return this;
    }

    public PacketFilterBuilder minecraftVersion(@Nonnull MinecraftVersion mcVersion) {
        if (mcVersion == null) {
            throw new IllegalArgumentException("minecraftVersion cannot be NULL.");
        }
        this.mcVersion = mcVersion;
        return this;
    }

    public PacketFilterBuilder unhookTask(@Nonnull DelayedSingleTask unhookTask) {
        if (unhookTask == null) {
            throw new IllegalArgumentException("unhookTask cannot be NULL.");
        }
        this.unhookTask = unhookTask;
        return this;
    }

    public PacketFilterBuilder reporter(@Nonnull ErrorReporter reporter) {
        if (reporter == null) {
            throw new IllegalArgumentException("reporter cannot be NULL.");
        }
        this.reporter = reporter;
        return this;
    }

    public boolean isNettyEnabled() {
        return this.nettyEnabled;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Server getServer() {
        return this.server;
    }

    public Plugin getLibrary() {
        return this.library;
    }

    public MinecraftVersion getMinecraftVersion() {
        return this.mcVersion;
    }

    public DelayedSingleTask getUnhookTask() {
        return this.unhookTask;
    }

    public ErrorReporter getReporter() {
        return this.reporter;
    }

    public AsyncFilterManager getAsyncManager() {
        return this.asyncManager;
    }

    public InternalManager build() {
        if (this.reporter == null) {
            throw new IllegalArgumentException("reporter cannot be NULL.");
        }
        if (this.classLoader == null) {
            throw new IllegalArgumentException("classLoader cannot be NULL.");
        }
        this.asyncManager = new AsyncFilterManager(this.reporter, this.server.getScheduler());
        this.nettyEnabled = false;
        return this.buildInternal();
    }

    private PacketFilterManager buildInternal() {
        PacketFilterManager manager = new PacketFilterManager(this);
        this.asyncManager.setManager(manager);
        return manager;
    }
}

