/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.reflect.accessors;

import com.comphenix.protocol.reflect.ExactReflection;
import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.accessors.ConstructorAccessor;
import com.comphenix.protocol.reflect.accessors.DefaultConstrutorAccessor;
import com.comphenix.protocol.reflect.accessors.DefaultFieldAccessor;
import com.comphenix.protocol.reflect.accessors.DefaultMethodAccessor;
import com.comphenix.protocol.reflect.accessors.FieldAccessor;
import com.comphenix.protocol.reflect.accessors.MethodAccessor;
import com.google.common.base.Joiner;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;

public final class Accessors {
    public static FieldAccessor getFieldAccessor(Class<?> instanceClass, Class<?> fieldClass, boolean forceAccess) {
        Field field = FuzzyReflection.fromClass(instanceClass, forceAccess).getFieldByType(null, fieldClass);
        return Accessors.getFieldAccessor(field);
    }

    public static FieldAccessor[] getFieldAccessorArray(Class<?> instanceClass, Class<?> fieldClass, boolean forceAccess) {
        List<Field> fields = FuzzyReflection.fromClass(instanceClass, forceAccess).getFieldListByType(fieldClass);
        FieldAccessor[] accessors = new FieldAccessor[fields.size()];
        for (int i = 0; i < accessors.length; ++i) {
            accessors[i] = Accessors.getFieldAccessor(fields.get(i));
        }
        return accessors;
    }

    public static FieldAccessor getFieldAccessor(Class<?> instanceClass, String fieldName, boolean forceAccess) {
        return Accessors.getFieldAccessor(ExactReflection.fromClass(instanceClass, true).getField(fieldName));
    }

    public static FieldAccessor getFieldAccessor(Field field) {
        return Accessors.getFieldAccessor(field, true);
    }

    public static FieldAccessor getFieldAccessor(Field field, boolean forceAccess) {
        field.setAccessible(true);
        return new DefaultFieldAccessor(field);
    }

    public static FieldAccessor getFieldAcccessorOrNull(Class<?> clazz, String fieldName, Class<?> fieldType) {
        try {
            FieldAccessor accessor = Accessors.getFieldAccessor(clazz, fieldName, true);
            if (fieldType.isAssignableFrom(accessor.getField().getType())) {
                return accessor;
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static MethodAccessor getMethodAcccessorOrNull(Class<?> clazz, String methodName) {
        try {
            return Accessors.getMethodAccessor(clazz, methodName, new Class[0]);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static ConstructorAccessor getConstructorAccessorOrNull(Class<?> clazz, Class<?> ... parameters) {
        try {
            return Accessors.getConstructorAccessor(clazz, parameters);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static FieldAccessor getCached(final FieldAccessor inner) {
        return new FieldAccessor(){
            private final Object EMPTY;
            private volatile Object value;
            {
                this.value = this.EMPTY = new Object();
            }

            @Override
            public void set(Object instance, Object value) {
                inner.set(instance, value);
                this.update(value);
            }

            @Override
            public Object get(Object instance) {
                Object cache = this.value;
                if (cache != this.EMPTY) {
                    return cache;
                }
                return this.update(inner.get(instance));
            }

            private Object update(Object value) {
                this.value = value;
                return this.value;
            }

            @Override
            public Field getField() {
                return inner.getField();
            }
        };
    }

    public static FieldAccessor getSynchronized(FieldAccessor accessor) {
        if (accessor instanceof SynchronizedFieldAccessor) {
            return accessor;
        }
        return new SynchronizedFieldAccessor(accessor);
    }

    public static MethodAccessor getConstantAccessor(final Object returnValue, final Method method) {
        return new MethodAccessor(){

            @Override
            public Object invoke(Object target, Object ... args) {
                return returnValue;
            }

            @Override
            public Method getMethod() {
                return method;
            }
        };
    }

    public static MethodAccessor getMethodAccessor(Class<?> instanceClass, String methodName, Class<?> ... parameters) {
        return new DefaultMethodAccessor(ExactReflection.fromClass(instanceClass, true).getMethod(methodName, parameters));
    }

    public static MethodAccessor getMethodAccessor(Method method) {
        return Accessors.getMethodAccessor(method, true);
    }

    public static MethodAccessor getMethodAccessor(Method method, boolean forceAccess) {
        method.setAccessible(forceAccess);
        return new DefaultMethodAccessor(method);
    }

    public static ConstructorAccessor getConstructorAccessor(Class<?> instanceClass, Class<?> ... parameters) {
        try {
            return Accessors.getConstructorAccessor(instanceClass.getDeclaredConstructor(parameters));
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("Unable to find constructor %s(%s).", instanceClass, Joiner.on((String)",").join((Object[])parameters)));
        }
        catch (SecurityException e) {
            throw new IllegalStateException("Cannot access constructors.", e);
        }
    }

    public static ConstructorAccessor getConstructorAccessor(Constructor<?> constructor) {
        constructor.setAccessible(true);
        return new DefaultConstrutorAccessor(constructor);
    }

    private Accessors() {
    }

    public static final class SynchronizedFieldAccessor
    implements FieldAccessor {
        private final FieldAccessor accessor;

        private SynchronizedFieldAccessor(FieldAccessor accessor) {
            this.accessor = accessor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set(Object instance, Object value) {
            Object lock = this.accessor.get(instance);
            if (lock != null) {
                Object object = lock;
                synchronized (object) {
                    this.accessor.set(instance, value);
                }
            } else {
                this.accessor.set(instance, value);
            }
        }

        @Override
        public Object get(Object instance) {
            return this.accessor.get(instance);
        }

        @Override
        public Field getField() {
            return this.accessor.getField();
        }
    }
}

