/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.reflect.accessors;

import com.comphenix.protocol.ProtocolLogger;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.logging.Level;
import sun.misc.Unsafe;

final class UnsafeFieldAccess {
    private static final MethodHandles.Lookup TRUSTED_LOOKUP;

    UnsafeFieldAccess() {
    }

    public static boolean hasTrustedLookup() {
        return TRUSTED_LOOKUP != null;
    }

    public static MethodHandle findSetter(Field field) throws ReflectiveOperationException {
        if (Modifier.isStatic(field.getModifiers())) {
            return TRUSTED_LOOKUP.findStaticSetter(field.getDeclaringClass(), field.getName(), field.getType());
        }
        return TRUSTED_LOOKUP.findSetter(field.getDeclaringClass(), field.getName(), field.getType());
    }

    static {
        MethodHandles.Lookup trusted = null;
        try {
            Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
            Field theUnsafe = unsafeClass.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            Unsafe unsafe = (Unsafe)theUnsafe.get(null);
            Field trustedLookup = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
            long offset = unsafe.staticFieldOffset(trustedLookup);
            Object baseValue = unsafe.staticFieldBase(trustedLookup);
            trusted = (MethodHandles.Lookup)unsafe.getObject(baseValue, offset);
        }
        catch (Exception exception) {
            ProtocolLogger.log(Level.SEVERE, "Unable to retrieve trusted lookup", exception);
        }
        TRUSTED_LOOKUP = trusted;
    }
}

