/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers;

import com.comphenix.protocol.reflect.EquivalentConverter;
import com.comphenix.protocol.utility.MinecraftReflection;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class AutoWrapper<T>
implements EquivalentConverter<T> {
    private Map<Integer, Function<Object, Object>> wrappers = new HashMap<Integer, Function<Object, Object>>();
    private Map<Integer, Function<Object, Object>> unwrappers = new HashMap<Integer, Function<Object, Object>>();
    private Class<T> wrapperClass;
    private Class<?> nmsClass;

    private AutoWrapper(Class<T> wrapperClass, Class<?> nmsClass) {
        this.wrapperClass = wrapperClass;
        this.nmsClass = nmsClass;
    }

    public static <T> AutoWrapper<T> wrap(Class<T> wrapperClass, Class<?> nmsClass) {
        return new AutoWrapper<T>(wrapperClass, nmsClass);
    }

    public static <T> AutoWrapper<T> wrap(Class<T> wrapperClass, String nmsClassName) {
        return AutoWrapper.wrap(wrapperClass, MinecraftReflection.getMinecraftClass(nmsClassName));
    }

    public AutoWrapper<T> field(int index, Function<Object, Object> wrapper, Function<Object, Object> unwrapper) {
        this.wrappers.put(index, wrapper);
        this.unwrappers.put(index, unwrapper);
        return this;
    }

    public AutoWrapper<T> field(int index, EquivalentConverter converter) {
        return this.field(index, converter::getSpecific, specific -> converter.getGeneric(specific));
    }

    public T wrap(Object nmsObject) {
        T instance;
        try {
            instance = this.wrapperClass.newInstance();
        }
        catch (ReflectiveOperationException ex) {
            throw new InvalidWrapperException(this.wrapperClass.getSimpleName() + " is not accessible!", ex);
        }
        Field[] wrapperFields = this.wrapperClass.getDeclaredFields();
        Field[] nmsFields = (Field[])Arrays.stream(this.nmsClass.getDeclaredFields()).filter(field -> !Modifier.isStatic(field.getModifiers())).toArray(Field[]::new);
        for (int i = 0; i < wrapperFields.length; ++i) {
            try {
                Field wrapperField = wrapperFields[i];
                Field nmsField = nmsFields[i];
                if (!nmsField.isAccessible()) {
                    nmsField.setAccessible(true);
                }
                Object value = nmsField.get(nmsObject);
                if (this.wrappers.containsKey(i)) {
                    value = this.wrappers.get(i).apply(value);
                }
                wrapperField.set(instance, value);
                continue;
            }
            catch (Exception ex) {
                throw new InvalidWrapperException("Failed to wrap field at index " + i, ex);
            }
        }
        return instance;
    }

    public Object unwrap(Object wrapper) {
        Object instance;
        try {
            instance = this.nmsClass.newInstance();
        }
        catch (ReflectiveOperationException ex) {
            throw new InvalidWrapperException("Failed to construct new " + this.nmsClass.getSimpleName(), ex);
        }
        Field[] wrapperFields = this.wrapperClass.getDeclaredFields();
        Field[] nmsFields = (Field[])Arrays.stream(this.nmsClass.getDeclaredFields()).filter(field -> !Modifier.isStatic(field.getModifiers())).toArray(Field[]::new);
        for (int i = 0; i < wrapperFields.length; ++i) {
            try {
                Field wrapperField = wrapperFields[i];
                Field nmsField = nmsFields[i];
                if (!nmsField.isAccessible()) {
                    nmsField.setAccessible(true);
                }
                if (Modifier.isFinal(nmsField.getModifiers())) {
                    this.unsetFinal(nmsField);
                }
                Object value = wrapperField.get(wrapper);
                if (this.unwrappers.containsKey(i)) {
                    value = this.unwrappers.get(i).apply(value);
                }
                nmsField.set(instance, value);
                continue;
            }
            catch (ReflectiveOperationException ex) {
                throw new InvalidWrapperException("Failed to unwrap field", ex);
            }
        }
        return instance;
    }

    private void unsetFinal(Field field) throws ReflectiveOperationException {
        Field modifiers = Field.class.getDeclaredField("modifiers");
        modifiers.setAccessible(true);
        modifiers.setInt(field, field.getModifiers() & 0xFFFFFFEF);
    }

    @Override
    public T getSpecific(Object generic) {
        return this.wrap(generic);
    }

    @Override
    public Object getGeneric(Object specific) {
        return this.unwrap(specific);
    }

    @Override
    public Class<T> getSpecificType() {
        return this.wrapperClass;
    }

    public static class InvalidWrapperException
    extends RuntimeException {
        private InvalidWrapperException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

