/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers;

import com.comphenix.protocol.reflect.EquivalentConverter;
import com.comphenix.protocol.utility.MinecraftReflection;
import java.lang.reflect.Array;
import java.util.Optional;
import java.util.function.Function;

public class Converters {
    public static <T> EquivalentConverter<T> ignoreNull(final EquivalentConverter<T> converter) {
        return new EquivalentConverter<T>(){

            @Override
            public T getSpecific(Object generic) {
                return generic != null ? (Object)converter.getSpecific(generic) : null;
            }

            @Override
            public Object getGeneric(T specific) {
                return specific != null ? converter.getGeneric(specific) : null;
            }

            @Override
            public Class<T> getSpecificType() {
                return converter.getSpecificType();
            }
        };
    }

    public static <T> EquivalentConverter<T> passthrough(final Class<T> clazz) {
        return Converters.ignoreNull(new EquivalentConverter<T>(){

            @Override
            public T getSpecific(Object generic) {
                return generic;
            }

            @Override
            public Object getGeneric(T specific) {
                return specific;
            }

            @Override
            public Class<T> getSpecificType() {
                return clazz;
            }
        });
    }

    public static <T> EquivalentConverter<T> handle(final Function<T, Object> toHandle, final Function<Object, T> fromHandle, final Class<T> specificType) {
        return new EquivalentConverter<T>(){

            @Override
            public T getSpecific(Object generic) {
                return fromHandle.apply(generic);
            }

            @Override
            public Object getGeneric(T specific) {
                return toHandle.apply(specific);
            }

            @Override
            public Class<T> getSpecificType() {
                return specificType;
            }
        };
    }

    public static <T> EquivalentConverter<T[]> array(final Class<?> nmsClass, final EquivalentConverter<T> converter) {
        return new EquivalentConverter<T[]>(){

            @Override
            public T[] getSpecific(Object generic) {
                Object[] array = (Object[])generic;
                Class<T[]> clazz = this.getSpecificType();
                T[] result = clazz.cast(Array.newInstance(clazz.getComponentType(), array.length));
                for (int i = 0; i < result.length; ++i) {
                    result[i] = converter.getSpecific(array[i]);
                }
                return result;
            }

            @Override
            public Object getGeneric(T[] specific) {
                Object[] result = (Object[])Array.newInstance(nmsClass, specific.length);
                for (int i = 0; i < result.length; ++i) {
                    result[i] = converter.getGeneric(specific[i]);
                }
                return result;
            }

            @Override
            public Class<T[]> getSpecificType() {
                return MinecraftReflection.getArrayClass(converter.getSpecificType());
            }
        };
    }

    public static <T> EquivalentConverter<Optional<T>> optional(final EquivalentConverter<T> converter) {
        return new EquivalentConverter<Optional<T>>(){

            @Override
            public Object getGeneric(Optional<T> specific) {
                return specific.map(converter::getGeneric);
            }

            @Override
            public Optional<T> getSpecific(Object generic) {
                Optional optional = (Optional)generic;
                return optional.map(converter::getSpecific);
            }

            @Override
            public Class<Optional<T>> getSpecificType() {
                return Optional.empty().getClass();
            }
        };
    }
}

