/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers.nbt.io;

import com.comphenix.protocol.reflect.FieldAccessException;
import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.MethodAccessor;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.wrappers.nbt.NbtBase;
import com.comphenix.protocol.wrappers.nbt.NbtCompound;
import com.comphenix.protocol.wrappers.nbt.NbtFactory;
import com.comphenix.protocol.wrappers.nbt.NbtList;
import com.comphenix.protocol.wrappers.nbt.NbtWrapper;
import java.io.DataInput;
import java.io.DataOutput;
import java.lang.reflect.Method;

public class NbtBinarySerializer {
    private static final Class<?> NBT_BASE_CLASS = MinecraftReflection.getNBTBaseClass();
    private static Method methodWrite;
    private static LoadMethod loadMethod;
    public static final NbtBinarySerializer DEFAULT;

    public <TType> void serialize(NbtBase<TType> value, DataOutput destination) {
        if (methodWrite == null) {
            Class<?> base = MinecraftReflection.getNBTBaseClass();
            methodWrite = NbtBinarySerializer.getUtilityClass().getMethodByParameters("writeNBT", base, DataOutput.class);
            methodWrite.setAccessible(true);
        }
        try {
            methodWrite.invoke(null, NbtFactory.fromBase(value).getHandle(), destination);
        }
        catch (Exception e) {
            throw new FieldAccessException("Unable to write NBT " + value, e);
        }
    }

    public <TType> NbtWrapper<TType> deserialize(DataInput source) {
        LoadMethod method = loadMethod;
        if (loadMethod == null) {
            if (MinecraftReflection.isUsingNetty()) {
                try {
                    method = new LoadMethodWorldUpdate();
                }
                catch (IllegalArgumentException e) {
                    method = new LoadMethodSkinUpdate();
                }
            } else {
                method = new LoadMethodNbtClass();
            }
            loadMethod = method;
        }
        try {
            return NbtFactory.fromNMS(method.loadNbt(source), null);
        }
        catch (Exception e) {
            throw new FieldAccessException("Unable to read NBT from " + source, e);
        }
    }

    private static MethodAccessor getNbtLoadMethod(Class<?> ... parameters) {
        return Accessors.getMethodAccessor(NbtBinarySerializer.getUtilityClass().getMethodByParameters("load", NBT_BASE_CLASS, parameters), true);
    }

    private static FuzzyReflection getUtilityClass() {
        if (MinecraftReflection.isUsingNetty()) {
            return FuzzyReflection.fromClass(MinecraftReflection.getNbtCompressedStreamToolsClass(), true);
        }
        return FuzzyReflection.fromClass(MinecraftReflection.getNBTBaseClass(), true);
    }

    public NbtCompound deserializeCompound(DataInput source) {
        return (NbtCompound)((Object)this.deserialize(source));
    }

    public <T> NbtList<T> deserializeList(DataInput source) {
        return (NbtList)((Object)this.deserialize(source));
    }

    static /* synthetic */ MethodAccessor access$000(Class[] x0) {
        return NbtBinarySerializer.getNbtLoadMethod(x0);
    }

    static {
        DEFAULT = new NbtBinarySerializer();
    }

    private static interface LoadMethod {
        public Object loadNbt(DataInput var1);
    }

    private static class LoadMethodWorldUpdate
    implements LoadMethod {
        private MethodAccessor accessor = NbtBinarySerializer.access$000(new Class[]{DataInput.class, Integer.TYPE});

        private LoadMethodWorldUpdate() {
        }

        @Override
        public Object loadNbt(DataInput input) {
            return this.accessor.invoke(null, input, 0);
        }
    }

    private static class LoadMethodSkinUpdate
    implements LoadMethod {
        private Class<?> readLimitClass = MinecraftReflection.getNBTReadLimiterClass();
        private Object readLimiter = FuzzyReflection.fromClass(this.readLimitClass).getSingleton();
        private MethodAccessor accessor = NbtBinarySerializer.access$000(new Class[]{DataInput.class, Integer.TYPE, this.readLimitClass});

        private LoadMethodSkinUpdate() {
        }

        @Override
        public Object loadNbt(DataInput input) {
            return this.accessor.invoke(null, input, 0, this.readLimiter);
        }
    }

    private static class LoadMethodNbtClass
    implements LoadMethod {
        private MethodAccessor accessor = NbtBinarySerializer.access$000(new Class[]{DataInput.class});

        private LoadMethodNbtClass() {
        }

        @Override
        public Object loadNbt(DataInput input) {
            return this.accessor.invoke(null, input);
        }
    }
}

