/*
 * Decompiled with CFR 0.152.
 */
package com.andrei1058.bedwars.levels.internal;

import com.andrei1058.bedwars.BedWars;
import com.andrei1058.bedwars.api.arena.team.ITeam;
import com.andrei1058.bedwars.api.events.gameplay.GameEndEvent;
import com.andrei1058.bedwars.api.events.player.PlayerLeaveArenaEvent;
import com.andrei1058.bedwars.api.events.player.PlayerXpGainEvent;
import com.andrei1058.bedwars.api.language.Language;
import com.andrei1058.bedwars.api.language.Messages;
import com.andrei1058.bedwars.configuration.LevelsConfig;
import com.andrei1058.bedwars.levels.internal.PlayerLevel;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class LevelListeners
implements Listener {
    public static LevelListeners instance;

    public LevelListeners() {
        instance = this;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerJoin(PlayerJoinEvent e) {
        UUID u = e.getPlayer().getUniqueId();
        new PlayerLevel(u, 1, 0);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)BedWars.plugin, () -> {
            Object[] levelData = BedWars.getRemoteDatabase().getLevelData(u);
            PlayerLevel.getLevelByPlayer(u).lazyLoad((Integer)levelData[0], (Integer)levelData[1]);
        });
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerQuit(PlayerQuitEvent e) {
        UUID u = e.getPlayer().getUniqueId();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)BedWars.plugin, () -> {
            PlayerLevel pl = PlayerLevel.getLevelByPlayer(u);
            pl.destroy();
        });
    }

    @EventHandler
    public void onGameEnd(GameEndEvent e) {
        Player p1;
        for (UUID p : e.getWinners()) {
            int xpAmountPerTmt;
            ITeam bwt;
            if (PlayerLevel.getLevelByPlayer(p) == null || (p1 = Bukkit.getPlayer((UUID)p)) == null) continue;
            int xpAmount = LevelsConfig.levels.getInt("xp-rewards.game-win");
            if (xpAmount > 0) {
                PlayerLevel.getLevelByPlayer(p).addXp(xpAmount, PlayerXpGainEvent.XpSource.GAME_WIN);
                p1.sendMessage(Language.getMsg(p1, Messages.XP_REWARD_WIN).replace("{xp}", String.valueOf(xpAmount)));
            }
            if ((bwt = e.getArena().getExTeam(p1.getUniqueId())) == null || bwt.getMembersCache().size() <= 1 || (xpAmountPerTmt = LevelsConfig.levels.getInt("xp-rewards.per-teammate")) <= 0) continue;
            int tr = xpAmountPerTmt * bwt.getMembersCache().size();
            PlayerLevel.getLevelByPlayer(p).addXp(tr, PlayerXpGainEvent.XpSource.PER_TEAMMATE);
            p1.sendMessage(Language.getMsg(p1, "xp-reward-per-teammate").replace("{xp}", String.valueOf(tr)));
        }
        for (UUID p : e.getLosers()) {
            int xpAmountPerTmt;
            ITeam bwt;
            if (PlayerLevel.getLevelByPlayer(p) == null || (p1 = Bukkit.getPlayer((UUID)p)) == null || (bwt = e.getArena().getExTeam(p1.getUniqueId())) == null || bwt.getMembersCache().size() <= 1 || (xpAmountPerTmt = LevelsConfig.levels.getInt("xp-rewards.per-teammate")) <= 0) continue;
            int tr = LevelsConfig.levels.getInt("xp-rewards.per-teammate") * bwt.getMembersCache().size();
            PlayerLevel.getLevelByPlayer(p).addXp(tr, PlayerXpGainEvent.XpSource.PER_TEAMMATE);
            p1.sendMessage(Language.getMsg(p1, Messages.XP_REWARD_PER_TEAMMATE).replace("{xp}", String.valueOf(tr)));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onArenaLeave(PlayerLeaveArenaEvent e) {
        UUID u = e.getPlayer().getUniqueId();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)BedWars.plugin, () -> {
            PlayerLevel pl = PlayerLevel.getLevelByPlayer(u);
            if (pl != null) {
                pl.updateDatabase();
            }
        });
    }
}

