/*
 * Decompiled with CFR 0.152.
 */
package com.andrei1058.bedwars.libs.sidebar;

import com.andrei1058.bedwars.libs.sidebar.CustomScore_v1_15_R1;
import com.andrei1058.bedwars.libs.sidebar.PlaceholderProvider;
import com.andrei1058.bedwars.libs.sidebar.PlayerList;
import com.andrei1058.bedwars.libs.sidebar.SidebarLine;
import com.andrei1058.bedwars.libs.sidebar.SidebarManager;
import com.andrei1058.bedwars.libs.sidebar.Sidebar_v1_15_R1;
import java.util.Collections;
import java.util.LinkedList;
import javax.annotation.Nullable;
import net.minecraft.server.v1_15_R1.ChatComponentText;
import net.minecraft.server.v1_15_R1.IChatBaseComponent;
import net.minecraft.server.v1_15_R1.Packet;
import net.minecraft.server.v1_15_R1.PacketPlayOutScoreboardTeam;
import net.minecraft.server.v1_15_R1.PlayerConnection;
import net.minecraft.server.v1_15_R1.ScoreboardTeam;
import net.minecraft.server.v1_15_R1.ScoreboardTeamBase;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class PlayerList_v1_15_R1
extends ScoreboardTeam
implements PlayerList {
    private final boolean disablePushing;
    private SidebarLine prefix;
    private SidebarLine suffix;
    private final Sidebar_v1_15_R1 sidebar;
    private final LinkedList<PlaceholderProvider> placeholderProviders = new LinkedList();
    private final Player player;
    private ScoreboardTeamBase.EnumNameTagVisibility nameTagVisibility = ScoreboardTeamBase.EnumNameTagVisibility.ALWAYS;

    public PlayerList_v1_15_R1(@NotNull Sidebar_v1_15_R1 sidebar, @NotNull Player player, SidebarLine prefix, SidebarLine suffix, boolean disablePushing) {
        super(null, player.getName());
        this.suffix = suffix;
        this.prefix = prefix;
        this.sidebar = sidebar;
        this.player = player;
        this.disablePushing = disablePushing;
        this.getPlayerNameSet().add(player.getName());
    }

    public void setPrefix(@Nullable IChatBaseComponent var0) {
    }

    public IChatBaseComponent getFormattedName(IChatBaseComponent var0) {
        return new ChatComponentText(this.prefix.getLine()).addSibling((IChatBaseComponent)(this.player == null ? var0 : new ChatComponentText(this.player.getDisplayName()))).addSibling((IChatBaseComponent)new ChatComponentText(this.suffix.getLine()));
    }

    public ScoreboardTeamBase.EnumTeamPush getCollisionRule() {
        return this.disablePushing ? ScoreboardTeamBase.EnumTeamPush.NEVER : super.getCollisionRule();
    }

    public IChatBaseComponent getPrefix() {
        String t = this.prefix.getLine();
        for (PlaceholderProvider placeholderProvider : this.placeholderProviders) {
            if (!t.contains(placeholderProvider.getPlaceholder())) continue;
            t = t.replace(placeholderProvider.getPlaceholder(), placeholderProvider.getReplacement());
        }
        t = SidebarManager.getPapiSupport().replacePlaceholders(this.player, t);
        if (t.length() > 16) {
            t = t.substring(0, 16);
        }
        return new ChatComponentText(t);
    }

    public void setSuffix(@Nullable IChatBaseComponent var0) {
    }

    public IChatBaseComponent getSuffix() {
        String t = this.suffix.getLine();
        for (PlaceholderProvider placeholderProvider : this.placeholderProviders) {
            if (!t.contains(placeholderProvider.getPlaceholder())) continue;
            t = t.replace(placeholderProvider.getPlaceholder(), placeholderProvider.getReplacement());
        }
        t = SidebarManager.getPapiSupport().replacePlaceholders(this.player, t);
        if (t.length() > 16) {
            t = t.substring(0, 16);
        }
        return new ChatComponentText(t);
    }

    public void setAllowFriendlyFire(boolean b2) {
    }

    public void setCanSeeFriendlyInvisibles(boolean b2) {
    }

    public void setNameTagVisibility(ScoreboardTeamBase.EnumNameTagVisibility enumNameTagVisibility) {
        this.nameTagVisibility = enumNameTagVisibility;
    }

    public ScoreboardTeamBase.EnumNameTagVisibility getNameTagVisibility() {
        return this.nameTagVisibility;
    }

    @Override
    public void setPrefix(SidebarLine line) {
        this.prefix = line;
    }

    @Override
    public void setSuffix(SidebarLine line) {
        this.suffix = line;
    }

    @Override
    public void addPlayer(String name) {
        this.getPlayerNameSet().add(name);
        CustomScore_v1_15_R1.sendScore(this.sidebar, name, 20);
        PacketPlayOutScoreboardTeam packetPlayOutScoreboardTeam = new PacketPlayOutScoreboardTeam((ScoreboardTeam)this, Collections.singleton(name), 3);
        this.sidebar.players.forEach(c -> c.sendPacket((Packet)packetPlayOutScoreboardTeam));
    }

    @Override
    public void removePlayer(String name) {
        this.getPlayerNameSet().remove(name);
        PacketPlayOutScoreboardTeam packetPlayOutScoreboardTeam = new PacketPlayOutScoreboardTeam((ScoreboardTeam)this, Collections.singleton(name), 4);
        this.sidebar.players.forEach(c -> c.sendPacket((Packet)packetPlayOutScoreboardTeam));
    }

    @Override
    public void refreshAnimations() {
    }

    @Override
    public void addPlaceholderProvider(PlaceholderProvider placeholderProvider) {
        this.placeholderProviders.remove(placeholderProvider);
        this.placeholderProviders.add(placeholderProvider);
        this.placeholderProviders.forEach(c -> {
            if (this.prefix.getLine().contains(c.getPlaceholder())) {
                this.prefix.setHasPlaceholders(true);
            }
            if (this.suffix.getLine().contains(c.getPlaceholder())) {
                this.suffix.setHasPlaceholders(true);
            }
        });
    }

    @Override
    public void hideNameTag() {
        this.setNameTagVisibility(ScoreboardTeamBase.EnumNameTagVisibility.NEVER);
        this.sendUpdate();
    }

    @Override
    public void showNameTag() {
        this.setNameTagVisibility(ScoreboardTeamBase.EnumNameTagVisibility.ALWAYS);
        this.sendUpdate();
    }

    @Override
    public void removePlaceholderProvider(String identifier) {
        this.placeholderProviders.removeIf(p -> p.getPlaceholder().equalsIgnoreCase(identifier));
    }

    public void sendCreate(@NotNull PlayerConnection playerConnection) {
        PacketPlayOutScoreboardTeam packetPlayOutScoreboardTeam = new PacketPlayOutScoreboardTeam((ScoreboardTeam)this, 0);
        playerConnection.sendPacket((Packet)packetPlayOutScoreboardTeam);
    }

    public void sendUpdate() {
        PacketPlayOutScoreboardTeam packetPlayOutScoreboardTeam = new PacketPlayOutScoreboardTeam((ScoreboardTeam)this, 2);
        this.sidebar.players.forEach(c -> c.sendPacket((Packet)packetPlayOutScoreboardTeam));
    }

    public void sendRemove(@NotNull PlayerConnection playerConnection) {
        PacketPlayOutScoreboardTeam packetPlayOutScoreboardTeam = new PacketPlayOutScoreboardTeam((ScoreboardTeam)this, 1);
        playerConnection.sendPacket((Packet)packetPlayOutScoreboardTeam);
    }
}

