/*
 * Decompiled with CFR 0.152.
 */
package com.andrei1058.bedwars.libs.sidebar;

import com.andrei1058.bedwars.libs.sidebar.CustomScore_v1_17_R1;
import com.andrei1058.bedwars.libs.sidebar.PlaceholderProvider;
import com.andrei1058.bedwars.libs.sidebar.PlayerList_v1_17_R1;
import com.andrei1058.bedwars.libs.sidebar.Sidebar;
import com.andrei1058.bedwars.libs.sidebar.SidebarLine;
import com.andrei1058.bedwars.libs.sidebar.SidebarLineAnimated;
import com.andrei1058.bedwars.libs.sidebar.SidebarManager;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.network.chat.ChatComponentText;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardDisplayObjective;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardObjective;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardScore;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardTeam;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.world.scores.ScoreboardObjective;
import net.minecraft.world.scores.ScoreboardScore;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import net.minecraft.world.scores.criteria.IScoreboardCriteria;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class Sidebar_v1_17_R1
implements Sidebar {
    private final LinkedList<ScoreLine> lines = new LinkedList();
    public LinkedList<PlayerConnection> players = new LinkedList();
    private final LinkedList<PlaceholderProvider> placeholderProviders = new LinkedList();
    private final LinkedList<String> availableColors = new LinkedList();
    protected SidebarObjective healthObjective = null;
    private final ConcurrentHashMap<String, PlayerList_v1_17_R1> teamLists = new ConcurrentHashMap();
    private final SidebarObjective sidebarObjective;

    public Sidebar_v1_17_R1(@NotNull SidebarLine title, @NotNull Collection<SidebarLine> lines, Collection<PlaceholderProvider> placeholderProvider) {
        for (ChatColor chatColor : ChatColor.values()) {
            this.availableColors.add(chatColor.toString());
        }
        this.sidebarObjective = new SidebarObjective("Sidebar", IScoreboardCriteria.a, title, 1);
        this.placeholderProviders.addAll(placeholderProvider);
        for (SidebarLine l : lines) {
            this.addLine(l);
        }
    }

    @Override
    public void setTitle(SidebarLine title) {
        this.sidebarObjective.displayName = title;
        this.sidebarObjective.sendUpdate();
    }

    @Override
    public void addPlaceholder(PlaceholderProvider placeholderProvider) {
        this.placeholderProviders.remove(placeholderProvider);
        this.placeholderProviders.add(placeholderProvider);
        block0: for (ScoreLine line : this.lines) {
            if (line.text.isHasPlaceholders()) continue;
            if (line.text instanceof SidebarLineAnimated) {
                for (String string : ((SidebarLineAnimated)line.text).getLines()) {
                    if (!string.contains(placeholderProvider.getPlaceholder())) continue;
                    line.text.setHasPlaceholders(true);
                    continue block0;
                }
                continue;
            }
            if (!line.text.getLine().contains(placeholderProvider.getPlaceholder())) continue;
            line.text.setHasPlaceholders(true);
        }
    }

    @Override
    public void addLine(SidebarLine sidebarLine) {
        int score = this.getAvailableScore();
        if (score == -1) {
            return;
        }
        Sidebar_v1_17_R1.scoreOffsetIncrease(this.lines);
        String color = this.availableColors.get(0);
        this.availableColors.remove(0);
        ScoreLine s = new ScoreLine(sidebarLine, score == 0 ? score : score - 1, color);
        s.sendCreate();
        this.lines.add(s);
        this.order();
    }

    @Override
    public void setLine(SidebarLine sidebarLine, int line) {
        if (line >= 0 && line < this.lines.size()) {
            ScoreLine s = this.lines.get(line);
            for (PlaceholderProvider placeholder : this.placeholderProviders) {
                if (!sidebarLine.getLine().contains(placeholder.getPlaceholder())) continue;
                sidebarLine.setHasPlaceholders(true);
            }
            s.setText(sidebarLine);
        }
    }

    private int getAvailableScore() {
        if (this.lines.isEmpty()) {
            return 0;
        }
        if (this.lines.size() == 16) {
            return -1;
        }
        return this.lines.getFirst().getScore();
    }

    private void order() {
        Collections.sort(this.lines);
    }

    @Override
    public void apply(Player player) {
        PlayerConnection playerConnection = ((CraftPlayer)player).getHandle().b;
        this.sidebarObjective.sendCreate(playerConnection);
        for (ScoreLine scoreLine : this.lines) {
            scoreLine.sendCreate(playerConnection);
        }
        this.players.add(playerConnection);
        if (this.healthObjective != null) {
            this.healthObjective.sendCreate(playerConnection);
            for (Map.Entry entry : this.teamLists.entrySet()) {
                ((PlayerList_v1_17_R1)entry.getValue()).sendCreate(playerConnection);
            }
        }
    }

    @Override
    public void refreshPlaceholders() {
        for (ScoreLine line : this.lines) {
            if (!line.text.isHasPlaceholders()) continue;
            String content = line.text.getLine();
            for (PlaceholderProvider pp : this.placeholderProviders) {
                if (!content.contains(pp.getPlaceholder())) continue;
                content = content.replace(pp.getPlaceholder(), pp.getReplacement());
            }
            line.setContent(content);
            line.sendUpdate();
        }
    }

    @Override
    public void refreshTitle() {
        this.sidebarObjective.sendUpdate();
    }

    @Override
    public void refreshAnimatedLines() {
        for (ScoreLine line : this.lines) {
            if (!(line.text instanceof SidebarLineAnimated)) continue;
            if (line.text.isHasPlaceholders()) {
                String content = line.text.getLine();
                for (PlaceholderProvider pp : this.placeholderProviders) {
                    if (!content.contains(pp.getPlaceholder())) continue;
                    content = content.replace(pp.getPlaceholder(), pp.getReplacement());
                }
                line.setContent(content);
            } else {
                line.setContent(line.text.getLine());
            }
            line.sendUpdate();
        }
    }

    @Override
    public void removeLine(int line) {
        if (line >= 0 && line < this.lines.size()) {
            ScoreLine scoreLine = this.lines.get(line);
            scoreLine.remove();
            this.lines.remove(line);
            Sidebar_v1_17_R1.scoreOffsetDecrease(this.lines.subList(line, this.lines.size()));
        }
    }

    @Override
    public int linesAmount() {
        return this.lines.size();
    }

    @Override
    public void removePlaceholder(String placeholder) {
        this.placeholderProviders.removeIf(p -> p.getPlaceholder().equalsIgnoreCase(placeholder));
    }

    @Override
    public List<PlaceholderProvider> getPlaceholders() {
        return Collections.unmodifiableList(this.placeholderProviders);
    }

    @Override
    public void playerListCreate(Player player, SidebarLine prefix, SidebarLine suffix, boolean disableCollisions) {
        this.playerListRemove(player.getName());
        PlayerList_v1_17_R1 team = new PlayerList_v1_17_R1(this, player, prefix, suffix, disableCollisions);
        for (PlayerConnection playerConnection : this.players) {
            team.sendCreate(playerConnection);
        }
        this.teamLists.put(player.getName(), team);
    }

    @Override
    public void playerListAddPlaceholders(Player player, PlaceholderProvider[] placeholderProviders) {
        PlayerList_v1_17_R1 list = this.teamLists.getOrDefault(player.getName(), null);
        if (list == null) {
            return;
        }
        for (PlaceholderProvider placeholderProvider : placeholderProviders) {
            list.addPlaceholderProvider(placeholderProvider);
        }
        list.sendUpdate();
    }

    @Override
    public void playerListRemovePlaceholder(Player player, String placeholder) {
        PlayerList_v1_17_R1 list = this.teamLists.getOrDefault(player.getName(), null);
        if (list == null) {
            return;
        }
        list.removePlaceholderProvider(placeholder);
        list.sendUpdate();
    }

    @Override
    public void playerListRemove(String teamName) {
        PlayerList_v1_17_R1 list = this.teamLists.remove(teamName);
        if (list != null) {
            this.players.forEach(list::sendRemove);
        }
    }

    @Override
    public void playerListClear() {
        for (Map.Entry<String, PlayerList_v1_17_R1> entry : this.teamLists.entrySet()) {
            for (PlayerConnection player : this.players) {
                entry.getValue().sendRemove(player);
            }
        }
        this.teamLists.clear();
    }

    @Override
    public void playerListHideNameTag(@NotNull Player player) {
        PlayerList_v1_17_R1 listed = this.teamLists.get(player.getName());
        if (listed != null) {
            listed.hideNameTag();
        }
    }

    @Override
    public void playerListRestoreNameTag(@NotNull Player player) {
        PlayerList_v1_17_R1 listed = this.teamLists.get(player.getName());
        if (listed != null) {
            listed.showNameTag();
        }
    }

    @Override
    public void showPlayersHealth(SidebarLine displayName, boolean list) {
        if (this.healthObjective == null) {
            this.healthObjective = new SidebarObjective(list ? "health" : "health2", IScoreboardCriteria.f, displayName, 2);
            for (PlayerConnection playerConnection : this.players) {
                this.healthObjective.sendCreate(playerConnection);
            }
        } else {
            this.healthObjective.sendUpdate();
        }
    }

    @Override
    public void hidePlayersHealth() {
        if (this.healthObjective != null) {
            for (PlayerConnection player : this.players) {
                this.healthObjective.sendRemove(player);
            }
            this.healthObjective = null;
        }
    }

    @Override
    public void refreshHealthAnimation() {
        if (this.healthObjective != null && this.healthObjective.displayName instanceof SidebarLineAnimated) {
            this.healthObjective.sendUpdate();
        }
    }

    @Override
    public void refreshHealth(Player player, int health) {
        if (health < 0) {
            health = 0;
        }
        CustomScore_v1_17_R1.sendScore(this, player.getName(), health);
    }

    @Override
    public void playerListRefreshAnimation() {
        for (Map.Entry<String, PlayerList_v1_17_R1> entry : this.teamLists.entrySet()) {
            entry.getValue().sendUpdate();
        }
    }

    @Override
    public void remove(UUID player) {
        this.players.removeIf(p -> p.b.getUniqueID().equals(player));
        Player p2 = Bukkit.getPlayer((UUID)player);
        if (p2 != null) {
            PlayerConnection playerConnection = ((CraftPlayer)p2).getHandle().b;
            this.teamLists.forEach((b2, c) -> c.sendRemove(playerConnection));
            this.lines.forEach(line -> line.sendRemove(playerConnection));
            this.sidebarObjective.sendRemove(playerConnection);
            if (this.healthObjective != null) {
                this.healthObjective.sendRemove(playerConnection);
            }
        }
    }

    private static void scoreOffsetIncrease(@NotNull Collection<ScoreLine> lineCollections) {
        for (ScoreLine line : lineCollections) {
            line.setScore(line.getScore() + 1);
        }
    }

    private static void scoreOffsetDecrease(@NotNull Collection<ScoreLine> lineCollections) {
        for (ScoreLine line : lineCollections) {
            line.setScore(line.getScore() - 1);
        }
    }

    protected class SidebarObjective
    extends ScoreboardObjective {
        private SidebarLine displayName;
        private final int type;

        public SidebarObjective(String name, IScoreboardCriteria criteria, SidebarLine displayName, int type) {
            super(null, name, criteria, (IChatBaseComponent)new ChatComponentText(name), IScoreboardCriteria.EnumScoreboardHealthDisplay.a);
            this.displayName = displayName;
            this.type = type;
        }

        public String getName() {
            return super.getName();
        }

        public IChatBaseComponent getDisplayName() {
            String t = this.displayName.getLine();
            if (t.length() > 16) {
                t = t.substring(0, 16);
            }
            return new ChatComponentText(t);
        }

        public void setDisplayName(IChatBaseComponent var0) {
        }

        public IChatBaseComponent e() {
            return new ChatComponentText(this.getDisplayName().getText());
        }

        public void setRenderType(IScoreboardCriteria.EnumScoreboardHealthDisplay var0) {
        }

        private void sendCreate(@NotNull PlayerConnection playerConnection) {
            PacketPlayOutScoreboardObjective packetPlayOutScoreboardObjective = new PacketPlayOutScoreboardObjective((ScoreboardObjective)this, 0);
            playerConnection.sendPacket((Packet)packetPlayOutScoreboardObjective);
            PacketPlayOutScoreboardDisplayObjective packetPlayOutScoreboardDisplayObjective = new PacketPlayOutScoreboardDisplayObjective(this.type, (ScoreboardObjective)this);
            playerConnection.sendPacket((Packet)packetPlayOutScoreboardDisplayObjective);
            if (this.getName().equalsIgnoreCase("health")) {
                PacketPlayOutScoreboardDisplayObjective packetPlayOutScoreboardDisplayObjective2 = new PacketPlayOutScoreboardDisplayObjective(0, (ScoreboardObjective)this);
                playerConnection.sendPacket((Packet)packetPlayOutScoreboardDisplayObjective2);
            }
        }

        private void sendUpdate() {
            PacketPlayOutScoreboardObjective packetPlayOutScoreboardObjective = new PacketPlayOutScoreboardObjective((ScoreboardObjective)this, 2);
            for (PlayerConnection playerConnection : Sidebar_v1_17_R1.this.players) {
                playerConnection.sendPacket((Packet)packetPlayOutScoreboardObjective);
            }
        }

        public void sendRemove(@NotNull PlayerConnection playerConnection) {
            PacketPlayOutScoreboardObjective packetPlayOutScoreboardObjective = new PacketPlayOutScoreboardObjective((ScoreboardObjective)this, 1);
            playerConnection.sendPacket((Packet)packetPlayOutScoreboardObjective);
        }
    }

    private class ScoreLine
    extends ScoreboardScore
    implements Comparable<ScoreLine> {
        private int score;
        private String prefix;
        private String suffix;
        private TeamLine team;
        private SidebarLine text;

        public ScoreLine(SidebarLine text, @NotNull int score, String color) {
            super(null, (ScoreboardObjective)Sidebar_v1_17_R1.this.sidebarObjective, color);
            this.prefix = " ";
            this.suffix = "";
            this.score = score;
            this.text = text;
            this.team = new TeamLine(color);
            if (!text.isHasPlaceholders()) {
                for (PlaceholderProvider provider : Sidebar_v1_17_R1.this.placeholderProviders) {
                    if (!text.getLine().contains(provider.getPlaceholder())) continue;
                    text.setHasPlaceholders(true);
                }
                if (!text.isHasPlaceholders()) {
                    if (text instanceof SidebarLineAnimated) {
                        for (String line : ((SidebarLineAnimated)text).getLines()) {
                            if (!SidebarManager.getPapiSupport().hasPlaceholders(line)) continue;
                            text.setHasPlaceholders(true);
                            break;
                        }
                    } else if (SidebarManager.getPapiSupport().hasPlaceholders(text.getLine())) {
                        text.setHasPlaceholders(true);
                    }
                }
            }
            if (text.isHasPlaceholders()) {
                String content = text.getLine();
                for (PlaceholderProvider pp : Sidebar_v1_17_R1.this.placeholderProviders) {
                    if (!content.contains(pp.getPlaceholder())) continue;
                    content = content.replace(pp.getPlaceholder(), pp.getReplacement());
                }
                this.setContent(content);
            } else {
                this.setContent(text.getLine());
            }
        }

        private void setText(@NotNull SidebarLine text) {
            if (!text.isHasPlaceholders()) {
                if (text instanceof SidebarLineAnimated) {
                    for (String line : ((SidebarLineAnimated)text).getLines()) {
                        if (!SidebarManager.getPapiSupport().hasPlaceholders(line)) continue;
                        text.setHasPlaceholders(true);
                        break;
                    }
                } else if (SidebarManager.getPapiSupport().hasPlaceholders(text.getLine())) {
                    text.setHasPlaceholders(true);
                }
            }
            this.text = text;
            this.setContent(text.getLine());
            this.sendUpdate();
        }

        private void sendCreate(@NotNull PlayerConnection playerConnection) {
            PacketPlayOutScoreboardTeam packetPlayOutScoreboardTeam = PacketPlayOutScoreboardTeam.a((ScoreboardTeam)this.team, (boolean)true);
            playerConnection.sendPacket((Packet)packetPlayOutScoreboardTeam);
            PacketPlayOutScoreboardScore packetPlayOutScoreboardScore = new PacketPlayOutScoreboardScore(ScoreboardServer.Action.a, Sidebar_v1_17_R1.this.sidebarObjective.getName(), this.getPlayerName(), this.getScore());
            playerConnection.sendPacket((Packet)packetPlayOutScoreboardScore);
        }

        private void sendCreate() {
            PacketPlayOutScoreboardTeam packetPlayOutScoreboardTeam = PacketPlayOutScoreboardTeam.a((ScoreboardTeam)this.team, (boolean)true);
            for (PlayerConnection playerConnection : Sidebar_v1_17_R1.this.players) {
                playerConnection.sendPacket((Packet)packetPlayOutScoreboardTeam);
            }
            PacketPlayOutScoreboardScore packetPlayOutScoreboardScore = new PacketPlayOutScoreboardScore(ScoreboardServer.Action.a, Sidebar_v1_17_R1.this.sidebarObjective.getName(), this.getPlayerName(), this.getScore());
            for (PlayerConnection playerConnection : Sidebar_v1_17_R1.this.players) {
                playerConnection.sendPacket((Packet)packetPlayOutScoreboardScore);
            }
        }

        private void sendRemove(PlayerConnection player) {
            PacketPlayOutScoreboardTeam packetPlayOutScoreboardTeam = PacketPlayOutScoreboardTeam.a((ScoreboardTeam)this.team, (boolean)true);
            PacketPlayOutScoreboardScore packetPlayOutScoreboardScore = new PacketPlayOutScoreboardScore(ScoreboardServer.Action.b, Sidebar_v1_17_R1.this.sidebarObjective.getName(), this.getPlayerName(), this.getScore());
            player.sendPacket((Packet)packetPlayOutScoreboardTeam);
            player.sendPacket((Packet)packetPlayOutScoreboardScore);
        }

        private void remove() {
            PacketPlayOutScoreboardTeam packetPlayOutScoreboardTeam = PacketPlayOutScoreboardTeam.a((ScoreboardTeam)this.team);
            for (PlayerConnection playerConnection : Sidebar_v1_17_R1.this.players) {
                playerConnection.sendPacket((Packet)packetPlayOutScoreboardTeam);
            }
            PacketPlayOutScoreboardScore packetPlayOutScoreboardScore = new PacketPlayOutScoreboardScore(ScoreboardServer.Action.b, Sidebar_v1_17_R1.this.sidebarObjective.getName(), this.getPlayerName(), this.getScore());
            for (PlayerConnection playerConnection : Sidebar_v1_17_R1.this.players) {
                playerConnection.sendPacket((Packet)packetPlayOutScoreboardScore);
            }
            Sidebar_v1_17_R1.this.availableColors.add(this.getColor());
            this.text = null;
            this.team = null;
            this.prefix = null;
            this.suffix = null;
        }

        @Contract(pure=true)
        private void setContent(@NotNull String content) {
            if (!Sidebar_v1_17_R1.this.players.isEmpty()) {
                content = SidebarManager.getPapiSupport().replacePlaceholders((Player)Sidebar_v1_17_R1.this.players.get(0).d().getBukkitEntity(), content);
            }
            if (content.length() > 16) {
                this.prefix = content.substring(0, 16);
                if (this.prefix.charAt(15) == '\u00a7') {
                    this.prefix = content.substring(0, 15);
                    this.setSuffix(content.substring(15));
                } else {
                    this.setSuffix(content.substring(16));
                }
            } else {
                this.prefix = content;
                this.suffix = "";
            }
        }

        public void setSuffix(@NotNull String secondPart) {
            if (((String)secondPart).isEmpty()) {
                this.suffix = "";
                return;
            }
            secondPart = ChatColor.getLastColors((String)this.prefix) + (String)secondPart;
            this.suffix = ((String)secondPart).length() > 16 ? ((String)secondPart).substring(0, 16) : secondPart;
        }

        private void sendUpdate() {
            PacketPlayOutScoreboardTeam packetPlayOutScoreboardTeam = PacketPlayOutScoreboardTeam.a((ScoreboardTeam)this.team, (boolean)false);
            for (PlayerConnection playerConnection : Sidebar_v1_17_R1.this.players) {
                playerConnection.sendPacket((Packet)packetPlayOutScoreboardTeam);
            }
        }

        @Override
        public int compareTo(@NotNull ScoreLine o) {
            return Integer.compare(this.score, o.score);
        }

        public void setScore(int score) {
            this.score = score;
            PacketPlayOutScoreboardScore packetPlayOutScoreboardScore = new PacketPlayOutScoreboardScore(ScoreboardServer.Action.a, Sidebar_v1_17_R1.this.sidebarObjective.getName(), this.getPlayerName(), score);
            for (PlayerConnection playerConnection : Sidebar_v1_17_R1.this.players) {
                playerConnection.sendPacket((Packet)packetPlayOutScoreboardScore);
            }
        }

        public int getScore() {
            return this.score;
        }

        public void c() {
        }

        public void addScore(int i) {
        }

        public void incrementScore() {
        }

        public String getColor() {
            return this.team.getName().charAt(0) == '\u00a7' ? this.team.getName() : "\u00a7" + this.team.getName();
        }

        private class TeamLine
        extends ScoreboardTeam {
            public TeamLine(String color) {
                super(null, color);
                this.getPlayerNameSet().add(color);
            }

            public void setPrefix(@Nullable IChatBaseComponent var0) {
                super.setPrefix(var0);
            }

            public IChatBaseComponent getPrefix() {
                return new ChatComponentText(ScoreLine.this.prefix);
            }

            public void setSuffix(@Nullable IChatBaseComponent var0) {
            }

            public IChatBaseComponent getSuffix() {
                return new ChatComponentText(ScoreLine.this.suffix);
            }

            public void setAllowFriendlyFire(boolean b2) {
            }

            public void setCanSeeFriendlyInvisibles(boolean b2) {
            }

            public void setNameTagVisibility(ScoreboardTeamBase.EnumNameTagVisibility enumNameTagVisibility) {
            }

            public void setCollisionRule(ScoreboardTeamBase.EnumTeamPush var0) {
            }

            public void setColor(EnumChatFormat var0) {
            }

            public IChatMutableComponent getFormattedName(IChatBaseComponent var0) {
                return new ChatComponentText(ScoreLine.this.prefix).addSibling(var0).addSibling((IChatBaseComponent)new ChatComponentText(ScoreLine.this.suffix));
            }
        }
    }
}

