/*
 * Decompiled with CFR 0.152.
 */
package com.andrei1058.bedwars.libs.sidebar;

import com.andrei1058.bedwars.libs.sidebar.CustomScore_v1_9_R2;
import com.andrei1058.bedwars.libs.sidebar.PlaceholderProvider;
import com.andrei1058.bedwars.libs.sidebar.PlayerList_v1_9_R2;
import com.andrei1058.bedwars.libs.sidebar.Sidebar;
import com.andrei1058.bedwars.libs.sidebar.SidebarLine;
import com.andrei1058.bedwars.libs.sidebar.SidebarLineAnimated;
import com.andrei1058.bedwars.libs.sidebar.SidebarManager;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.v1_9_R2.IScoreboardCriteria;
import net.minecraft.server.v1_9_R2.Packet;
import net.minecraft.server.v1_9_R2.PacketPlayOutScoreboardDisplayObjective;
import net.minecraft.server.v1_9_R2.PacketPlayOutScoreboardObjective;
import net.minecraft.server.v1_9_R2.PacketPlayOutScoreboardScore;
import net.minecraft.server.v1_9_R2.PacketPlayOutScoreboardTeam;
import net.minecraft.server.v1_9_R2.PlayerConnection;
import net.minecraft.server.v1_9_R2.ScoreboardObjective;
import net.minecraft.server.v1_9_R2.ScoreboardScore;
import net.minecraft.server.v1_9_R2.ScoreboardTeam;
import net.minecraft.server.v1_9_R2.ScoreboardTeamBase;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.craftbukkit.v1_9_R2.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

class Sidebar_v1_9_R2
implements Sidebar {
    private final LinkedList<ScoreLine> lines = new LinkedList();
    protected LinkedList<PlayerConnection> players = new LinkedList();
    protected LinkedList<PlaceholderProvider> placeholderProviders = new LinkedList();
    private final LinkedList<String> availableColors = new LinkedList();
    private final SidebarObjective sidebarObjective;
    protected SidebarObjective healthObjective = null;
    private final ConcurrentHashMap<String, PlayerList_v1_9_R2> teamLists = new ConcurrentHashMap();

    public Sidebar_v1_9_R2(@NotNull SidebarLine title, @NotNull Collection<SidebarLine> lines, Collection<PlaceholderProvider> placeholderProvider) {
        for (ChatColor chatColor : ChatColor.values()) {
            this.availableColors.add(chatColor.toString());
        }
        this.sidebarObjective = new SidebarObjective("Sidebar", IScoreboardCriteria.b, 1, title);
        this.placeholderProviders.addAll(placeholderProvider);
        for (SidebarLine l : lines) {
            this.addLine(l);
        }
    }

    @Override
    public void setTitle(SidebarLine title) {
        this.sidebarObjective.displayName = title;
        this.sidebarObjective.sendUpdate();
    }

    @Override
    public void playerListHideNameTag(@NotNull Player player) {
        PlayerList_v1_9_R2 listed = this.teamLists.get(player.getName());
        if (listed != null) {
            listed.hideNameTag();
        }
    }

    @Override
    public void playerListRestoreNameTag(@NotNull Player player) {
        PlayerList_v1_9_R2 listed = this.teamLists.get(player.getName());
        if (listed != null) {
            listed.showNameTag();
        }
    }

    @Override
    public void addPlaceholder(PlaceholderProvider placeholderProvider) {
        this.placeholderProviders.remove(placeholderProvider);
        this.placeholderProviders.add(placeholderProvider);
        this.lines.forEach(c -> {
            if (!((ScoreLine)c).text.isHasPlaceholders()) {
                if (((ScoreLine)c).text instanceof SidebarLineAnimated) {
                    for (String line : ((SidebarLineAnimated)((ScoreLine)c).text).getLines()) {
                        if (!line.contains(placeholderProvider.getPlaceholder())) continue;
                        ((ScoreLine)c).text.setHasPlaceholders(true);
                        break;
                    }
                } else if (((ScoreLine)c).text.getLine().contains(placeholderProvider.getPlaceholder())) {
                    ((ScoreLine)c).text.setHasPlaceholders(true);
                }
            }
        });
    }

    @Override
    public void addLine(SidebarLine sidebarLine) {
        int score = this.getAvailableScore();
        if (score == -1) {
            return;
        }
        Sidebar_v1_9_R2.scoreOffsetIncrease(this.lines);
        String color = this.availableColors.get(0);
        this.availableColors.remove(0);
        ScoreLine s = new ScoreLine(sidebarLine, score == 0 ? score : score - 1, color);
        s.sendCreate();
        this.lines.add(s);
        this.order();
    }

    @Override
    public void setLine(SidebarLine sidebarLine, int line) {
        if (line >= 0 && line < this.lines.size()) {
            ScoreLine s = this.lines.get(line);
            this.placeholderProviders.forEach(c -> {
                if (sidebarLine.getLine().contains(c.getPlaceholder())) {
                    sidebarLine.setHasPlaceholders(true);
                }
            });
            s.setText(sidebarLine);
        }
    }

    private int getAvailableScore() {
        if (this.lines.isEmpty()) {
            return 0;
        }
        if (this.lines.size() == 16) {
            return -1;
        }
        return this.lines.getFirst().getScore();
    }

    private void order() {
        Collections.sort(this.lines);
    }

    @Override
    public void apply(Player player) {
        PlayerConnection playerConnection = ((CraftPlayer)player).getHandle().playerConnection;
        this.sidebarObjective.sendCreate(playerConnection);
        this.lines.forEach(c -> ((ScoreLine)c).sendCreate(playerConnection));
        this.players.add(playerConnection);
        if (this.healthObjective != null) {
            this.healthObjective.sendCreate(playerConnection);
            this.teamLists.forEach((c2, c) -> c.sendCreate(playerConnection));
        }
    }

    @Override
    public void refreshPlaceholders() {
        this.lines.forEach(s -> {
            if (((ScoreLine)s).text.isHasPlaceholders()) {
                String content = ((ScoreLine)s).text.getLine();
                for (PlaceholderProvider pp : this.placeholderProviders) {
                    if (!content.contains(pp.getPlaceholder())) continue;
                    content = content.replace(pp.getPlaceholder(), pp.getReplacement());
                }
                ((ScoreLine)s).setContent(content);
                ((ScoreLine)s).sendUpdate();
            }
        });
    }

    @Override
    public void refreshTitle() {
        this.sidebarObjective.sendUpdate();
    }

    @Override
    public void refreshAnimatedLines() {
        this.lines.forEach(c -> {
            if (((ScoreLine)c).text instanceof SidebarLineAnimated) {
                if (((ScoreLine)c).text.isHasPlaceholders()) {
                    String content = ((ScoreLine)c).text.getLine();
                    for (PlaceholderProvider pp : this.placeholderProviders) {
                        if (!content.contains(pp.getPlaceholder())) continue;
                        content = content.replace(pp.getPlaceholder(), pp.getReplacement());
                    }
                    ((ScoreLine)c).setContent(content);
                } else {
                    ((ScoreLine)c).setContent(((ScoreLine)c).text.getLine());
                }
                ((ScoreLine)c).sendUpdate();
            }
        });
    }

    @Override
    public void removeLine(int line) {
        if (line >= 0 && line < this.lines.size()) {
            ScoreLine scoreLine = this.lines.get(line);
            scoreLine.remove();
            Sidebar_v1_9_R2.scoreOffsetDecrease(this.lines.subList(line, this.lines.size()));
        }
    }

    @Override
    public int linesAmount() {
        return this.lines.size();
    }

    @Override
    public void removePlaceholder(String placeholder) {
        this.placeholderProviders.removeIf(p -> p.getPlaceholder().equalsIgnoreCase(placeholder));
    }

    @Override
    public List<PlaceholderProvider> getPlaceholders() {
        return Collections.unmodifiableList(this.placeholderProviders);
    }

    @Override
    public void playerListCreate(@NotNull Player player, SidebarLine prefix, SidebarLine suffix, boolean disablePushing) {
        this.playerListRemove(player.getName());
        PlayerList_v1_9_R2 team = new PlayerList_v1_9_R2(this, player, prefix, suffix, disablePushing);
        this.players.forEach(team::sendCreate);
        this.teamLists.put(player.getName(), team);
    }

    @Override
    public void playerListAddPlaceholders(@NotNull Player player, PlaceholderProvider ... placeholderProviders) {
        PlayerList_v1_9_R2 list = this.teamLists.getOrDefault(player.getName(), null);
        if (list == null) {
            return;
        }
        for (PlaceholderProvider placeholderProvider : placeholderProviders) {
            list.addPlaceholderProvider(placeholderProvider);
        }
        list.sendUpdate();
    }

    @Override
    public void playerListRemovePlaceholder(@NotNull Player player, String placeholder) {
        PlayerList_v1_9_R2 list = this.teamLists.getOrDefault(player.getName(), null);
        if (list == null) {
            return;
        }
        list.removePlaceholderProvider(placeholder);
        list.sendUpdate();
    }

    @Override
    public void playerListRemove(String teamName) {
        PlayerList_v1_9_R2 list = this.teamLists.remove(teamName);
        if (list != null) {
            this.players.forEach(list::sendRemove);
        }
    }

    @Override
    public void playerListClear() {
        this.teamLists.forEach((a2, b2) -> this.players.forEach(b2::sendRemove));
        this.teamLists.clear();
    }

    @Override
    public void showPlayersHealth(SidebarLine displayName, boolean list) {
        if (this.healthObjective == null) {
            this.healthObjective = new SidebarObjective(list ? "health" : "health2", IScoreboardCriteria.b, 2, displayName);
            this.players.forEach(c -> this.healthObjective.sendCreate(c));
        } else {
            this.healthObjective.sendUpdate();
        }
    }

    @Override
    public void hidePlayersHealth() {
        if (this.healthObjective != null) {
            this.players.forEach(c -> this.healthObjective.sendRemove((PlayerConnection)c));
            this.healthObjective = null;
        }
    }

    @Override
    public void refreshHealthAnimation() {
        if (this.healthObjective != null && this.healthObjective.displayName instanceof SidebarLineAnimated) {
            this.healthObjective.sendUpdate();
        }
    }

    @Override
    public void refreshHealth(@NotNull Player player, int health) {
        if (health < 0) {
            health = 0;
        }
        CustomScore_v1_9_R2.sendScore(this, player.getName(), health);
    }

    @Override
    public void playerListRefreshAnimation() {
        this.teamLists.forEach((a2, b2) -> b2.sendUpdate());
    }

    @Override
    public void remove(UUID player) {
        this.players.removeIf(p -> p.player.getUniqueID().equals(player));
        Player p2 = Bukkit.getPlayer((UUID)player);
        if (p2 != null) {
            PlayerConnection playerConnection = ((CraftPlayer)p2).getHandle().playerConnection;
            this.teamLists.forEach((b2, c) -> c.sendRemove(playerConnection));
            this.lines.forEach(line -> ((ScoreLine)line).sendRemove(playerConnection));
            this.sidebarObjective.sendRemove(playerConnection);
            if (this.healthObjective != null) {
                this.healthObjective.sendRemove(playerConnection);
            }
        }
    }

    private static void scoreOffsetIncrease(@NotNull Collection<ScoreLine> lineCollections) {
        lineCollections.forEach(c -> c.setScore(c.getScore() + 1));
    }

    private static void scoreOffsetDecrease(@NotNull Collection<ScoreLine> lineCollections) {
        lineCollections.forEach(c -> c.setScore(c.getScore() - 1));
    }

    private class SidebarObjective
    extends ScoreboardObjective {
        private final int type;
        private SidebarLine displayName;

        public SidebarObjective(String name, IScoreboardCriteria criteria, int type, SidebarLine displayName) {
            super(null, name, criteria);
            this.type = type;
            this.displayName = displayName;
        }

        public void setDisplayName(String s) {
        }

        public String getDisplayName() {
            String t = this.displayName.getLine();
            if (t.length() > 16) {
                t = t.substring(0, 16);
            }
            return t;
        }

        private void sendCreate(@NotNull PlayerConnection playerConnection) {
            PacketPlayOutScoreboardObjective packetPlayOutScoreboardObjective = new PacketPlayOutScoreboardObjective((ScoreboardObjective)this, 0);
            playerConnection.sendPacket((Packet)packetPlayOutScoreboardObjective);
            PacketPlayOutScoreboardDisplayObjective packetPlayOutScoreboardDisplayObjective = new PacketPlayOutScoreboardDisplayObjective(this.type, (ScoreboardObjective)this);
            playerConnection.sendPacket((Packet)packetPlayOutScoreboardDisplayObjective);
            if (this.getName().equalsIgnoreCase("health")) {
                PacketPlayOutScoreboardDisplayObjective packetPlayOutScoreboardDisplayObjective2 = new PacketPlayOutScoreboardDisplayObjective(0, (ScoreboardObjective)this);
                playerConnection.sendPacket((Packet)packetPlayOutScoreboardDisplayObjective2);
            }
        }

        private void sendUpdate() {
            PacketPlayOutScoreboardObjective packetPlayOutScoreboardObjective = new PacketPlayOutScoreboardObjective((ScoreboardObjective)this, 2);
            Sidebar_v1_9_R2.this.players.forEach(c -> c.sendPacket((Packet)packetPlayOutScoreboardObjective));
        }

        public void sendRemove(@NotNull PlayerConnection playerConnection) {
            Sidebar_v1_9_R2.this.teamLists.forEach((b2, c) -> Sidebar_v1_9_R2.this.players.forEach(c::sendRemove));
            PacketPlayOutScoreboardObjective packetPlayOutScoreboardObjective = new PacketPlayOutScoreboardObjective((ScoreboardObjective)this, 1);
            playerConnection.sendPacket((Packet)packetPlayOutScoreboardObjective);
        }

        public IScoreboardCriteria.EnumScoreboardHealthDisplay e() {
            return IScoreboardCriteria.EnumScoreboardHealthDisplay.INTEGER;
        }
    }

    private class ScoreLine
    extends ScoreboardScore
    implements Comparable<ScoreLine> {
        private int score;
        private String prefix;
        private String suffix;
        private TeamLine team;
        private SidebarLine text;

        public ScoreLine(SidebarLine text, @NotNull int score, String color) {
            super(null, (ScoreboardObjective)Sidebar_v1_9_R2.this.sidebarObjective, color);
            this.prefix = "";
            this.suffix = "";
            this.score = score;
            this.text = text;
            this.team = new TeamLine(color);
            if (!text.isHasPlaceholders()) {
                Sidebar_v1_9_R2.this.placeholderProviders.forEach(c -> {
                    if (text.getLine().contains(c.getPlaceholder())) {
                        text.setHasPlaceholders(true);
                    }
                });
                if (!text.isHasPlaceholders()) {
                    if (text instanceof SidebarLineAnimated) {
                        for (String line : ((SidebarLineAnimated)text).getLines()) {
                            if (!SidebarManager.getPapiSupport().hasPlaceholders(line)) continue;
                            text.setHasPlaceholders(true);
                            break;
                        }
                    } else if (SidebarManager.getPapiSupport().hasPlaceholders(text.getLine())) {
                        text.setHasPlaceholders(true);
                    }
                }
            }
            if (text.isHasPlaceholders()) {
                String content = text.getLine();
                for (PlaceholderProvider pp : Sidebar_v1_9_R2.this.placeholderProviders) {
                    if (!content.contains(pp.getPlaceholder())) continue;
                    content = content.replace(pp.getPlaceholder(), pp.getReplacement());
                }
                this.setContent(content);
            } else {
                this.setContent(text.getLine());
            }
        }

        private void setText(@NotNull SidebarLine text) {
            if (!text.isHasPlaceholders()) {
                if (text instanceof SidebarLineAnimated) {
                    for (String line : ((SidebarLineAnimated)text).getLines()) {
                        if (!SidebarManager.getPapiSupport().hasPlaceholders(line)) continue;
                        text.setHasPlaceholders(true);
                        break;
                    }
                } else if (SidebarManager.getPapiSupport().hasPlaceholders(text.getLine())) {
                    text.setHasPlaceholders(true);
                }
            }
            this.text = text;
            this.setContent(text.getLine());
            this.sendUpdate();
        }

        private void sendCreate(@NotNull PlayerConnection playerConnection) {
            PacketPlayOutScoreboardTeam packetPlayOutScoreboardTeam = new PacketPlayOutScoreboardTeam((ScoreboardTeam)this.team, 0);
            playerConnection.sendPacket((Packet)packetPlayOutScoreboardTeam);
            PacketPlayOutScoreboardScore packetPlayOutScoreboardScore = new PacketPlayOutScoreboardScore((ScoreboardScore)this);
            playerConnection.sendPacket((Packet)packetPlayOutScoreboardScore);
        }

        private void sendCreate() {
            PacketPlayOutScoreboardTeam packetPlayOutScoreboardTeam = new PacketPlayOutScoreboardTeam((ScoreboardTeam)this.team, 0);
            PacketPlayOutScoreboardScore packetPlayOutScoreboardScore = new PacketPlayOutScoreboardScore((ScoreboardScore)this);
            Sidebar_v1_9_R2.this.players.forEach(c -> {
                c.sendPacket((Packet)packetPlayOutScoreboardTeam);
                c.sendPacket((Packet)packetPlayOutScoreboardScore);
            });
        }

        private void sendRemove(PlayerConnection player) {
            PacketPlayOutScoreboardTeam packetPlayOutScoreboardTeam = new PacketPlayOutScoreboardTeam((ScoreboardTeam)this.team, 1);
            PacketPlayOutScoreboardScore packetPlayOutScoreboardScore = new PacketPlayOutScoreboardScore(this.getPlayerName(), (ScoreboardObjective)Sidebar_v1_9_R2.this.sidebarObjective);
            player.sendPacket((Packet)packetPlayOutScoreboardTeam);
            player.sendPacket((Packet)packetPlayOutScoreboardScore);
        }

        private void remove() {
            Sidebar_v1_9_R2.this.lines.remove(this);
            PacketPlayOutScoreboardTeam packetPlayOutScoreboardTeam = new PacketPlayOutScoreboardTeam((ScoreboardTeam)this.team, 1);
            PacketPlayOutScoreboardScore packetPlayOutScoreboardScore = new PacketPlayOutScoreboardScore(this.getPlayerName(), (ScoreboardObjective)Sidebar_v1_9_R2.this.sidebarObjective);
            Sidebar_v1_9_R2.this.players.forEach(c -> {
                c.sendPacket((Packet)packetPlayOutScoreboardTeam);
                c.sendPacket((Packet)packetPlayOutScoreboardScore);
            });
            Sidebar_v1_9_R2.this.availableColors.add(this.getColor());
            this.text = null;
            this.team = null;
            this.prefix = null;
            this.suffix = null;
        }

        @Contract(pure=true)
        private void setContent(@NotNull String content) {
            if (!Sidebar_v1_9_R2.this.players.isEmpty()) {
                content = SidebarManager.getPapiSupport().replacePlaceholders((Player)Sidebar_v1_9_R2.this.players.get(0).getPlayer(), content);
            }
            if (content.length() > 16) {
                this.prefix = content.substring(0, 16);
                if (this.prefix.charAt(15) == '\u00a7') {
                    this.prefix = content.substring(0, 15);
                    this.setSuffix(content.substring(15));
                } else {
                    this.setSuffix(content.substring(16));
                }
            } else {
                this.prefix = content;
                this.suffix = "";
            }
        }

        public void setSuffix(@NotNull String secondPart) {
            if (secondPart.isEmpty()) {
                this.suffix = "";
                return;
            }
            secondPart = ChatColor.getLastColors((String)this.prefix) + secondPart;
            this.suffix = secondPart.length() > 16 ? secondPart.substring(0, 16) : secondPart;
        }

        private void sendUpdate() {
            PacketPlayOutScoreboardTeam packetPlayOutScoreboardTeam = new PacketPlayOutScoreboardTeam((ScoreboardTeam)this.team, 2);
            Sidebar_v1_9_R2.this.players.forEach(c -> c.sendPacket((Packet)packetPlayOutScoreboardTeam));
        }

        @Override
        public int compareTo(@NotNull ScoreLine o) {
            return Integer.compare(this.score, o.score);
        }

        public void setScore(int score) {
            this.score = score;
            PacketPlayOutScoreboardScore packetPlayOutScoreboardScore = new PacketPlayOutScoreboardScore((ScoreboardScore)this);
            Sidebar_v1_9_R2.this.players.forEach(c -> c.sendPacket((Packet)packetPlayOutScoreboardScore));
        }

        public int getScore() {
            return this.score;
        }

        public void addScore(int i) {
        }

        public void incrementScore() {
        }

        public String getColor() {
            return this.team.getName().charAt(0) == '\u00a7' ? this.team.getName() : '\u00a7' + this.team.getName();
        }

        private class TeamLine
        extends ScoreboardTeam {
            public TeamLine(String color) {
                super(null, color);
                this.getPlayerNameSet().add(color);
            }

            public void setPrefix(String prefix) {
            }

            public String getPrefix() {
                return ScoreLine.this.prefix;
            }

            public void setSuffix(String suffix) {
            }

            public String getSuffix() {
                return ScoreLine.this.suffix;
            }

            public void setAllowFriendlyFire(boolean b2) {
            }

            public void setCanSeeFriendlyInvisibles(boolean b2) {
            }

            public void setNameTagVisibility(ScoreboardTeamBase.EnumNameTagVisibility enumNameTagVisibility) {
            }
        }
    }
}

