/*
 * Decompiled with CFR 0.152.
 */
package com.andrei1058.bedwars.listeners;

import com.andrei1058.bedwars.api.arena.GameState;
import com.andrei1058.bedwars.api.arena.IArena;
import com.andrei1058.bedwars.api.events.player.PlayerGeneratorCollectEvent;
import com.andrei1058.bedwars.api.server.ServerType;
import com.andrei1058.bedwars.support.version.common.VersionCommon;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDropItemEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerPickupArrowEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemDropPickListener {
    private static boolean managePickup(Item item, LivingEntity player) {
        if (!(player instanceof Player)) {
            return false;
        }
        if (VersionCommon.api.getServerType() != ServerType.BUNGEE && player.getLocation().getWorld().getName().equalsIgnoreCase(VersionCommon.api.getLobbyWorld())) {
            return true;
        }
        IArena a2 = VersionCommon.api.getArenaUtil().getArenaByPlayer((Player)player);
        if (a2 == null) {
            return false;
        }
        if (!a2.isPlayer((Player)player)) {
            return true;
        }
        if (a2.getStatus() != GameState.playing) {
            return true;
        }
        if (a2.getRespawnSessions().containsKey(player)) {
            return true;
        }
        if (item.getItemStack().getType() == Material.ARROW) {
            item.setItemStack(VersionCommon.api.getVersionSupport().createItemStack(item.getItemStack().getType().toString(), item.getItemStack().getAmount(), (short)0));
            return false;
        }
        if (item.getItemStack().getType().toString().equals("BED")) {
            item.remove();
            return true;
        }
        if (item.getItemStack().hasItemMeta() && item.getItemStack().getItemMeta().hasDisplayName() && item.getItemStack().getItemMeta().getDisplayName().contains("custom")) {
            Material material = item.getItemStack().getType();
            ItemMeta itemMeta = new ItemStack(material).getItemMeta();
            PlayerGeneratorCollectEvent event = new PlayerGeneratorCollectEvent((Player)player, item, a2);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return true;
            }
            item.getItemStack().setItemMeta(itemMeta);
        }
        return false;
    }

    private static boolean manageDrop(Entity player, Item item) {
        if (!(player instanceof Player)) {
            return false;
        }
        if (VersionCommon.api.getServerType() != ServerType.BUNGEE && player.getLocation().getWorld().getName().equalsIgnoreCase(VersionCommon.api.getLobbyWorld())) {
            return true;
        }
        IArena a2 = VersionCommon.api.getArenaUtil().getArenaByPlayer((Player)player);
        if (a2 == null) {
            return false;
        }
        if (!a2.isPlayer((Player)player)) {
            return true;
        }
        if (a2.getStatus() != GameState.playing) {
            return true;
        }
        ItemStack i = item.getItemStack();
        if (i.getType() == Material.COMPASS) {
            return true;
        }
        return a2.getRespawnSessions().containsKey(player);
    }

    public static class GeneratorCollect
    implements Listener {
        @EventHandler
        public void onCollect(PlayerGeneratorCollectEvent e) {
            if (VersionCommon.api.getAFKUtil().isPlayerAFK(e.getPlayer())) {
                e.setCancelled(true);
            }
        }
    }

    public static class ArrowCollect
    implements Listener {
        @EventHandler
        public void onArrowPick(PlayerPickupArrowEvent e) {
            if (VersionCommon.api.getArenaUtil().isSpectating(e.getPlayer())) {
                e.setCancelled(true);
            }
        }
    }

    public static class EntityPickup
    implements Listener {
        @EventHandler
        public void onPickup(EntityPickupItemEvent e) {
            if (ItemDropPickListener.managePickup(e.getItem(), e.getEntity())) {
                e.setCancelled(true);
            }
        }
    }

    public static class EntityDrop
    implements Listener {
        @EventHandler
        public void onDrop(EntityDropItemEvent e) {
            if (ItemDropPickListener.manageDrop(e.getEntity(), e.getItemDrop())) {
                e.setCancelled(true);
            }
        }
    }

    public static class PlayerPickup
    implements Listener {
        @EventHandler
        public void onDrop(PlayerPickupItemEvent e) {
            if (ItemDropPickListener.managePickup(e.getItem(), (LivingEntity)e.getPlayer())) {
                e.setCancelled(true);
            }
        }
    }

    public static class PlayerDrop
    implements Listener {
        @EventHandler
        public void onDrop(PlayerDropItemEvent e) {
            if (ItemDropPickListener.manageDrop((Entity)e.getPlayer(), e.getItemDrop())) {
                e.setCancelled(true);
            }
        }
    }
}

