/*
 * Decompiled with CFR 0.152.
 */
package com.andrei1058.bedwars.listeners;

import com.andrei1058.bedwars.BedWars;
import com.andrei1058.bedwars.api.arena.GameState;
import com.andrei1058.bedwars.api.arena.IArena;
import com.andrei1058.bedwars.api.language.Language;
import com.andrei1058.bedwars.api.server.ServerType;
import com.andrei1058.bedwars.arena.Arena;
import com.andrei1058.bedwars.arena.LastHit;
import com.andrei1058.bedwars.arena.SetupSession;
import com.andrei1058.bedwars.arena.team.BedWarsTeam;
import com.andrei1058.bedwars.commands.bedwars.subcmds.regular.CmdStats;
import com.andrei1058.bedwars.sidebar.BedWarsScoreboard;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;

public class QuitAndTeleportListener
implements Listener {
    @EventHandler
    public void onLeave(PlayerQuitEvent e) {
        BedWarsScoreboard sb;
        SetupSession ss;
        Player p = e.getPlayer();
        IArena a = Arena.getArenaByPlayer(p);
        if (a != null) {
            if (a.isPlayer(p)) {
                a.removePlayer(p, true);
            } else if (a.isSpectator(p)) {
                a.removeSpectator(p, true);
            }
        }
        if (Language.getLangByPlayer().containsKey(p.getUniqueId())) {
            UUID u = p.getUniqueId();
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)BedWars.plugin, () -> {
                String iso = Language.getLangByPlayer().get(p.getUniqueId()).getIso();
                if (Language.isLanguageExist(iso)) {
                    if (BedWars.config.getYml().getStringList("disabled-languages").contains(iso)) {
                        iso = Language.getDefaultLanguage().getIso();
                    }
                    BedWars.getRemoteDatabase().setLanguage(u, iso);
                }
                Language.getLangByPlayer().remove(p.getUniqueId());
            });
        }
        if (BedWars.getServerType() != ServerType.SHARED) {
            e.setQuitMessage(null);
        }
        if (BedWars.getParty().isInternal() && BedWars.getParty().hasParty(p)) {
            BedWars.getParty().removeFromParty(p);
        }
        if ((ss = SetupSession.getSession(p.getUniqueId())) != null) {
            ss.cancel();
        }
        if ((sb = BedWarsScoreboard.getSBoard(e.getPlayer().getUniqueId())) != null) {
            sb.remove();
        }
        BedWarsTeam.reSpawnInvulnerability.remove(e.getPlayer().getUniqueId());
        LastHit lh = LastHit.getLastHit(p);
        if (lh != null) {
            lh.remove();
        }
        CmdStats.getStatsCoolDown().remove(e.getPlayer().getUniqueId());
    }

    @EventHandler
    public void onTeleport(PlayerTeleportEvent e) {
        IArena a1;
        if (e == null) {
            return;
        }
        if (e.isCancelled()) {
            return;
        }
        if (e.getTo() == null) {
            return;
        }
        if (e.getTo().getWorld() == null) {
            return;
        }
        IArena a = Arena.getArenaByPlayer(e.getPlayer());
        if (a != null && (a1 = Arena.getArenaByIdentifier(e.getTo().getWorld().getName())) != null && !a1.equals(a)) {
            if (a.isSpectator(e.getPlayer())) {
                a.removeSpectator(e.getPlayer(), false);
            }
            if (a.isPlayer(e.getPlayer())) {
                a.removePlayer(e.getPlayer(), false);
            }
            e.getPlayer().sendMessage("PlayerTeleportEvent something went wrong. You have joined an arena world while playing on a different map.");
        }
    }

    @EventHandler
    public void onWorldChange(PlayerChangedWorldEvent e) {
        IArena a;
        if (BedWars.getServerType() == ServerType.SHARED && BedWars.config.getBoolean("scoreboard-settings.sidebar.enable-lobby-sidebar")) {
            if (e.getPlayer().getWorld().getName().equalsIgnoreCase(BedWars.getLobbyWorld())) {
                BedWarsScoreboard.giveScoreboard(e.getPlayer(), null, true);
            } else {
                BedWarsScoreboard sb = BedWarsScoreboard.getSBoard(e.getPlayer().getUniqueId());
                if (sb != null) {
                    sb.remove();
                }
            }
        }
        if ((a = Arena.getArenaByPlayer(e.getPlayer())) != null && a.isPlayer(e.getPlayer())) {
            if (a.getStatus() == GameState.waiting || a.getStatus() == GameState.starting) {
                return;
            }
            if (!e.getPlayer().getWorld().getName().equalsIgnoreCase(a.getWorld().getName())) {
                a.removePlayer(e.getPlayer(), BedWars.getServerType() == ServerType.BUNGEE);
                BedWars.debug(e.getPlayer().getName() + " was removed from " + a.getDisplayName() + " because he was teleported outside the arena.");
            }
        }
    }
}

