/*
 * Decompiled with CFR 0.152.
 */
package com.andrei1058.bedwars.sidebar;

import com.andrei1058.bedwars.BedWars;
import com.andrei1058.bedwars.api.arena.GameState;
import com.andrei1058.bedwars.api.arena.IArena;
import com.andrei1058.bedwars.api.arena.team.ITeam;
import com.andrei1058.bedwars.api.language.Language;
import com.andrei1058.bedwars.api.language.Messages;
import com.andrei1058.bedwars.api.server.ServerType;
import com.andrei1058.bedwars.arena.Arena;
import com.andrei1058.bedwars.arena.Misc;
import com.andrei1058.bedwars.libs.sidebar.PlaceholderProvider;
import com.andrei1058.bedwars.libs.sidebar.Sidebar;
import com.andrei1058.bedwars.libs.sidebar.SidebarLine;
import com.andrei1058.bedwars.libs.sidebar.SidebarLineAnimated;
import com.andrei1058.bedwars.libs.sidebar.SidebarManager;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BedWarsScoreboard {
    private static SidebarManager sidebarManager = null;
    private static final HashMap<UUID, BedWarsScoreboard> scoreboards = new HashMap();
    private final Player player;
    private IArena arena;
    private Sidebar handle;
    private SimpleDateFormat dateFormat;
    private SimpleDateFormat nextEventDateFormat;

    private BedWarsScoreboard(@NotNull Player player, @NotNull List<String> content, @Nullable IArena arena) {
        this.arena = arena;
        this.player = player;
        if (content.isEmpty()) {
            return;
        }
        BedWarsScoreboard previousScoreboard = scoreboards.get(player.getUniqueId());
        if (previousScoreboard != null) {
            previousScoreboard.remove();
        }
        if (!player.isOnline()) {
            return;
        }
        this.nextEventDateFormat = new SimpleDateFormat(Language.getMsg(player, Messages.FORMATTING_SCOREBOARD_NEXEVENT_TIMER));
        this.nextEventDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.dateFormat = new SimpleDateFormat(Language.getMsg(player, Messages.FORMATTING_SCOREBOARD_DATE));
        List<PlaceholderProvider> placeholders = Arrays.asList(new PlaceholderProvider("{on}", () -> String.valueOf(this.getArena() == null ? Bukkit.getOnlinePlayers().size() : this.getArena().getPlayers().size())), new PlaceholderProvider("{max}", () -> String.valueOf(this.getArena() == null ? Bukkit.getMaxPlayers() : this.getArena().getMaxPlayers())), new PlaceholderProvider("{time}", () -> {
            if (this.arena == null) {
                return this.dateFormat.format(new Date(System.currentTimeMillis()));
            }
            if (this.arena.getStatus() == GameState.playing || this.arena.getStatus() == GameState.restarting) {
                return this.getNextEventTime();
            }
            if (this.arena.getStatus() == GameState.starting && this.getArena().getStartingTask() != null) {
                return String.valueOf(this.getArena().getStartingTask().getCountdown() + 1);
            }
            return this.dateFormat.format(new Date(System.currentTimeMillis()));
        }), new PlaceholderProvider("{nextEvent}", this::getNextEventName), new PlaceholderProvider("{date}", () -> this.dateFormat.format(new Date(System.currentTimeMillis()))), new PlaceholderProvider("{kills}", () -> String.valueOf(this.getArena() == null ? BedWars.getStatsManager().get(this.getPlayer().getUniqueId()).getKills() : this.getArena().getPlayerKills(this.getPlayer(), false))), new PlaceholderProvider("{finalKills}", () -> String.valueOf(this.getArena() == null ? BedWars.getStatsManager().get(this.getPlayer().getUniqueId()).getFinalKills() : this.getArena().getPlayerKills(this.getPlayer(), true))), new PlaceholderProvider("{beds}", () -> String.valueOf(this.getArena() == null ? BedWars.getStatsManager().get(this.getPlayer().getUniqueId()).getBedsDestroyed() : this.getArena().getPlayerBedsDestroyed(this.getPlayer()))), new PlaceholderProvider("{deaths}", () -> String.valueOf(this.getArena() == null ? BedWars.getStatsManager().get(this.getPlayer().getUniqueId()).getDeaths() : this.getArena().getPlayerDeaths(this.getPlayer(), false))), new PlaceholderProvider("{progress}", () -> BedWars.getLevelSupport().getProgressBar(this.getPlayer())), new PlaceholderProvider("{level}", () -> BedWars.getLevelSupport().getLevel(this.getPlayer())), new PlaceholderProvider("{currentXp}", () -> BedWars.getLevelSupport().getCurrentXpFormatted(this.getPlayer())), new PlaceholderProvider("{requiredXp}", () -> BedWars.getLevelSupport().getRequiredXpFormatted(this.getPlayer())));
        if (sidebarManager == null) {
            try {
                sidebarManager = new SidebarManager();
            }
            catch (InstantiationException e) {
                throw new IllegalStateException(e);
            }
        }
        this.handle = sidebarManager.createSidebar(null, Collections.emptyList(), placeholders);
        scoreboards.put(player.getUniqueId(), this);
        this.setStrings(content);
        this.handle.apply(player);
        this.handlePlayerList();
    }

    public void handlePlayerList() {
        World lobbyWorld;
        this.handle.playerListClear();
        this.handleHealthIcon();
        if (this.arena != null) {
            String suffixListPath;
            String prefixListPath;
            for (ITeam currentTeam : this.arena.getTeams()) {
                this.handle.addPlaceholder(new PlaceholderProvider("{Team" + currentTeam.getName() + "Status}", () -> {
                    String result = currentTeam.isBedDestroyed() ? (currentTeam.getSize() > 0 ? Language.getMsg(this.getPlayer(), Messages.FORMATTING_SCOREBOARD_BED_DESTROYED).replace("{remainingPlayers}", String.valueOf(currentTeam.getSize())) : Language.getMsg(this.getPlayer(), Messages.FORMATTING_SCOREBOARD_TEAM_ELIMINATED)) : Language.getMsg(this.getPlayer(), Messages.FORMATTING_SCOREBOARD_TEAM_ALIVE);
                    if (currentTeam.isMember(this.getPlayer())) {
                        result = result + Language.getMsg(this.getPlayer(), Messages.FORMATTING_SCOREBOARD_YOUR_TEAM);
                    }
                    return result;
                }));
            }
            if (this.arena.getStatus() == GameState.playing && BedWars.config.getBoolean("scoreboard-settings.player-list.format-playing-list") || this.arena.getStatus() == GameState.restarting && BedWars.config.getBoolean("scoreboard-settings.player-list.format-restarting-list")) {
                prefixListPath = this.arena.getStatus() == GameState.playing ? Messages.FORMATTING_SCOREBOARD_TAB_PREFIX_PLAYING : Messages.FORMATTING_SCOREBOARD_TAB_PREFIX_PRESTARTING;
                suffixListPath = this.arena.getStatus() == GameState.playing ? Messages.FORMATTING_SCOREBOARD_TAB_SUFFIX_PLAYING : Messages.FORMATTING_SCOREBOARD_TAB_SUFFIX_PRESTARTING;
                for (ITeam currentTeam : this.arena.getTeams()) {
                    currentTeam.getMembers().forEach(currentMember -> {
                        this.addToTabList((Player)currentMember, prefixListPath, suffixListPath);
                        BedWarsScoreboard currentSpectatorScoreboard = BedWarsScoreboard.getSBoard(currentMember.getUniqueId());
                        if (currentSpectatorScoreboard != null) {
                            currentSpectatorScoreboard.addToTabList(this.getPlayer(), prefixListPath, suffixListPath);
                        }
                    });
                    this.handle.playerListRefreshAnimation();
                }
                if (this.arena.isSpectator(this.getPlayer())) {
                    this.arena.getSpectators().forEach(spectator -> {
                        this.addToTabList((Player)spectator, prefixListPath, suffixListPath);
                        BedWarsScoreboard currentSpectatorScoreboard = BedWarsScoreboard.getSBoard(spectator.getUniqueId());
                        if (currentSpectatorScoreboard != null) {
                            currentSpectatorScoreboard.addToTabList(this.getPlayer(), prefixListPath, suffixListPath);
                        }
                        this.handle.playerListRefreshAnimation();
                    });
                }
            } else if (this.arena.getStatus() == GameState.waiting && BedWars.config.getBoolean("scoreboard-settings.player-list.format-waiting-list") || this.arena.getStatus() == GameState.starting && BedWars.config.getBoolean("scoreboard-settings.player-list.format-starting-list")) {
                prefixListPath = this.arena.getStatus() == GameState.waiting ? Messages.FORMATTING_SCOREBOARD_TAB_PREFIX_WAITING : Messages.FORMATTING_SCOREBOARD_TAB_PREFIX_STARTING;
                suffixListPath = this.arena.getStatus() == GameState.waiting ? Messages.FORMATTING_SCOREBOARD_TAB_SUFFIX_WAITING : Messages.FORMATTING_SCOREBOARD_TAB_SUFFIX_STARTING;
                this.arena.getPlayers().forEach(inGame -> {
                    this.addToTabList((Player)inGame, prefixListPath, suffixListPath);
                    BedWarsScoreboard currentSpectatorScoreboard = BedWarsScoreboard.getSBoard(inGame.getUniqueId());
                    if (currentSpectatorScoreboard != null) {
                        currentSpectatorScoreboard.addToTabList(this.getPlayer(), prefixListPath, suffixListPath);
                    }
                });
                this.handle.playerListRefreshAnimation();
            }
        } else if (BedWars.config.getBoolean("scoreboard-settings.player-list.format-lobby-list") && (lobbyWorld = Bukkit.getWorld((String)BedWars.config.getLobbyWorldName())) != null) {
            lobbyWorld.getPlayers().forEach(inGame -> {
                this.addToTabList((Player)inGame, Messages.FORMATTING_SCOREBOARD_TAB_PREFIX_LOBBY, Messages.FORMATTING_SCOREBOARD_TAB_SUFFIX_LOBBY);
                BedWarsScoreboard currentPlayerScoreboard = BedWarsScoreboard.getSBoard(inGame.getUniqueId());
                if (currentPlayerScoreboard != null) {
                    currentPlayerScoreboard.addToTabList(this.getPlayer(), Messages.FORMATTING_SCOREBOARD_TAB_PREFIX_LOBBY, Messages.FORMATTING_SCOREBOARD_TAB_SUFFIX_LOBBY);
                }
                this.handle.playerListRefreshAnimation();
            });
        }
    }

    public void setArena(IArena arena) {
        this.arena = arena;
    }

    private void setStrings(@NotNull List<String> strings) {
        while (this.handle.linesAmount() > 0) {
            this.handle.removeLine(0);
        }
        LinkedList placeholdersToRemove = new LinkedList();
        this.handle.getPlaceholders().forEach(placeholder -> {
            if (placeholder.getPlaceholder().startsWith("{Team")) {
                placeholdersToRemove.add(placeholder.getPlaceholder());
            }
        });
        placeholdersToRemove.forEach(placeholder -> this.handle.removePlaceholder((String)placeholder));
        final String[] title = strings.remove(0).split("[\\n,]");
        if (title.length == 1) {
            this.handle.setTitle(new SidebarLine(){

                @Override
                @NotNull
                public String getLine() {
                    return title[0];
                }
            });
        } else {
            this.handle.setTitle(new SidebarLineAnimated(title));
        }
        this.handlePlayerList();
        int teamCount = 0;
        Language language = Language.getPlayerLanguage(this.player);
        String genericTeamFormat = language.m(Messages.FORMATTING_SCOREBOARD_TEAM_GENERIC);
        for (String current : strings) {
            if (this.arena != null && current.trim().equals("{team}")) {
                if (this.arena.getTeams().size() <= teamCount) continue;
                ITeam team = this.arena.getTeams().get(teamCount++);
                String teamName = team.getDisplayName(language);
                current = genericTeamFormat.replace("{TeamLetter}", String.valueOf(teamName.length() != 0 ? Character.valueOf(teamName.charAt(0)) : "")).replace("{TeamColor}", team.getColor().chat().toString()).replace("{TeamName}", teamName).replace("{TeamStatus}", "{Team" + team.getName() + "Status}");
            }
            current = current.replace("{server_ip}", BedWars.config.getString("server-ip")).replace("{version}", BedWars.plugin.getDescription().getVersion()).replace("{server}", BedWars.config.getString("bungee-settings.server-id")).replace("{playername}", this.player.getName()).replace("{player}", this.player.getDisplayName()).replace("{money}", String.valueOf(BedWars.getEconomy().getMoney(this.player)));
            if (this.arena == null) {
                current = Misc.replaceStatsPlaceholders(this.getPlayer(), current, true);
            } else {
                current = current.replace("{map}", this.arena.getDisplayName()).replace("{map_name}", this.arena.getArenaName()).replace("{group}", this.arena.getDisplayGroup(this.player));
                for (ITeam currentTeam : this.arena.getTeams()) {
                    ChatColor color = currentTeam.getColor().chat();
                    current = current.replace("{Team" + currentTeam.getName() + "Color}", color.toString()).replace("{Team" + currentTeam.getName() + "Name}", currentTeam.getDisplayName(Language.getPlayerLanguage(this.getPlayer())));
                }
            }
            final String finalTemp = current;
            SidebarLine sidebarLine = new SidebarLine(){

                @Override
                @NotNull
                public String getLine() {
                    return finalTemp;
                }
            };
            this.handle.addLine(sidebarLine);
        }
    }

    public void addToTabList(Player player, @NotNull String prefixListPath, @NotNull String suffixListPath) {
        this.handle.playerListCreate(player, this.getTeamListText(prefixListPath, player), this.getTeamListText(suffixListPath, player));
        if (this.arena != null) {
            this.handle.playerListAddPlaceholders(player, new PlaceholderProvider("{team}", () -> {
                if (this.arena.isSpectator(player)) {
                    return Language.getMsg(this.getPlayer(), Messages.FORMATTING_SPECTATOR_COLOR) + Language.getMsg(this.getPlayer(), Messages.FORMATTING_SPECTATOR_TEAM);
                }
                ITeam team = this.arena.getTeam(player);
                if (team == null) {
                    team = this.arena.getExTeam(player.getUniqueId());
                }
                if (team == null) {
                    return "";
                }
                return team.getColor().chat() + team.getDisplayName(Language.getPlayerLanguage(this.getPlayer()));
            }), new PlaceholderProvider("{teamLetter}", () -> {
                if (this.arena.isSpectator(player)) {
                    return Language.getMsg(this.getPlayer(), Messages.FORMATTING_SPECTATOR_TEAM).substring(0, 1);
                }
                ITeam team = this.arena.getTeam(player);
                if (team == null) {
                    team = this.arena.getExTeam(player.getUniqueId());
                }
                if (team == null) {
                    return "";
                }
                return team.getDisplayName(Language.getPlayerLanguage(this.getPlayer())).substring(0, 1);
            }), new PlaceholderProvider("{teamName}", () -> {
                if (this.arena.isSpectator(player)) {
                    return Language.getMsg(this.getPlayer(), Messages.FORMATTING_SPECTATOR_TEAM);
                }
                ITeam team = this.arena.getTeam(player);
                if (team == null) {
                    team = this.arena.getExTeam(player.getUniqueId());
                }
                if (team == null) {
                    return "";
                }
                return team.getDisplayName(Language.getPlayerLanguage(this.getPlayer()));
            }), new PlaceholderProvider("{teamColor}", () -> {
                if (this.arena.isSpectator(player)) {
                    return Language.getMsg(this.getPlayer(), Messages.FORMATTING_SPECTATOR_COLOR);
                }
                ITeam team = this.arena.getTeam(player);
                if (team == null) {
                    team = this.arena.getExTeam(player.getUniqueId());
                }
                if (team == null) {
                    return "";
                }
                return team.getColor().chat().toString();
            }));
        }
    }

    public void handleHealthIcon() {
        if (this.arena == null) {
            this.handle.hidePlayersHealth();
            return;
        }
        if (this.arena.getStatus() != GameState.playing) {
            this.handle.hidePlayersHealth();
            return;
        }
        if (this.handle != null) {
            SidebarLine line;
            List<String> animation = Language.getList(this.player, Messages.FORMATTING_SCOREBOARD_HEALTH);
            if (animation.isEmpty()) {
                return;
            }
            if (animation.size() > 1) {
                String[] lines = new String[animation.size()];
                for (int i = 0; i < animation.size(); ++i) {
                    lines[i] = animation.get(i);
                }
                line = new SidebarLineAnimated(lines);
            } else {
                final String text = animation.get(0);
                line = new SidebarLine(){

                    @Override
                    @NotNull
                    public String getLine() {
                        return text;
                    }
                };
            }
            this.handle.showPlayersHealth(line, BedWars.config.getBoolean("scoreboard-settings.health.display-in-tab"));
            Bukkit.getScheduler().runTaskLater((Plugin)BedWars.plugin, () -> {
                if (this.arena != null && this.handle != null) {
                    this.arena.getPlayers().forEach(player -> this.handle.refreshHealth((Player)player, (int)Math.ceil(player.getHealth())));
                    if (this.arena.isSpectator(this.getPlayer())) {
                        this.arena.getSpectators().forEach(player -> this.handle.refreshHealth((Player)player, (int)Math.ceil(player.getHealth())));
                    }
                }
            }, 20L);
        }
    }

    public Player getPlayer() {
        return this.player;
    }

    public void remove() {
        scoreboards.remove(this.getPlayer().getUniqueId());
        if (this.handle != null) {
            this.handle.remove(this.player.getUniqueId());
            this.handle = null;
            BedWarsScoreboard.getScoreboards().values().forEach(scoreboard -> scoreboard.handle.playerListRemove(this.getPlayer().getName()));
        }
    }

    public IArena getArena() {
        return this.arena;
    }

    public static Map<UUID, BedWarsScoreboard> getScoreboards() {
        return scoreboards;
    }

    public static BedWarsScoreboard getSBoard(UUID player) {
        return scoreboards.get(player);
    }

    @NotNull
    private String getNextEventName() {
        if (!(this.arena instanceof Arena)) {
            return "-";
        }
        Arena arena = (Arena)this.arena;
        String st = "-";
        switch (arena.getNextEvent()) {
            case EMERALD_GENERATOR_TIER_II: {
                st = Language.getMsg(this.getPlayer(), Messages.NEXT_EVENT_EMERALD_UPGRADE_II);
                break;
            }
            case EMERALD_GENERATOR_TIER_III: {
                st = Language.getMsg(this.getPlayer(), Messages.NEXT_EVENT_EMERALD_UPGRADE_III);
                break;
            }
            case DIAMOND_GENERATOR_TIER_II: {
                st = Language.getMsg(this.getPlayer(), Messages.NEXT_EVENT_DIAMOND_UPGRADE_II);
                break;
            }
            case DIAMOND_GENERATOR_TIER_III: {
                st = Language.getMsg(this.getPlayer(), Messages.NEXT_EVENT_DIAMOND_UPGRADE_III);
                break;
            }
            case GAME_END: {
                st = Language.getMsg(this.getPlayer(), Messages.NEXT_EVENT_GAME_END);
                break;
            }
            case BEDS_DESTROY: {
                st = Language.getMsg(this.getPlayer(), Messages.NEXT_EVENT_BEDS_DESTROY);
                break;
            }
            case ENDER_DRAGON: {
                st = Language.getMsg(this.getPlayer(), Messages.NEXT_EVENT_DRAGON_SPAWN);
            }
        }
        return st;
    }

    @NotNull
    private String getNextEventTime() {
        if (!(this.arena instanceof Arena)) {
            return this.nextEventDateFormat.format(0L);
        }
        Arena arena = (Arena)this.arena;
        long time = 0L;
        switch (arena.getNextEvent()) {
            case EMERALD_GENERATOR_TIER_II: 
            case EMERALD_GENERATOR_TIER_III: {
                time = (long)arena.upgradeEmeraldsCount * 1000L;
                break;
            }
            case DIAMOND_GENERATOR_TIER_II: 
            case DIAMOND_GENERATOR_TIER_III: {
                time = (long)arena.upgradeDiamondsCount * 1000L;
                break;
            }
            case GAME_END: {
                time = (long)arena.getPlayingTask().getGameEndCountdown() * 1000L;
                break;
            }
            case BEDS_DESTROY: {
                time = (long)arena.getPlayingTask().getBedsDestroyCountdown() * 1000L;
                break;
            }
            case ENDER_DRAGON: {
                time = (long)arena.getPlayingTask().getDragonSpawnCountdown() * 1000L;
            }
        }
        return time == 0L ? "0" : this.nextEventDateFormat.format(new Date(time));
    }

    public void updateSpectator(Player player, boolean value) {
    }

    public void invisibilityPotion(@NotNull ITeam team, Player player, boolean toggle) {
        if (toggle) {
            this.handle.playerListHideNameTag(player);
        } else {
            this.handle.playerListRestoreNameTag(player);
        }
    }

    public static void giveScoreboard(@NotNull Player player, IArena arena, boolean delay) {
        if (!player.isOnline()) {
            return;
        }
        BedWarsScoreboard scoreboard = BedWarsScoreboard.getSBoard(player.getUniqueId());
        List<String> lines = null;
        if (arena == null) {
            if (BedWars.getServerType() == ServerType.SHARED || !BedWars.config.getBoolean("scoreboard-settings.sidebar.enable-lobby-sidebar")) {
                if (scoreboard != null) {
                    scoreboard.remove();
                }
                return;
            }
            lines = Language.getList(player, Messages.SCOREBOARD_LOBBY);
        } else {
            if (!BedWars.config.getBoolean("scoreboard-settings.sidebar.enable-game-sidebar")) {
                if (scoreboard != null) {
                    scoreboard.remove();
                }
                return;
            }
            if (arena.getStatus() == GameState.waiting) {
                lines = Language.getScoreboard(player, "scoreboard." + arena.getGroup() + ".waiting", Messages.SCOREBOARD_DEFAULT_WAITING);
            } else if (arena.getStatus() == GameState.starting) {
                lines = Language.getScoreboard(player, "scoreboard." + arena.getGroup() + ".starting", Messages.SCOREBOARD_DEFAULT_STARTING);
            } else if (arena.getStatus() == GameState.playing || arena.getStatus() == GameState.restarting) {
                lines = Language.getScoreboard(player, "scoreboard." + arena.getGroup() + ".playing", Messages.SCOREBOARD_DEFAULT_PLAYING);
            }
        }
        if (lines == null || lines.isEmpty()) {
            if (scoreboard != null) {
                scoreboard.remove();
            }
            return;
        }
        if (scoreboard == null) {
            if (delay) {
                List<String> finalLines = lines;
                Bukkit.getScheduler().runTaskLater((Plugin)BedWars.plugin, () -> new BedWarsScoreboard(player, finalLines, arena), 5L);
            } else {
                new BedWarsScoreboard(player, lines, arena);
            }
        } else {
            scoreboard.setArena(arena);
            scoreboard.setStrings(lines);
        }
    }

    public Sidebar getHandle() {
        return this.handle;
    }

    @NotNull
    private SidebarLine getTeamListText(String path, Player targetPlayer) {
        List<String> strings = Language.getList(this.getPlayer(), path);
        if (strings.isEmpty()) {
            return new SidebarLine(){

                @Override
                @NotNull
                public String getLine() {
                    return "";
                }
            };
        }
        strings = new ArrayList<String>();
        for (String string : Language.getList(this.getPlayer(), path)) {
            strings.add(string.replace("{vPrefix}", BedWars.getChatSupport().getPrefix(targetPlayer)).replace("{vSuffix}", BedWars.getChatSupport().getSuffix(targetPlayer)));
        }
        if (strings.size() == 1) {
            final String line = strings.get(0);
            return new SidebarLine(){

                @Override
                @NotNull
                public String getLine() {
                    return line;
                }
            };
        }
        String[] lines = new String[strings.size()];
        for (int i = 0; i < lines.length; ++i) {
            lines[i] = strings.get(i);
        }
        return new SidebarLineAnimated(lines);
    }
}

