/*
 * Decompiled with CFR 0.152.
 */
package com.andrei1058.bedwars.sidebar;

import com.andrei1058.bedwars.BedWars;
import com.andrei1058.bedwars.api.arena.IArena;
import com.andrei1058.bedwars.api.events.player.PlayerBedBreakEvent;
import com.andrei1058.bedwars.api.events.player.PlayerKillEvent;
import com.andrei1058.bedwars.api.events.player.PlayerReJoinEvent;
import com.andrei1058.bedwars.api.events.player.PlayerReSpawnEvent;
import com.andrei1058.bedwars.api.language.Messages;
import com.andrei1058.bedwars.arena.Arena;
import com.andrei1058.bedwars.sidebar.BedWarsScoreboard;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;

public class ScoreboardListener
implements Listener {
    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerDamage(EntityDamageEvent e) {
        if (e == null) {
            return;
        }
        if (e.isCancelled()) {
            return;
        }
        if (!(e.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)e.getEntity();
        IArena arena = Arena.getArenaByPlayer(player);
        int health = (int)Math.ceil(player.getHealth() - e.getFinalDamage());
        if (arena == null) {
            return;
        }
        for (BedWarsScoreboard scoreboard : BedWarsScoreboard.getScoreboards().values()) {
            if (!arena.equals(scoreboard.getArena())) continue;
            scoreboard.getHandle().refreshHealth(player, health);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onRegain(EntityRegainHealthEvent e) {
        if (e == null) {
            return;
        }
        if (e.isCancelled()) {
            return;
        }
        if (!(e.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)e.getEntity();
        IArena arena = Arena.getArenaByPlayer(player);
        if (arena == null) {
            return;
        }
        int health = (int)Math.ceil(player.getHealth() + e.getAmount());
        for (BedWarsScoreboard scoreboard : BedWarsScoreboard.getScoreboards().values()) {
            if (!arena.equals(scoreboard.getArena())) continue;
            scoreboard.getHandle().refreshHealth(player, health);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onReSpawn(PlayerReSpawnEvent e) {
        if (e == null) {
            return;
        }
        IArena arena = e.getArena();
        for (BedWarsScoreboard scoreboard : BedWarsScoreboard.getScoreboards().values()) {
            if (!arena.equals(scoreboard.getArena())) continue;
            scoreboard.getHandle().refreshHealth(e.getPlayer(), (int)Math.ceil(e.getPlayer().getHealth()));
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void reJoin(PlayerReJoinEvent e) {
        if (e == null) {
            return;
        }
        if (e.isCancelled()) {
            return;
        }
        if (!BedWars.config.getBoolean("scoreboard-settings.player-list.format-playing-list")) {
            return;
        }
        IArena arena = e.getArena();
        Player player = e.getPlayer();
        for (BedWarsScoreboard scoreboard : BedWarsScoreboard.getScoreboards().values()) {
            if (!arena.equals(scoreboard.getArena())) continue;
            scoreboard.addToTabList(player, Messages.FORMATTING_SCOREBOARD_TAB_PREFIX_PLAYING, Messages.FORMATTING_SCOREBOARD_TAB_SUFFIX_PLAYING);
        }
    }

    @EventHandler
    public void onBedDestroy(PlayerBedBreakEvent e) {
        if (e == null) {
            return;
        }
        IArena arena = e.getArena();
        BedWarsScoreboard.getScoreboards().values().forEach(bedWarsScoreboard -> {
            if (arena.equals(bedWarsScoreboard.getArena())) {
                bedWarsScoreboard.getHandle().refreshPlaceholders();
            }
        });
    }

    @EventHandler
    public void onFinalKill(PlayerKillEvent e) {
        if (e == null) {
            return;
        }
        if (!e.getCause().isFinalKill()) {
            return;
        }
        IArena arena = e.getArena();
        BedWarsScoreboard.getScoreboards().values().forEach(bedWarsScoreboard -> {
            if (arena.equals(bedWarsScoreboard.getArena())) {
                bedWarsScoreboard.getHandle().refreshPlaceholders();
            }
        });
    }
}

