/*
 * Decompiled with CFR 0.152.
 */
package com.andrei1058.spigotutils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public class SpigotUpdater {
    private int resourceID;
    private Plugin plugin;
    private String currentVersion;
    private String newVersion = null;
    private boolean updateAvailable = false;
    private boolean updateMessage;

    public SpigotUpdater(Plugin plugin, int resourceID, boolean updateMessage) {
        this.resourceID = resourceID;
        this.plugin = plugin;
        this.currentVersion = plugin.getDescription().getVersion();
        this.updateMessage = updateMessage;
    }

    public void checkUpdate() {
        if (!this.plugin.isEnabled()) {
            this.plugin.getLogger().log(Level.WARNING, "Could not check for updates. #checkUpdate cannot be used when the plugin is disabled.");
            return;
        }
        Bukkit.getPluginManager().registerEvents((Listener)new JoinListener(), this.plugin);
        Bukkit.getScheduler().runTaskAsynchronously(this.plugin, () -> {
            try {
                HttpURLConnection conn = (HttpURLConnection)new URL("https://api.spigotmc.org/legacy/update.php?resource=" + this.resourceID).openConnection();
                conn.setDoOutput(true);
                this.newVersion = new BufferedReader(new InputStreamReader(conn.getInputStream())).readLine();
                if (!this.newVersion.equalsIgnoreCase(this.currentVersion)) {
                    String[] v = this.newVersion.split("\\.");
                    String[] o = this.currentVersion.split("\\.");
                    for (int i = 0; i < v.length; ++i) {
                        if (i < o.length) {
                            try {
                                if (Integer.parseInt(v[i]) > Integer.parseInt(o[i])) {
                                    this.updateAvailable = true;
                                    continue;
                                }
                                if (Integer.parseInt(v[i]) == Integer.parseInt(o[i])) continue;
                                break;
                            }
                            catch (NumberFormatException numberFormatException) {
                                continue;
                            }
                        }
                        this.updateAvailable = true;
                    }
                    if (this.updateAvailable && this.updateMessage) {
                        this.plugin.getLogger().log(Level.WARNING, "                                    ");
                        this.plugin.getLogger().log(Level.WARNING, "------------------------------------");
                        this.plugin.getLogger().log(Level.WARNING, " ");
                        this.plugin.getLogger().log(Level.WARNING, "There is a new version available!");
                        this.plugin.getLogger().log(Level.WARNING, "New version: " + this.newVersion);
                        this.plugin.getLogger().log(Level.WARNING, "You are running: " + this.currentVersion);
                        this.plugin.getLogger().log(Level.WARNING, " ");
                        this.plugin.getLogger().log(Level.WARNING, "https://www.spigotmc.org/resources/" + this.resourceID);
                        this.plugin.getLogger().log(Level.WARNING, "------------------------------------");
                        this.plugin.getLogger().log(Level.WARNING, "                                    ");
                    }
                }
                conn.disconnect();
            }
            catch (IOException e) {
                this.plugin.getLogger().log(Level.INFO, "Could not check for updates.");
            }
        });
    }

    public boolean isUpdateAvailable() {
        return this.updateAvailable;
    }

    @Nullable
    public String getNewVersion() {
        return this.newVersion;
    }

    public String getCurrentVersion() {
        return this.currentVersion;
    }

    private class JoinListener
    implements Listener {
        private JoinListener() {
        }

        @EventHandler(priority=EventPriority.LOWEST)
        public void onPlayerJoin(PlayerJoinEvent e) {
            if (e.getPlayer().isOp() && SpigotUpdater.this.isUpdateAvailable() && SpigotUpdater.this.updateMessage) {
                e.getPlayer().sendMessage("");
                e.getPlayer().sendMessage(ChatColor.GRAY + "[" + ChatColor.BLUE + SpigotUpdater.this.plugin.getName() + ChatColor.GRAY + "]" + ChatColor.WHITE + " there is a new version available: " + ChatColor.GREEN + SpigotUpdater.this.getNewVersion());
            }
        }
    }
}

