/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.command.main;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.command.main.SubCommand;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.GInventory;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.WorldUtils;
import java.util.ArrayList;
import java.util.Arrays;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class CommandManager
implements CommandExecutor {
    public static ArrayList<SubCommand> subCmds = new ArrayList();
    public static ArrayList<SubCommand> consoleSubCmds = new ArrayList();

    public CommandManager(Plugin plugin) {
        plugin.getServer().getPluginCommand("gadgetsmenu").setExecutor((CommandExecutor)this);
        String[] aliases = new String[]{"gmenu"};
        plugin.getServer().getPluginCommand("gadgetsmenu").setAliases(Arrays.asList(aliases));
    }

    public void registerCommand(SubCommand subCommand) {
        if (!subCmds.contains(subCommand)) {
            subCmds.add(subCommand);
        }
        if (subCommand.canConsoleUse() && !consoleSubCmds.contains(subCommand)) {
            consoleSubCmds.add(subCommand);
        }
    }

    public static void printMessage(CommandSender sender, String usage, String description, String hoverText) {
        sender.sendMessage(ChatUtil.format("&e---------------&fHelp: GadgetsMenu&e---------------"));
        if (sender instanceof Player) {
            if (hoverText == null) {
                hoverText = description;
            }
            GadgetsMenu.getNMSManager().newJSONMessage(ChatUtil.format(" &e" + usage + " &b- " + description)).suggestCommand(usage).showText(ChatUtil.format("&b" + usage + "\n&7" + hoverText)).send((Player)sender);
        } else {
            sender.sendMessage(ChatUtil.format(" &e" + usage + " &b- " + description));
        }
    }

    public static void printMessage(CommandSender sender, SubCommand subCommand) {
        sender.sendMessage(ChatUtil.format("&e---------------&fHelp: GadgetsMenu&e---------------"));
        if (sender instanceof Player) {
            GadgetsMenu.getNMSManager().newJSONMessage(ChatUtil.format(" &e" + subCommand.getUsage() + " &b- " + subCommand.getDescription())).suggestCommand(subCommand.getUsage()).showText(ChatUtil.format("&b" + subCommand.getUsage() + "\n&7" + subCommand.getHoverText())).send((Player)sender);
        } else {
            sender.sendMessage(ChatUtil.format(" &e" + subCommand.getUsage() + " &b- " + subCommand.getDescription()));
        }
    }

    public static void printHelpMessage(CommandSender sender, int page) {
        int maxPages = GInventory.getMaxPagesAmount(8, subCmds.size());
        int consoleMaxPages = GInventory.getMaxPagesAmount(8, consoleSubCmds.size());
        if (page > (sender instanceof Player ? maxPages : consoleMaxPages)) {
            page = 1;
        }
        int size = sender instanceof Player ? subCmds.size() : consoleSubCmds.size();
        int from = 1;
        if (page > 1) {
            from = 8 * (page - 1) + 1;
        }
        int to = 8;
        if (size < 8) {
            to = size;
        }
        if (page > 1) {
            to = size >= 8 * page ? 8 * page : size;
        }
        if (sender instanceof Player) {
            sender.sendMessage(ChatUtil.format("&e---------------&fHelp: GadgetsMenu&e--------------- &f(" + page + "/" + maxPages + ")"));
            int i = 0;
            for (int h = from; h <= to && h <= subCmds.size(); ++h) {
                SubCommand cmds = subCmds.get(h - 1);
                if (cmds.getPermission() != null && !sender.hasPermission(cmds.getPermission())) continue;
                GadgetsMenu.getNMSManager().newJSONMessage(ChatUtil.format(" &e" + cmds.getUsage() + " &b- " + cmds.getDescription())).suggestCommand(cmds.getUsage()).showText(ChatUtil.format("&b" + cmds.getUsage() + "\n&7" + cmds.getHoverText())).send((Player)sender);
                ++i;
            }
            if (page >= maxPages) {
                if (page > 1 && maxPages > 1) {
                    GadgetsMenu.getNMSManager().newJSONMessage(ChatUtil.format("&3Use &b/gmenu help " + (maxPages - 1) + " &3to display page " + (maxPages - 1) + "!")).runCommand("/gmenu help " + (maxPages - 1)).send((Player)sender);
                }
            } else if (i >= 8) {
                GadgetsMenu.getNMSManager().newJSONMessage(ChatUtil.format("&3Use &b/gmenu help " + (page + 1) + " &3to display page " + (page + 1) + "!")).runCommand("/gmenu help " + (page + 1)).send((Player)sender);
            }
        } else {
            sender.sendMessage(ChatUtil.format("&e---------------&fHelp: GadgetsMenu&e--------------- &f(" + page + "/" + consoleMaxPages + ")"));
            for (int h = from; h <= to && h <= consoleSubCmds.size(); ++h) {
                SubCommand cmds = consoleSubCmds.get(h - 1);
                if (!cmds.canConsoleUse()) {
                    cmds = consoleSubCmds.get(h);
                    ++to;
                    continue;
                }
                sender.sendMessage(ChatUtil.format(" &e" + cmds.getUsage() + " &b- " + cmds.getDescription()));
            }
            if (page >= consoleMaxPages) {
                if (page > 1 && consoleMaxPages > 1) {
                    sender.sendMessage(ChatUtil.format("&3Use &b/gmenu help " + (consoleMaxPages - 1) + " &3to display page " + (consoleMaxPages - 1) + "!"));
                }
            } else {
                sender.sendMessage(ChatUtil.format("&3Use &b/gmenu help " + (page + 1) + " &3to display page " + (page + 1) + "!"));
            }
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        if (!(sender instanceof Player) && !(sender instanceof CommandSender)) {
            sender.sendMessage(MessageType.COMING_SOON.getFormatMessage());
            return true;
        }
        if (args == null || args.length == 0) {
            if (sender instanceof Player) {
                if (!WorldUtils.isWorldEnabled((Player)sender, true)) {
                    return true;
                }
                CommandManager.printHelpMessage((CommandSender)((Player)sender), 1);
            } else {
                CommandManager.printHelpMessage(sender, 1);
            }
            return true;
        }
        for (SubCommand subcmd : subCmds) {
            if (!subcmd.contains(args[0])) continue;
            if (sender instanceof Player && !WorldUtils.isWorldEnabled((Player)sender, true)) {
                return true;
            }
            if (subcmd.getPermission() != null && !sender.hasPermission(subcmd.getPermission())) {
                sender.sendMessage(MessageType.NO_PERMISSION.getFormatMessage().replace("{PERMISSION}", subcmd.getPermission()));
                return true;
            }
            if (sender instanceof Player) {
                subcmd.onCommandPlayer((Player)sender, args);
            } else if (sender instanceof CommandSender) {
                subcmd.onOtherCommandSender(sender, args);
            }
            return true;
        }
        if (sender instanceof Player) {
            if (!WorldUtils.isWorldEnabled((Player)sender, true)) {
                return true;
            }
            CommandManager.printHelpMessage((CommandSender)((Player)sender), 1);
        } else {
            CommandManager.printHelpMessage(sender, 1);
        }
        return true;
    }
}

