/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.command.main.subcommands;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.command.main.CommandManager;
import com.yapzhenyie.GadgetsMenu.command.main.SubCommand;
import com.yapzhenyie.GadgetsMenu.cosmetics.Category;
import com.yapzhenyie.GadgetsMenu.player.OfflinePlayerManager;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class CommandNamePet
extends SubCommand {
    public CommandNamePet() {
        super("/gmenu namepet <name>", "Name your pet.", null, "gadgetsmenu.commands.namepet", new String[]{"renamepet", "namepet"}, true);
    }

    @Override
    protected void onCommandPlayer(Player sender, String[] args) {
        if (!Category.PETS.isEnabled()) {
            sender.sendMessage(MessageType.PETS_ARE_DISABLED.getFormatMessage());
            return;
        }
        String name = "";
        for (int x = 1; x < args.length; ++x) {
            String temp = args[x] + " ";
            name = name + temp;
        }
        if (name == "") {
            CommandManager.printMessage((CommandSender)sender, this);
            return;
        }
        Pattern p = Pattern.compile("[$+,:;=?@#|'<>.^*()%!]");
        Matcher m = p.matcher(name);
        if (m.find()) {
            sender.sendMessage(ChatUtil.format(MessageType.DOES_NOT_SUPPORT_SPECIAL_CHARACTERS.getFormatMessage()));
            return;
        }
        if (name.endsWith(" ")) {
            name = ChatUtil.format(name.substring(0, name.length() - 1));
        }
        int maxLength = GadgetsMenu.getGadgetsMenuData().getMaximumPetNameCharacters();
        if (name.length() > maxLength) {
            sender.sendMessage(MessageType.CHARACTERS_TOO_LONG.getFormatMessage().replace("{CHARACTERS}", String.valueOf(maxLength)));
            return;
        }
        GadgetsMenu.getPlayerManager(sender).setPetName(name);
        sender.sendMessage(ChatUtil.format(MessageType.RENAME_PET.getFormatMessage().replace("{NAME}", name)));
    }

    @Override
    protected void onOtherCommandSender(CommandSender sender, String[] args) {
        if (args.length < 3) {
            CommandManager.printMessage(sender, "/gmenu namepet [player] <name>", "Name player's pet.", null);
            return;
        }
        Player targetPlayer = sender.getServer().getPlayer(args[1]);
        if (targetPlayer == null) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)GadgetsMenu.getInstance(), () -> this.offlinePlayerCommand(sender, args));
        } else {
            if (!targetPlayer.isOnline()) {
                sender.sendMessage(MessageType.PLAYER_NOT_FOUND.getFormatMessage());
                return;
            }
            String name = "";
            for (int x = 2; x < args.length; ++x) {
                String temp = args[x] + " ";
                name = name + temp;
            }
            if (name == "") {
                CommandManager.printMessage(sender, "/gmenu namepet [player] <name>", "Name player's pet.", null);
                return;
            }
            Pattern p = Pattern.compile("[$+,:;=?@#|'<>.^*()%!]");
            Matcher m = p.matcher(name);
            if (m.find()) {
                sender.sendMessage(ChatUtil.format(MessageType.DOES_NOT_SUPPORT_SPECIAL_CHARACTERS.getFormatMessage()));
                return;
            }
            if (name.endsWith(" ")) {
                name = ChatUtil.format(name.substring(0, name.length() - 1));
            }
            int maxLength = GadgetsMenu.getGadgetsMenuData().getMaximumPetNameCharacters();
            if (name.length() > maxLength) {
                sender.sendMessage(MessageType.CHARACTERS_TOO_LONG.getFormatMessage().replace("{CHARACTERS}", String.valueOf(maxLength)));
                return;
            }
            GadgetsMenu.getPlayerManager(targetPlayer).setPetName(name);
            sender.sendMessage(ChatUtil.format(MessageType.RENAME_PET_FOR_PLAYER.getFormatMessage().replace("{NAME}", name).replace("{PLAYER}", targetPlayer.getName())));
        }
    }

    private boolean offlinePlayerCommand(CommandSender sender, String[] args) {
        OfflinePlayerManager oPlayerManager = null;
        if (sender.getServer().getPlayer(args[1]) == null) {
            OfflinePlayer oPlayer = Bukkit.getOfflinePlayer((String)args[1]);
            if (!GadgetsMenu.getDatabaseManager().getDatabaseUtils().isExist(oPlayer)) {
                sender.sendMessage(MessageType.PLAYER_NOT_FOUND.getFormatMessage());
                return false;
            }
            oPlayerManager = new OfflinePlayerManager(oPlayer.getUniqueId());
        }
        String name = "";
        for (int x = 2; x < args.length; ++x) {
            String temp = args[x] + " ";
            name = name + temp;
        }
        if (name == "") {
            CommandManager.printMessage(sender, "/gmenu namepet [player] <name>", "Name player's pet.", null);
            return false;
        }
        Pattern p = Pattern.compile("[$+,:;=?@#|'<>.^*()%!]");
        Matcher m = p.matcher(name);
        if (m.find()) {
            sender.sendMessage(ChatUtil.format(MessageType.DOES_NOT_SUPPORT_SPECIAL_CHARACTERS.getFormatMessage()));
            return false;
        }
        if (name.endsWith(" ")) {
            name = ChatUtil.format(name.substring(0, name.length() - 1));
        }
        int maxLength = GadgetsMenu.getGadgetsMenuData().getMaximumPetNameCharacters();
        if (name.length() > maxLength) {
            sender.sendMessage(MessageType.CHARACTERS_TOO_LONG.getFormatMessage().replace("{CHARACTERS}", String.valueOf(maxLength)));
            return false;
        }
        oPlayerManager.setPetName(name);
        sender.sendMessage(ChatUtil.format(MessageType.RENAME_PET_FOR_PLAYER.getFormatMessage().replace("{NAME}", name).replace("{PLAYER}", oPlayerManager.getName())));
        return true;
    }
}

