/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.command.main.subcommands;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.command.main.CommandManager;
import com.yapzhenyie.GadgetsMenu.command.main.SubCommand;
import com.yapzhenyie.GadgetsMenu.player.PlayerManager;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandReset
extends SubCommand {
    public CommandReset() {
        super("/gmenu reset <all|cosmetic> <all|player>", "Reset active cosmetic.", null, "gadgetsmenu.commands.reset", new String[]{"reset", "remove", "unequip"}, true);
    }

    @Override
    protected void onCommandPlayer(Player sender, String[] args) {
        if (args.length < 2 || args.length > 3) {
            CommandManager.printMessage((CommandSender)sender, new CommandReset());
            return;
        }
        Player target = sender;
        if (args.length == 3) {
            target = sender.getServer().getPlayer(args[2]);
            if (args[2].equalsIgnoreCase("all")) {
                target = null;
            } else if (target == null || !target.isOnline()) {
                sender.sendMessage(MessageType.PLAYER_NOT_FOUND.getFormatMessage());
                return;
            }
        }
        if (target != null) {
            this.resetCosmetic((CommandSender)sender, target, args[1]);
        } else {
            this.resetCosmeticForAllPlayers((CommandSender)sender, args[1]);
        }
    }

    @Override
    protected void onOtherCommandSender(CommandSender sender, String[] args) {
        if (args.length != 3) {
            CommandManager.printMessage(sender, this);
            sender.sendMessage(ChatUtil.format("&bCosmetics&e: &c&lAll, Hat, Animated_Hat, Particle, Suit, Gadget, Pet, Morph, Banner, Emote, Cloak"));
            return;
        }
        Player target = sender.getServer().getPlayer(args[2]);
        if (args[2].equalsIgnoreCase("all")) {
            target = null;
        } else if (target == null || !target.isOnline()) {
            sender.sendMessage(MessageType.PLAYER_NOT_FOUND.getFormatMessage());
            return;
        }
        if (target != null) {
            this.resetCosmetic(sender, target, args[1]);
        } else {
            this.resetCosmeticForAllPlayers(sender, args[1]);
        }
    }

    private void resetCosmetic(CommandSender sender, Player player, String cosmetic) {
        PlayerManager pManager = GadgetsMenu.getPlayerManager(player);
        if (cosmetic.equalsIgnoreCase("all")) {
            player.sendMessage(MessageType.RESET_COSMETICS.getFormatMessage());
            pManager.unequipActiveCosmetics();
        } else if (cosmetic.equalsIgnoreCase("hat") || cosmetic.equalsIgnoreCase("hats")) {
            player.sendMessage(MessageType.RESET_HAT.getFormatMessage());
            pManager.unequipHat();
        } else if (cosmetic.equalsIgnoreCase("animatedhat") || cosmetic.equalsIgnoreCase("animated_hat") || cosmetic.equalsIgnoreCase("animatedhats") || cosmetic.equalsIgnoreCase("animated_hats")) {
            player.sendMessage(MessageType.RESET_ANIMATED_HAT.getFormatMessage());
            pManager.unequipAnimatedHat();
        } else if (cosmetic.equalsIgnoreCase("particle") || cosmetic.equalsIgnoreCase("particles")) {
            player.sendMessage(MessageType.RESET_PARTICLE.getFormatMessage());
            pManager.unequipParticle();
        } else if (cosmetic.equalsIgnoreCase("suit") || cosmetic.equalsIgnoreCase("suits")) {
            player.sendMessage(MessageType.RESET_SUIT.getFormatMessage());
            pManager.unequipSuit();
        } else if (cosmetic.equalsIgnoreCase("gadget") || cosmetic.equalsIgnoreCase("gadgets")) {
            player.sendMessage(MessageType.RESET_GADGET.getFormatMessage());
            pManager.unequipGadget();
        } else if (cosmetic.equalsIgnoreCase("pet") || cosmetic.equalsIgnoreCase("pets")) {
            player.sendMessage(MessageType.RESET_PET.getFormatMessage());
            pManager.unequipPet();
        } else if (cosmetic.equalsIgnoreCase("morph") || cosmetic.equalsIgnoreCase("morphs")) {
            player.sendMessage(MessageType.RESET_MORPH.getFormatMessage());
            pManager.unequipMorph();
        } else if (cosmetic.equalsIgnoreCase("banner") || cosmetic.equalsIgnoreCase("banners")) {
            player.sendMessage(MessageType.RESET_BANNER.getFormatMessage());
            pManager.unequipBanner();
        } else if (cosmetic.equalsIgnoreCase("emote") || cosmetic.equalsIgnoreCase("emotes")) {
            player.sendMessage(MessageType.RESET_EMOTE.getFormatMessage());
            pManager.unequipEmote();
        } else if (cosmetic.equalsIgnoreCase("cloak") || cosmetic.equalsIgnoreCase("cloaks")) {
            player.sendMessage(MessageType.RESET_CLOAK.getFormatMessage());
            pManager.unequipCloak();
        } else {
            CommandManager.printMessage(sender, new CommandReset());
            sender.sendMessage(ChatUtil.format("&bCosmetics&e: &c&lAll, Hat, Animated_Hat, Particle, Suit, Gadget, Pet, Morph, Banner, Emote, Cloak"));
            return;
        }
        sender.sendMessage(MessageType.RESET_COMPLETED.getFormatMessage());
    }

    private void resetCosmeticForAllPlayers(CommandSender sender, String cosmetic) {
        String[] cosmetics;
        for (Player players : Bukkit.getOnlinePlayers()) {
            if (!players.isOnline()) continue;
            PlayerManager pManager = GadgetsMenu.getPlayerManager(players);
            if (cosmetic.equalsIgnoreCase("all")) {
                players.sendMessage(MessageType.RESET_COSMETICS.getFormatMessage());
                pManager.unequipActiveCosmetics();
                continue;
            }
            if (cosmetic.equalsIgnoreCase("hat") || cosmetic.equalsIgnoreCase("hats")) {
                players.sendMessage(MessageType.RESET_HAT.getFormatMessage());
                pManager.unequipHat();
                continue;
            }
            if (cosmetic.equalsIgnoreCase("animatedhat") || cosmetic.equalsIgnoreCase("animated_hat") || cosmetic.equalsIgnoreCase("animatedhats") || cosmetic.equalsIgnoreCase("animated_hats")) {
                players.sendMessage(MessageType.RESET_ANIMATED_HAT.getFormatMessage());
                pManager.unequipAnimatedHat();
                continue;
            }
            if (cosmetic.equalsIgnoreCase("particle") || cosmetic.equalsIgnoreCase("particles")) {
                players.sendMessage(MessageType.RESET_PARTICLE.getFormatMessage());
                pManager.unequipParticle();
                continue;
            }
            if (cosmetic.equalsIgnoreCase("suit") || cosmetic.equalsIgnoreCase("suits")) {
                players.sendMessage(MessageType.RESET_SUIT.getFormatMessage());
                pManager.unequipSuit();
                continue;
            }
            if (cosmetic.equalsIgnoreCase("gadget") || cosmetic.equalsIgnoreCase("gadgets")) {
                players.sendMessage(MessageType.RESET_GADGET.getFormatMessage());
                pManager.unequipGadget();
                continue;
            }
            if (cosmetic.equalsIgnoreCase("pet") || cosmetic.equalsIgnoreCase("pets")) {
                players.sendMessage(MessageType.RESET_PET.getFormatMessage());
                pManager.unequipPet();
                continue;
            }
            if (cosmetic.equalsIgnoreCase("morph") || cosmetic.equalsIgnoreCase("morphs")) {
                players.sendMessage(MessageType.RESET_MORPH.getFormatMessage());
                pManager.unequipMorph();
                continue;
            }
            if (cosmetic.equalsIgnoreCase("banner") || cosmetic.equalsIgnoreCase("banners")) {
                players.sendMessage(MessageType.RESET_BANNER.getFormatMessage());
                pManager.unequipBanner();
                continue;
            }
            if (cosmetic.equalsIgnoreCase("emote") || cosmetic.equalsIgnoreCase("emotes")) {
                players.sendMessage(MessageType.RESET_EMOTE.getFormatMessage());
                pManager.unequipEmote();
                continue;
            }
            if (!cosmetic.equalsIgnoreCase("cloak") && !cosmetic.equalsIgnoreCase("cloaks")) continue;
            players.sendMessage(MessageType.RESET_CLOAK.getFormatMessage());
            pManager.unequipCloak();
        }
        for (String cos : cosmetics = new String[]{"all", "hat", "hats", "animatedhat", "animatedhats", "animated_hat", "animated_hats", "particle", "particles", "suit", "suits", "gadget", "gadgets", "pet", "pets", "morph", "morphs", "banner", "banners", "emote", "emotes", "cloak", "cloaks"}) {
            if (!cos.equalsIgnoreCase(cosmetic)) continue;
            sender.sendMessage(MessageType.RESET_COMPLETED.getFormatMessage());
            return;
        }
        CommandManager.printMessage(sender, this);
        sender.sendMessage(ChatUtil.format("&bCosmetics&e: &c&lAll, Hat, Animated_Hat, Particle, Suit, Gadget, Pet, Morph, Banner, Emote, Cloak"));
    }
}

