/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.configuration.FileManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.Category;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.EnumMaterial;
import com.yapzhenyie.GadgetsMenu.utils.GMaterial;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MainMenuType {
    private static final List<MainMenuType> ENABLED = new ArrayList<MainMenuType>();
    private static final List<MainMenuType> VALUES = new ArrayList<MainMenuType>();
    public static final MainMenuType HATS = new MainMenuType("Hats", "&eHats", new GMaterial(EnumMaterial.DIAMOND_HELMET), Arrays.asList("&7Collect all the hats and", "&7wear them while in a lobby."));
    public static final MainMenuType ANIMATED_HATS = new MainMenuType("Animated Hats", "&eAnimated Hats", new GMaterial("head:5ebfd2396cbabdb42c348bcf41599c87a506a71ef60948c496f95c6cb63141"), Arrays.asList("&7These hats take it a step", "&7further and move while on", "&7your head."));
    public static final MainMenuType PARTICLES = new MainMenuType("Particles", "&eParticles", new GMaterial(EnumMaterial.BLAZE_POWDER), Arrays.asList("&7Make particles around you", "&7while standing in lobbies", "&7using these cool particle", "&7effects!"));
    public static final MainMenuType SUITS = new MainMenuType("Suits", "&eSuits", new GMaterial(EnumMaterial.GOLDEN_LEGGINGS), Arrays.asList("&7Collect and wear all the", "&7pieces from a specific suit", "&7to gain unique effects!"));
    public static final MainMenuType GADGETS = new MainMenuType("Gadgets", "&eGadgets", new GMaterial(EnumMaterial.PISTON), Arrays.asList("&7Wanted to show off to your", "&7friends with special gadget?", "&7These fun little toys can", "&7be used while in a lobby."));
    public static final MainMenuType PETS = new MainMenuType("Pets", "&ePets", new GMaterial(EnumMaterial.BONE), Arrays.asList("&7Unlock these pets to have", "&7them follow you around in", "&7lobbies!"));
    public static final MainMenuType MORPHS = new MainMenuType("Morphs", "&eMorphs", new GMaterial(EnumMaterial.ZOMBIE_HEAD), Arrays.asList("&7The ultimate transformation!", "&7Using these in lobbies", "&7will make you transform", "&7into a monster and unlock", "&7unique powers for everyone", "&7else to see!"));
    public static final MainMenuType BANNERS = new MainMenuType("Banners", "&eBanners", new GMaterial("CUSTOM_MATERIAL_1"), Arrays.asList("&7Unlock all the Banners and", "&7wear them as hats while in", "&7in a lobby!"));
    public static final MainMenuType EMOTES = new MainMenuType("Emotes", "&eEmotes", new GMaterial("head:60c432cbc490a8af6e9dfeb28095c0a0ec79fff705fb184674d1e743bd05baa"), Arrays.asList("&7Express yourself! Show the", "&7world how you're feeling", "&7with these unique animated", "&7Emotes."));
    public static final MainMenuType CLOAKS = new MainMenuType("Cloaks", "&eCloaks", new GMaterial(EnumMaterial.ENCHANTING_TABLE), Arrays.asList("&7Made of particles, these", "&7cloaks provide ultimate", "&7swag. To activate them,", "&7stand still for 1 second", "&7while in a lobby."));
    private String name;
    private String displayName;
    private GMaterial material;
    private List<String> lore;
    private static String layout;

    private MainMenuType(String name, String displayName, GMaterial material, List<String> lore) {
        this.name = name;
        if (FileManager.getMainMenuFile().get("MainMenu." + this.name + ".Name") == null) {
            this.displayName = displayName;
            FileManager.getMainMenuFile().set("MainMenu." + this.name + ".Name", this.displayName);
        } else {
            this.displayName = FileManager.getMainMenuFile().getString("MainMenu." + this.name + ".Name");
        }
        if (FileManager.getMainMenuFile().get("MainMenu." + this.name + ".Material") == null) {
            this.material = material;
            FileManager.getMainMenuFile().set("MainMenu." + this.name + ".Material", this.material.getCombinedMaterial());
        } else {
            this.material = new GMaterial(FileManager.getMainMenuFile().getString("MainMenu." + this.name + ".Material"));
        }
        if (FileManager.getMainMenuFile().get("MainMenu." + this.name + ".Lore") == null) {
            this.lore = lore;
            if (lore == null) {
                FileManager.getMainMenuFile().set("MainMenu." + this.name + ".Lore", "");
            } else {
                FileManager.getMainMenuFile().set("MainMenu." + this.name + ".Lore", this.lore);
            }
        } else {
            this.lore = FileManager.getMainMenuFile().getStringList("MainMenu." + this.name + ".Lore");
        }
        if (!VALUES.contains(this)) {
            VALUES.add(this);
        }
        if (this.name.equals("Morphs") && !GadgetsMenu.getGadgetsMenuData().isLibsDisguiseEnabled() && !GadgetsMenu.getGadgetsMenuData().isIDisguiseEnabled() && VALUES.contains(this)) {
            VALUES.remove(MORPHS);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return ChatUtil.format(this.displayName);
    }

    public String getDisplayNameStripColor() {
        return ChatUtil.stripColor(this.displayName);
    }

    public GMaterial getMaterial() {
        return this.material;
    }

    public List<String> getLore() {
        return this.lore;
    }

    public boolean isEnabled() {
        return Category.valueOfByName(this.name).isEnabled();
    }

    public Category getCategory() {
        return Category.valueOfByName(this.name);
    }

    public static List<MainMenuType> enabled() {
        return ENABLED;
    }

    public static List<MainMenuType> values() {
        return VALUES;
    }

    public static int[] getLayout() {
        String[] layoutString;
        if (layout == null) {
            if (FileManager.getMainMenuFile().get("Slot-Layout") == null) {
                layout = MainMenuType.getDefaultLayout();
                FileManager.getMainMenuFile().set("Slot-Layout", layout);
            } else {
                layout = FileManager.getMainMenuFile().getString("Slot-Layout");
            }
        }
        int count = 0;
        int[] layouts = new int[]{0};
        for (String slot : layoutString = layout.replace(" ", "").split("\\,")) {
            try {
                layouts[count++] = Integer.parseInt(slot);
                if (layouts.length >= layoutString.length) continue;
                layouts = Arrays.copyOf(layouts, layouts.length + 1);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return layouts;
    }

    public static String getDefaultLayout() {
        switch (MainMenuType.enabled().size()) {
            case 11: {
                return "11, 12, 13, 14, 15, 19, 20, 31, 22, 24, 25";
            }
            case 10: {
                return "9, 11, 13, 15, 17, 27, 29, 31, 33, 35";
            }
            case 9: {
                return "10, 12, 14, 16, 27, 29, 31, 33, 35";
            }
            case 8: {
                return "10, 12, 14, 16, 28, 30, 32, 34";
            }
            case 7: {
                return "11, 13, 15, 28, 30, 32, 34";
            }
            case 6: {
                return "11, 15, 28, 30, 32, 34";
            }
            case 5: {
                return "11, 15, 28, 31, 34";
            }
            case 4: {
                return "10, 12, 14, 16";
            }
            case 3: {
                return "11, 13, 15";
            }
            case 2: {
                return "11, 15";
            }
        }
        return "13";
    }

    public static void checkEnabled() {
        for (MainMenuType type : MainMenuType.values()) {
            if (!type.isEnabled() || ENABLED.contains(type)) continue;
            ENABLED.add(type);
        }
    }

    public String toString() {
        return this.name;
    }

    public static MainMenuType valueOf(String name) throws NullPointerException {
        for (MainMenuType type : MainMenuType.values()) {
            if (!type.getName().equalsIgnoreCase(name)) continue;
            return type;
        }
        return null;
    }
}

