/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.cloaks.types;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.cosmetics.cloaks.CloakType;
import com.yapzhenyie.GadgetsMenu.utils.EnumPermission;
import com.yapzhenyie.GadgetsMenu.utils.PermissionUtils;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public abstract class Cloak
implements Listener {
    boolean moving = false;
    private UUID uuid;
    private CloakType type;
    private Listener listener;
    protected boolean showCloakEffectToEveryone = GadgetsMenu.getGadgetsMenuData().showCloakEffectToEveryone();
    protected boolean hideCloakEffectForVanishedPlayer = GadgetsMenu.getGadgetsMenuData().hideCloakEffectForVanishedPlayer();

    public Cloak(UUID uuid, final CloakType type) {
        this.type = type;
        if (!type.isEnabled()) {
            return;
        }
        if (uuid != null) {
            this.uuid = uuid;
            if (PermissionUtils.noPermission(this.getPlayer(), type.getPermission(), EnumPermission.CLOAKS.getPermission(), true)) {
                GadgetsMenu.getPlayerManager(this.getPlayer()).unequipCloak();
                return;
            }
            if (GadgetsMenu.getPlayerManager(this.getPlayer()).getCurrentCloak() != null) {
                GadgetsMenu.getPlayerManager(this.getPlayer()).removeCloak();
            }
            BukkitRunnable runnable = new BukkitRunnable(){

                public void run() {
                    try {
                        if (Bukkit.getPlayer((UUID)Cloak.this.getPlayerUUID()) != null && GadgetsMenu.getPlayerManager(Cloak.this.getPlayer()).getCurrentCloak() != null && GadgetsMenu.getPlayerManager(Cloak.this.getPlayer()).getCurrentCloak().getType() == type) {
                            if (Cloak.this.isMoving()) {
                                Cloak.this.moving = false;
                            } else {
                                Cloak.this.onUpdate();
                            }
                        } else {
                            this.cancel();
                        }
                    }
                    catch (NullPointerException e) {
                        e.printStackTrace();
                        Cloak.this.clear();
                        this.cancel();
                    }
                }
            };
            runnable.runTaskTimerAsynchronously((Plugin)GadgetsMenu.getInstance(), 0L, type.getRepeatDelay());
            this.listener = new CloakListener(this);
            GadgetsMenu.getPlayerManager(this.getPlayer()).setCurrentCloak(this);
        }
    }

    protected UUID getPlayerUUID() {
        return this.uuid;
    }

    public CloakType getType() {
        return this.type;
    }

    public abstract void onUpdate();

    protected Player getPlayer() {
        return Bukkit.getPlayer((UUID)this.getPlayerUUID());
    }

    protected boolean isMoving() {
        return this.moving;
    }

    public void clear() {
        if (this.getPlayer() != null && GadgetsMenu.getPlayerManager(this.getPlayer()) != null) {
            GadgetsMenu.getPlayerManager(this.getPlayer()).setCurrentCloak(null);
        }
        try {
            HandlerList.unregisterAll((Listener)this);
            HandlerList.unregisterAll((Listener)this.listener);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.moving = false;
        this.uuid = null;
    }

    public class CloakListener
    implements Listener {
        private Cloak cloak;

        public CloakListener(Cloak cloak) {
            this.cloak = cloak;
            GadgetsMenu.getInstance().registerListener(this);
        }

        @EventHandler(priority=EventPriority.LOW)
        public void onPlayerMove(PlayerMoveEvent event) {
            if (event.getPlayer() != this.cloak.getPlayer()) {
                return;
            }
            if (!(event.getPlayer() != this.cloak.getPlayer() || this.cloak.moving || event.getFrom().getX() == event.getTo().getX() && event.getFrom().getY() == event.getTo().getY() && event.getFrom().getZ() == event.getTo().getZ())) {
                this.cloak.moving = true;
            }
        }
    }
}

