/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.emotes;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.cosmetics.Category;
import com.yapzhenyie.GadgetsMenu.cosmetics.emotes.EmoteType;
import com.yapzhenyie.GadgetsMenu.nms.interfaces.entity.NMSArmorStand;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.EnumArmorType;
import com.yapzhenyie.GadgetsMenu.utils.EnumPermission;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.ParticleEffect;
import com.yapzhenyie.GadgetsMenu.utils.PermissionUtils;
import com.yapzhenyie.GadgetsMenu.utils.VersionManager;
import com.yapzhenyie.GadgetsMenu.utils.WorldUtils;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Emote
implements Listener {
    private UUID uuid;
    private EmoteType type;
    private Player player;
    private Listener listener;
    public boolean activated = false;
    private NMSArmorStand hologram;

    public Emote(UUID uuid, final EmoteType type) {
        this.type = type;
        if (!type.isEnabled()) {
            return;
        }
        if (uuid != null) {
            this.uuid = uuid;
            this.player = Bukkit.getPlayer((UUID)uuid);
            if (PermissionUtils.noPermission(this.getPlayer(), type.getPermission(), EnumPermission.EMOTES.getPermission(), true)) {
                GadgetsMenu.getPlayerManager(this.getPlayer()).unequipEmote();
                return;
            }
            if (GadgetsMenu.getPlayerManager(this.getPlayer()).getCurrentEmote() != null) {
                GadgetsMenu.getPlayerManager(this.getPlayer()).removeEmote();
            }
            try {
                BukkitRunnable runnable = new BukkitRunnable(){

                    public void run() {
                        if (Bukkit.getPlayer((UUID)Emote.this.getPlayerUUID()) != null && GadgetsMenu.getPlayerManager(Emote.this.getPlayer()).getCurrentEmote() != null && GadgetsMenu.getPlayerManager(Emote.this.getPlayer()).getCurrentEmote().getType() == Emote.this.getType()) {
                            if (GadgetsMenu.getGadgetsMenuData().isCooldownInActionBar() && GadgetsMenu.getPlayerManager(Emote.this.player).emoteCooldown().containsKey(Emote.this.getType())) {
                                if (GadgetsMenu.getPlayerManager(Emote.this.player).emoteCooldown().get(Emote.this.getType()) - System.currentTimeMillis() > 0L && !GadgetsMenu.getPlayerManager(Emote.this.player).isBypassCooldown()) {
                                    GadgetsMenu.getPlayerManager(Emote.this.getPlayer()).sendCooldownBar(type.getDisplayName(), GadgetsMenu.getPlayerManager(Emote.this.player).emoteCooldown().get(Emote.this.getType()), type.getCooldown());
                                } else {
                                    GadgetsMenu.getPlayerManager(Emote.this.getPlayer()).resetCooldownBar();
                                    GadgetsMenu.getPlayerManager(Emote.this.getPlayer()).emoteCooldown().remove(Emote.this.getType());
                                }
                            }
                            if (Emote.this.activated && Emote.this.getType() == EmoteType.RAGE) {
                                ParticleEffect.VILLAGER_ANGRY.display(Emote.this.getPlayer().getLocation().add(0.0, 2.4, 0.0), 0.0f, 1);
                            }
                        } else {
                            this.cancel();
                        }
                    }
                };
                runnable.runTaskTimerAsynchronously((Plugin)GadgetsMenu.getInstance(), 0L, 1L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.listener = new EmoteListener(this);
            GadgetsMenu.getInstance().registerListener(this.listener);
            GadgetsMenu.getPlayerManager(this.getPlayer()).setCurrentEmote(this);
        }
    }

    public UUID getPlayerUUID() {
        return this.uuid;
    }

    public EmoteType getType() {
        return this.type;
    }

    protected Player getPlayer() {
        return this.player;
    }

    public void removeListener() {
        HandlerList.unregisterAll((Listener)this);
    }

    public void unregisterListeners() {
        try {
            HandlerList.unregisterAll((Listener)this);
            HandlerList.unregisterAll((Listener)this.listener);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void clear() {
        if (this.uuid == null) {
            return;
        }
        if (GadgetsMenu.getPlayerManager(this.getPlayer()).getCurrentEmote() != null) {
            GadgetsMenu.getPlayerManager(this.getPlayer()).setCurrentEmote(null);
        }
        this.unregisterListeners();
        this.removeHologram();
        this.uuid = null;
    }

    public void removeHologram() {
        if (this.hologram != null && !this.hologram.isDeadNMS()) {
            this.hologram.killEntityNMS();
        }
        this.hologram = null;
    }

    private void clearAll() {
        this.player.getInventory().setHelmet(null);
        Bukkit.getScheduler().runTask((Plugin)GadgetsMenu.getInstance(), () -> this.removeHologram());
        this.activated = false;
    }

    public class EmoteListener
    implements Listener {
        private Emote emote;

        public EmoteListener(Emote emote) {
            this.emote = emote;
        }

        @EventHandler
        protected void onPlayerActivateEmote(PlayerInteractEvent event) {
            final Player player = event.getPlayer();
            UUID uuid = player.getUniqueId();
            if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
                return;
            }
            if (!player.getItemInHand().hasItemMeta() || !player.getItemInHand().getItemMeta().hasDisplayName()) {
                return;
            }
            if (!uuid.equals(this.emote.uuid)) {
                return;
            }
            for (EmoteType emote : EmoteType.values()) {
                if (!player.getItemInHand().getItemMeta().getDisplayName().equals(emote.getDisplayName())) continue;
                if (!Category.EMOTES.isEnabled() || !WorldUtils.isWorldEnabled(player, true)) {
                    GadgetsMenu.getPlayerManager(Emote.this.getPlayer()).unequipEmote();
                    player.updateInventory();
                    event.setCancelled(true);
                    return;
                }
                if (GadgetsMenu.getPlayerManager(player).emoteCooldown().containsKey(Emote.this.getType()) && !GadgetsMenu.getPlayerManager(player).isBypassCooldown()) {
                    if (GadgetsMenu.getPlayerManager(player).emoteCooldown().get(Emote.this.getType()) - System.currentTimeMillis() <= 0L) {
                        GadgetsMenu.getPlayerManager(player).emoteCooldown().remove(Emote.this.getType());
                    } else {
                        player.sendMessage(MessageType.COOLDOWN.getFormatMessage().replace("{COOLDOWN}", String.valueOf((GadgetsMenu.getPlayerManager(player).emoteCooldown().get(Emote.this.getType()) - System.currentTimeMillis()) / 1000L + 1L)));
                        player.updateInventory();
                        event.setCancelled(true);
                        return;
                    }
                }
                if (this.emote.activated) {
                    player.sendMessage(MessageType.EMOTE_IS_ACTIVATED.getFormatMessage());
                    player.updateInventory();
                    event.setCancelled(true);
                    return;
                }
                if (PermissionUtils.noPermission(Emote.this.getPlayer(), Emote.this.type.getPermission(), EnumPermission.EMOTES.getPermission(), true)) {
                    GadgetsMenu.getPlayerManager(player).unequipEmote();
                    player.updateInventory();
                    event.setCancelled(true);
                    return;
                }
                if (player.getInventory().getHelmet() != null) {
                    if (GadgetsMenu.getPlayerManager(player).getSelectedHat() != null) {
                        GadgetsMenu.getPlayerManager(player).unequipHat();
                    } else if (GadgetsMenu.getPlayerManager(player).getSelectedAnimatedHat() != null) {
                        GadgetsMenu.getPlayerManager(player).unequipAnimatedHat();
                    } else if (!GadgetsMenu.getPlayerManager(player).getSelectedSuitEquipment().isEmpty() && GadgetsMenu.getPlayerManager(player).getSelectedSuitEquipment().containsKey((Object)EnumArmorType.HELMET)) {
                        GadgetsMenu.getPlayerManager(player).unequipSuitEquipment(EnumArmorType.HELMET);
                    } else if (GadgetsMenu.getPlayerManager(player).getSelectedBanner() != null) {
                        GadgetsMenu.getPlayerManager(player).unequipBanner();
                    } else {
                        player.getWorld().dropItemNaturally(player.getLocation(), player.getInventory().getHelmet().clone());
                        player.getInventory().setHelmet(null);
                        player.updateInventory();
                    }
                }
                this.emote.activated = true;
                if (emote.isHologramEnabled()) {
                    Bukkit.getScheduler().runTask((Plugin)GadgetsMenu.getInstance(), () -> {
                        if (Emote.this.hologram != null) {
                            Emote.this.removeHologram();
                        }
                        double y = VersionManager.is1_9OrAbove() ? (VersionManager.is1_11OrAbove() ? 2.2 : 2.13) : 1.25;
                        Emote.this.hologram = GadgetsMenu.getNMSManager().spawnNMSArmorStandFollower(Emote.this.getPlayer().getWorld(), Emote.this.getPlayer().getLocation().getX(), Emote.this.getPlayer().getLocation().getY() + y, Emote.this.getPlayer().getLocation().getZ(), Emote.this.getPlayer(), y, ChatUtil.format(emote.getHologram()), null, null);
                    });
                }
                if (this.emote.activated) {
                    new BukkitRunnable(){
                        int step = -1;

                        public void run() {
                            block6: {
                                if (!player.isOnline() || !Emote.this.activated || GadgetsMenu.getPlayerManager(player).getCurrentEmote() == null || GadgetsMenu.getPlayerManager(player).getCurrentEmote().getType() != Emote.this.getType()) {
                                    this.step = Emote.this.getType().getFrames().size();
                                    Emote.this.removeHologram();
                                    Emote.this.activated = false;
                                    this.cancel();
                                    return;
                                }
                                ++this.step;
                                if (Bukkit.getPlayer((UUID)Emote.this.getPlayerUUID()) != null && GadgetsMenu.getPlayerManager(player).getCurrentEmote() != null && GadgetsMenu.getPlayerManager(player).getCurrentEmote().getType() == Emote.this.getType()) {
                                    try {
                                        if (this.step <= Emote.this.getType().getFrames().size() - 1) {
                                            player.getInventory().setHelmet(Emote.this.getType().getFrames().get(this.step));
                                            break block6;
                                        }
                                        Emote.this.clearAll();
                                        this.cancel();
                                    }
                                    catch (Exception ex) {
                                        Emote.this.clearAll();
                                        this.cancel();
                                    }
                                } else {
                                    Emote.this.clearAll();
                                    this.cancel();
                                }
                            }
                        }
                    }.runTaskTimerAsynchronously((Plugin)GadgetsMenu.getInstance(), 1L, Emote.this.getType().getTicksPerFrame().longValue());
                }
                if (!GadgetsMenu.getPlayerManager(player).isBypassCooldown()) {
                    GadgetsMenu.getPlayerManager(player).emoteCooldown().put(Emote.this.getType(), System.currentTimeMillis() + (long)Emote.this.getType().getCooldown() * 1000L);
                }
                player.updateInventory();
                event.setCancelled(true);
                return;
            }
        }
    }
}

