/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.emotes;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.cosmetics.Category;
import com.yapzhenyie.GadgetsMenu.cosmetics.CategoryManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.emotes.Emote;
import com.yapzhenyie.GadgetsMenu.cosmetics.emotes.EmoteType;
import com.yapzhenyie.GadgetsMenu.player.PlayerManager;
import com.yapzhenyie.GadgetsMenu.utils.EnumEquipType;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class EmoteManager {
    public static void equipEmote(Player player, EmoteType type) {
        if (!type.isEnabled() || !Category.EMOTES.isEnabled()) {
            return;
        }
        if (player == null) {
            return;
        }
        PlayerManager pManager = GadgetsMenu.getPlayerManager(player);
        if (pManager == null) {
            return;
        }
        if (player.getInventory().getHelmet() != null) {
            CategoryManager.removeHelmetCosmetic(player);
            if (player.getInventory().getHelmet() != null) {
                if (CategoryManager.checkEquipRequirement(player, MessageType.REMOVE_HELMET_TO_EQUIP_EMOTE.getFormatMessage())) {
                    return;
                }
                if (GadgetsMenu.getGadgetsMenuData().getEquipCosmeticItemToSlotAction() == EnumEquipType.DROP) {
                    Bukkit.getScheduler().runTask((Plugin)GadgetsMenu.getInstance(), () -> {
                        player.getWorld().dropItemNaturally(player.getLocation(), player.getInventory().getHelmet().clone());
                        player.getInventory().setHelmet(null);
                        player.updateInventory();
                    });
                }
            }
        }
        int slot = GadgetsMenu.getGadgetsMenuData().getGadgetSlot();
        if (player.getInventory().getItem(slot) != null) {
            CategoryManager.removeHotbarCosmetic(player);
            if (player.getInventory().getItem(slot) != null) {
                if (CategoryManager.checkEquipRequirement(player, MessageType.REMOVE_ITEM_FROM_SLOT_TO_EQUIP_EMOTE.getFormatMessage().replace("{SLOT}", String.valueOf(slot + 1)).replace("{ITEM}", player.getInventory().getItem(slot).getType().name()))) {
                    return;
                }
                if (GadgetsMenu.getGadgetsMenuData().getEquipCosmeticItemToSlotAction() == EnumEquipType.DROP) {
                    Bukkit.getScheduler().runTask((Plugin)GadgetsMenu.getInstance(), () -> {
                        player.getWorld().dropItemNaturally(player.getLocation(), player.getInventory().getItem(slot).clone());
                        player.getInventory().setItem(slot, null);
                        player.updateInventory();
                    });
                }
            }
        }
        if (pManager.getSelectedMorph() != null) {
            pManager.unequipMorph();
        }
        pManager.setSelectedEmote(type);
        player.getInventory().setItem(slot, type.getItemStack());
        player.updateInventory();
        new Emote(player.getUniqueId(), type);
    }

    public static void unequipEmote(Player player) {
        if (player == null) {
            return;
        }
        PlayerManager pManager = GadgetsMenu.getPlayerManager(player);
        if (pManager == null) {
            return;
        }
        int slot = GadgetsMenu.getGadgetsMenuData().getGadgetSlot();
        if (player.getInventory().getItem(slot) != null || pManager.getSelectedEmote() != null || player.getInventory().getHelmet() != null) {
            if (player.getInventory().getItem(slot) != null && player.getInventory().getItem(slot).getItemMeta() != null && GadgetsMenu.getNMSManager().isNBTTagEqual(player.getInventory().getItem(slot), "Category", "Emote")) {
                player.getInventory().setItem(slot, null);
                player.updateInventory();
            }
            if (player.getInventory().getHelmet() != null && player.getInventory().getHelmet().getItemMeta() != null && GadgetsMenu.getNMSManager().isNBTTagEqual(player.getInventory().getHelmet(), "Category", "Emote")) {
                player.getInventory().setHelmet(null);
                player.updateInventory();
            }
        }
        if (pManager.getSelectedEmote() != null) {
            pManager.setSelectedEmote(null);
        }
        if (pManager.getCurrentEmote() != null) {
            pManager.removeEmote();
        }
    }

    public static boolean checkRequirement(Player player, EmoteType type) {
        if (!type.isEnabled() || !Category.EMOTES.isEnabled()) {
            return false;
        }
        if (player == null) {
            return false;
        }
        PlayerManager pManager = GadgetsMenu.getPlayerManager(player);
        if (pManager == null) {
            return false;
        }
        if (player.getInventory().getHelmet() != null) {
            CategoryManager.removeHelmetCosmetic(player);
            if (player.getInventory().getHelmet() != null) {
                if (CategoryManager.checkEquipRequirement(player, MessageType.REMOVE_HELMET_TO_EQUIP_EMOTE.getFormatMessage())) {
                    return false;
                }
                if (GadgetsMenu.getGadgetsMenuData().getEquipCosmeticItemToSlotAction() == EnumEquipType.DROP) {
                    Bukkit.getScheduler().runTask((Plugin)GadgetsMenu.getInstance(), () -> {
                        player.getWorld().dropItemNaturally(player.getLocation(), player.getInventory().getHelmet().clone());
                        player.getInventory().setHelmet(null);
                        player.updateInventory();
                    });
                }
            }
        }
        int slot = GadgetsMenu.getGadgetsMenuData().getGadgetSlot();
        if (player.getInventory().getItem(slot) != null) {
            CategoryManager.removeHotbarCosmetic(player);
            if (player.getInventory().getItem(slot) != null) {
                if (CategoryManager.checkEquipRequirement(player, MessageType.REMOVE_ITEM_FROM_SLOT_TO_EQUIP_EMOTE.getFormatMessage().replace("{SLOT}", String.valueOf(slot + 1)).replace("{ITEM}", player.getInventory().getItem(slot).getType().name()))) {
                    return false;
                }
                if (GadgetsMenu.getGadgetsMenuData().getEquipCosmeticItemToSlotAction() == EnumEquipType.DROP) {
                    Bukkit.getScheduler().runTask((Plugin)GadgetsMenu.getInstance(), () -> {
                        player.getWorld().dropItemNaturally(player.getLocation(), player.getInventory().getItem(slot).clone());
                        player.getInventory().setItem(slot, null);
                        player.updateInventory();
                    });
                }
            }
        }
        return true;
    }
}

