/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.gadgets;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.cosmetics.Category;
import com.yapzhenyie.GadgetsMenu.cosmetics.CategoryManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.GadgetCategoryType;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.GadgetType;
import com.yapzhenyie.GadgetsMenu.player.PlayerManager;
import com.yapzhenyie.GadgetsMenu.utils.EnumEquipType;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class GadgetManager {
    public static void equipGadget(Player player, GadgetType type) {
        if (!type.isEnabled() || !Category.GADGETS.isEnabled()) {
            return;
        }
        if (player == null) {
            return;
        }
        PlayerManager pManager = GadgetsMenu.getPlayerManager(player);
        if (pManager == null) {
            return;
        }
        int slot = GadgetsMenu.getGadgetsMenuData().getGadgetSlot();
        if (player.getInventory().getItem(slot) != null) {
            CategoryManager.removeHotbarCosmetic(player);
            if (player.getInventory().getItem(slot) != null) {
                if (CategoryManager.checkEquipRequirement(player, MessageType.REMOVE_ITEM_FROM_SLOT_TO_EQUIP_GADGET.getFormatMessage().replace("{SLOT}", String.valueOf(slot + 1)).replace("{ITEM}", player.getInventory().getItem(slot).getType().name()))) {
                    return;
                }
                if (GadgetsMenu.getGadgetsMenuData().getEquipCosmeticItemToSlotAction() == EnumEquipType.DROP) {
                    Bukkit.getScheduler().runTask((Plugin)GadgetsMenu.getInstance(), () -> {
                        player.getWorld().dropItemNaturally(player.getLocation(), player.getInventory().getItem(slot).clone());
                        player.getInventory().setItem(slot, null);
                        player.updateInventory();
                    });
                }
            }
        }
        pManager.setSelectedCategoryGadget(GadgetCategoryType.valueOf(type.getGroup()));
        pManager.setSelectedGadget(type);
        player.getInventory().setItem(slot, type.getItemStack());
        player.updateInventory();
        type.equip(player);
    }

    public static void unequipGadget(Player player) {
        if (player == null) {
            return;
        }
        PlayerManager pManager = GadgetsMenu.getPlayerManager(player);
        if (pManager == null) {
            return;
        }
        int slot = GadgetsMenu.getGadgetsMenuData().getGadgetSlot();
        if (player.getInventory().getItem(slot) != null || pManager != null || pManager.getSelectedGadget() != null) {
            if (player.getInventory().getItem(slot) != null && player.getInventory().getItem(slot).getItemMeta() != null && GadgetsMenu.getNMSManager().isNBTTagEqual(player.getInventory().getItem(slot), "Category", "Gadget")) {
                player.getInventory().setItem(slot, null);
                player.updateInventory();
            }
            if (pManager.getSelectedCategoryGadget() != null) {
                pManager.setSelectedCategoryGadget(null);
            }
            if (pManager.getSelectedGadget() != null) {
                pManager.setSelectedGadget(null);
            }
            if (pManager.getCurrentGadget() != null) {
                pManager.getCurrentGadget().onClear();
                pManager.removeGadget();
            }
        }
    }

    public static boolean checkRequirement(Player player, GadgetType type) {
        if (!type.isEnabled() || !Category.GADGETS.isEnabled()) {
            return false;
        }
        if (player == null) {
            return false;
        }
        PlayerManager pManager = GadgetsMenu.getPlayerManager(player);
        if (pManager == null) {
            return false;
        }
        int slot = GadgetsMenu.getGadgetsMenuData().getGadgetSlot();
        if (player.getInventory().getItem(slot) != null) {
            CategoryManager.removeHotbarCosmetic(player);
            if (player.getInventory().getItem(slot) != null) {
                if (CategoryManager.checkEquipRequirement(player, MessageType.REMOVE_ITEM_FROM_SLOT_TO_EQUIP_GADGET.getFormatMessage().replace("{SLOT}", String.valueOf(slot + 1)).replace("{ITEM}", player.getInventory().getItem(slot).getType().name()))) {
                    return false;
                }
                if (GadgetsMenu.getGadgetsMenuData().getEquipCosmeticItemToSlotAction() == EnumEquipType.DROP) {
                    Bukkit.getScheduler().runTask((Plugin)GadgetsMenu.getInstance(), () -> {
                        player.getWorld().dropItemNaturally(player.getLocation(), player.getInventory().getItem(slot).clone());
                        player.getInventory().setItem(slot, null);
                        player.updateInventory();
                    });
                }
            }
        }
        return true;
    }
}

