/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.GadgetType;
import com.yapzhenyie.GadgetsMenu.utils.BlockUtil;
import com.yapzhenyie.GadgetsMenu.utils.EnumPermission;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.PermissionUtils;
import java.util.ArrayList;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public abstract class Gadget
implements Listener {
    public UUID uuid;
    private GadgetType type;
    private Player player;
    private Listener listener;
    protected boolean showCooldownBar = true;
    protected boolean addCooldownAfterClick = true;
    protected static ArrayList<Player> hideCooldownBar = new ArrayList();

    public Gadget(UUID uuid, final GadgetType type) {
        this.type = type;
        if (!type.isEnabled()) {
            return;
        }
        if (uuid != null) {
            this.uuid = uuid;
            this.player = Bukkit.getPlayer((UUID)uuid);
            if (PermissionUtils.noPermission(this.getPlayer(), type.getPermission(), EnumPermission.GADGETS.getPermission(), false)) {
                GadgetsMenu.getPlayerManager(this.getPlayer()).unequipGadget();
                return;
            }
            if (GadgetsMenu.getPlayerManager(this.getPlayer()).getCurrentGadget() != null) {
                GadgetsMenu.getPlayerManager(this.getPlayer()).removeGadget();
            }
            try {
                BukkitRunnable runnable = new BukkitRunnable(){

                    public void run() {
                        if (Bukkit.getPlayer((UUID)Gadget.this.getPlayerUUID()) != null && GadgetsMenu.getPlayerManager(Gadget.this.player).getCurrentGadget() != null && GadgetsMenu.getPlayerManager(Gadget.this.player).getCurrentGadget().getType() == Gadget.this.getType()) {
                            if (GadgetsMenu.getGadgetsMenuData().isCooldownInActionBar() && Gadget.this.showCooldownBar) {
                                if (hideCooldownBar.contains(Gadget.this.player)) {
                                    return;
                                }
                                if (GadgetsMenu.getPlayerManager(Gadget.this.player).gadgetCooldown().containsKey(Gadget.this.getType())) {
                                    if (GadgetsMenu.getPlayerManager(Gadget.this.player).gadgetCooldown().get(Gadget.this.getType()) - System.currentTimeMillis() > 0L && !GadgetsMenu.getPlayerManager(Gadget.this.player).isBypassCooldown()) {
                                        GadgetsMenu.getPlayerManager(Gadget.this.player).sendCooldownBar(type.getDisplayName(), GadgetsMenu.getPlayerManager(Gadget.this.player).gadgetCooldown().get(Gadget.this.getType()), type.getCooldown());
                                    } else {
                                        GadgetsMenu.getPlayerManager(Gadget.this.player).resetCooldownBar();
                                        GadgetsMenu.getPlayerManager(Gadget.this.player).gadgetCooldown().remove(Gadget.this.getType());
                                    }
                                }
                            }
                            Gadget.this.onUpdate();
                        } else {
                            this.cancel();
                        }
                    }
                };
                runnable.runTaskTimerAsynchronously((Plugin)GadgetsMenu.getInstance(), 0L, 1L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.listener = new GadgetListener(this);
            GadgetsMenu.getInstance().registerListener(this.listener);
            GadgetsMenu.getInstance().registerListener(this);
            GadgetsMenu.getPlayerManager(this.getPlayer()).setCurrentGadget(this);
        }
    }

    protected UUID getPlayerUUID() {
        return this.uuid;
    }

    public GadgetType getType() {
        return this.type;
    }

    protected Player getPlayer() {
        return this.player;
    }

    abstract void onClick();

    abstract void onUpdate();

    public abstract void onClear();

    protected boolean checkRequirements() {
        return true;
    }

    public void removeListener() {
        HandlerList.unregisterAll((Listener)this);
    }

    public void unregisterListeners() {
        try {
            HandlerList.unregisterAll((Listener)this);
            HandlerList.unregisterAll((Listener)this.listener);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void clear() {
        if (this.uuid == null) {
            return;
        }
        if (GadgetsMenu.getPlayerManager(this.getPlayer()).getCurrentGadget() != null) {
            GadgetsMenu.getPlayerManager(this.getPlayer()).setCurrentGadget(null);
        }
        this.unregisterListeners();
        this.uuid = null;
    }

    protected void addCooldownTimer() {
        if (!GadgetsMenu.getPlayerManager(this.getPlayer()).isBypassCooldown()) {
            GadgetsMenu.getPlayerManager(this.getPlayer()).gadgetCooldown().put(this.getType(), System.currentTimeMillis() + (long)this.getType().getCooldown() * 1000L);
        }
    }

    public class GadgetListener
    implements Listener {
        private Gadget gadget;

        public GadgetListener(Gadget gadget) {
            this.gadget = gadget;
        }

        @EventHandler
        protected void onPlayerActivateGadget(PlayerInteractEvent event) {
            Player player = event.getPlayer();
            UUID uuid = player.getUniqueId();
            if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
                return;
            }
            if (!player.getItemInHand().hasItemMeta() || !player.getItemInHand().getItemMeta().hasDisplayName()) {
                return;
            }
            if (!uuid.equals(this.gadget.uuid)) {
                return;
            }
            if (player.getItemInHand().getItemMeta().getDisplayName().startsWith(this.gadget.getType().getDisplayName()) && player.getItemInHand().getType() == this.gadget.getType().getMaterial().getEnumMaterial().getType()) {
                if (GadgetsMenu.getPlayerManager(player).gadgetCooldown().containsKey(Gadget.this.getType()) && !GadgetsMenu.getPlayerManager(player).isBypassCooldown()) {
                    if (GadgetsMenu.getPlayerManager(player).gadgetCooldown().get(Gadget.this.getType()) - System.currentTimeMillis() <= 0L) {
                        GadgetsMenu.getPlayerManager(player).gadgetCooldown().remove(Gadget.this.getType());
                    } else {
                        player.sendMessage(MessageType.COOLDOWN.getFormatMessage().replace("{COOLDOWN}", String.valueOf((GadgetsMenu.getPlayerManager(player).gadgetCooldown().get(Gadget.this.getType()) - System.currentTimeMillis()) / 1000L + 1L)));
                        player.updateInventory();
                        event.setCancelled(true);
                        return;
                    }
                }
                if (PermissionUtils.noPermission(Gadget.this.getPlayer(), Gadget.this.type.getPermission(), EnumPermission.GADGETS.getPermission(), true)) {
                    GadgetsMenu.getPlayerManager(Gadget.this.getPlayer()).removeGadget();
                    event.setCancelled(true);
                    return;
                }
                if (Gadget.this.checkRequirements()) {
                    if (BlockUtil.isOutsideOfBorder(Gadget.this.getPlayer().getLocation())) {
                        Gadget.this.getPlayer().sendMessage(MessageType.NOT_ALLOWED_COSMETICS_IN_THIS_LOCATION.getFormatMessage());
                        return;
                    }
                    this.gadget.onClick();
                    if (this.gadget.addCooldownAfterClick) {
                        this.gadget.addCooldownTimer();
                    }
                    player.updateInventory();
                    event.setCancelled(true);
                    return;
                }
                player.updateInventory();
                event.setCancelled(true);
                return;
            }
        }
    }
}

