/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.configuration.FileManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.GadgetType;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types.Gadget;
import com.yapzhenyie.GadgetsMenu.utils.MathUtil;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.ParticleEffect;
import com.yapzhenyie.GadgetsMenu.utils.SoundEffect;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class GadgetBatLauncher
extends Gadget {
    private boolean activated = false;
    private HashMap<Player, Location> Velocity = new HashMap();
    private HashMap<Player, ArrayList<Bat>> bats = new HashMap();

    public GadgetBatLauncher(UUID uuid) {
        super(uuid, GadgetType.BAT_LAUNCHER);
    }

    @Override
    protected boolean checkRequirements() {
        if (this.activated) {
            this.getPlayer().sendMessage(MessageType.GADGET_IS_ACTIVATED.getFormatMessage().replace("{GADGET}", this.getType().getDisplayNameStripColor()));
            return false;
        }
        return true;
    }

    @Override
    public void onClick() {
        this.Velocity.put(this.getPlayer(), this.getPlayer().getEyeLocation());
        this.activated = true;
        this.bats.put(this.getPlayer(), new ArrayList());
        for (int i = 0; i < 16; ++i) {
            Bat bat = (Bat)this.getPlayer().getWorld().spawnEntity(this.getPlayer().getEyeLocation(), EntityType.BAT);
            this.bats.get(this.getPlayer()).add(bat);
            bat.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
        }
        SoundEffect.ENTITY_FIREWORK_ROCKET_LAUNCH.playSound(this.getPlayer());
        BukkitRunnable runnable = new BukkitRunnable(){

            public void run() {
                try {
                    if (!GadgetBatLauncher.this.getPlayer().isOnline() || GadgetsMenu.getPlayerManager(GadgetBatLauncher.this.getPlayer()).getCurrentGadget() == null || GadgetsMenu.getPlayerManager(GadgetBatLauncher.this.getPlayer()).getCurrentGadget().getType() != GadgetBatLauncher.this.getType()) {
                        GadgetBatLauncher.this.onClear();
                        this.cancel();
                        return;
                    }
                    if (GadgetBatLauncher.this.activated) {
                        GadgetBatLauncher.this.onHit(GadgetBatLauncher.this.getPlayer());
                    } else {
                        this.cancel();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    GadgetBatLauncher.this.clearAll();
                    this.cancel();
                }
            }
        };
        runnable.runTaskTimerAsynchronously((Plugin)GadgetsMenu.getInstance(), 0L, 1L);
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)GadgetsMenu.getInstance(), new Runnable(){

            @Override
            public void run() {
                if (GadgetBatLauncher.this.activated) {
                    GadgetBatLauncher.this.clearAll();
                }
            }
        }, 60L);
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public void onClear() {
        this.clearAll();
        HandlerList.unregisterAll((Listener)this);
    }

    private void clearAll() {
        if (GadgetsMenu.getInstance() != null) {
            Bukkit.getScheduler().runTask((Plugin)GadgetsMenu.getInstance(), () -> {
                for (ArrayList<Bat> bat : this.bats.values()) {
                    for (Bat bats : bat) {
                        if (!bats.isValid()) continue;
                        ParticleEffect.SMOKE_LARGE.display(bats.getLocation(), 0.1f, 0.1f, 0.1f, 3);
                        bats.remove();
                    }
                }
                this.bats.clear();
            });
        } else {
            for (ArrayList<Bat> bat : this.bats.values()) {
                for (Bat bats : bat) {
                    if (!bats.isValid()) continue;
                    ParticleEffect.SMOKE_LARGE.display(bats.getLocation(), 0.1f, 0.1f, 0.1f, 3);
                    bats.remove();
                }
            }
            this.bats.clear();
        }
        if (!this.Velocity.isEmpty()) {
            this.Velocity.clear();
        }
        this.activated = false;
    }

    private void onHit(Player player) {
        Location loc = this.Velocity.get(player);
        for (Bat bat : this.bats.get(player)) {
            if (bat.isValid()) {
                Vector rand = new Vector((Math.random() - 0.5) / 3.0, (Math.random() - 0.5) / 3.0, (Math.random() - 0.5) / 3.0);
                bat.setVelocity(loc.getDirection().clone().multiply(0.5).add(rand));
                if (!FileManager.getGadgetsFile().getBoolean("Gadgets.Mobs And NPCs.Types.Bat Launcher.Affect-Players")) continue;
                for (Player other : Bukkit.getOnlinePlayers()) {
                    if (other.getWorld() != bat.getWorld() || !other.isOnline() || other.equals(player) || !this.hitPlayer(bat.getLocation(), other)) continue;
                    Vector v = bat.getLocation().getDirection();
                    v.normalize();
                    v.multiply(0.4);
                    v.setY(v.getY() + 0.2);
                    if (v.getY() > 7.5) {
                        v.setY(7.5);
                    }
                    if (other.isOnGround()) {
                        v.setY(v.getY() + 0.2);
                    }
                    other.setFallDistance(0.0f);
                    MathUtil.applyVelocity((Entity)other, bat.getLocation().getDirection().add(new Vector(0.0f, 0.4f, 0.0f)));
                    SoundEffect.ENTITY_BAT_HURT.playSound((Entity)bat);
                    ParticleEffect.SMOKE_LARGE.display(bat.getLocation(), 0.1f, 0.1f, 0.1f, 3);
                    Bukkit.getScheduler().runTask((Plugin)GadgetsMenu.getInstance(), () -> bat.remove());
                }
                continue;
            }
            this.onClear();
            break;
        }
    }

    private boolean hitPlayer(Location loc, Player player) {
        if (loc.add(0.0, -loc.getY(), 0.0).toVector().subtract(player.getLocation().add(0.0, -player.getLocation().getY(), 0.0).toVector()).length() < 0.8) {
            return true;
        }
        return loc.add(0.0, -loc.getY(), 0.0).toVector().subtract(player.getLocation().add(0.0, -player.getLocation().getY(), 0.0).toVector()).length() < 1.2 && loc.getY() > player.getLocation().getY() && loc.getY() < player.getEyeLocation().getY();
    }
}

