/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.GadgetType;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types.Gadget;
import com.yapzhenyie.GadgetsMenu.utils.EnumMaterial;
import com.yapzhenyie.GadgetsMenu.utils.FireworkUtils;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.ParticleEffect;
import com.yapzhenyie.GadgetsMenu.utils.SoundEffect;
import com.yapzhenyie.GadgetsMenu.utils.VersionManager;
import com.yapzhenyie.GadgetsMenu.utils.cosmetics.pets.types.GOcelotType;
import com.yapzhenyie.GadgetsMenu.utils.items.ItemUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Cat;
import org.bukkit.entity.Item;
import org.bukkit.entity.Ocelot;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class GadgetCATapult
extends Gadget {
    private boolean activated = false;
    private ArrayList<Item> items = new ArrayList();
    private HashMap<Animals, Vector> ocelots = new HashMap();
    private static GOcelotType[] types = new GOcelotType[]{GOcelotType.BLACK_CAT, GOcelotType.RED_CAT, GOcelotType.SIAMESE_CAT, GOcelotType.WILD_OCELOT};

    public GadgetCATapult(UUID uuid) {
        super(uuid, GadgetType.CATAPULT);
    }

    @Override
    protected boolean checkRequirements() {
        if (this.activated) {
            this.getPlayer().sendMessage(MessageType.GADGET_IS_ACTIVATED.getFormatMessage().replace("{GADGET}", this.getType().getDisplayNameStripColor()));
            return false;
        }
        return true;
    }

    @Override
    public void onClick() {
        this.activated = true;
        new BukkitRunnable(){
            int step = 0;

            public void run() {
                if (!GadgetCATapult.this.getPlayer().isOnline() || GadgetsMenu.getPlayerManager(GadgetCATapult.this.getPlayer()).getCurrentGadget() == null || GadgetsMenu.getPlayerManager(GadgetCATapult.this.getPlayer()).getCurrentGadget().getType() != GadgetCATapult.this.getType()) {
                    this.step = 41;
                    GadgetCATapult.this.onClear();
                    this.cancel();
                    return;
                }
                if (!GadgetCATapult.this.ocelots.isEmpty()) {
                    for (Animals ocelot : GadgetCATapult.this.ocelots.keySet()) {
                        ocelot.setVelocity(new Vector(((Vector)GadgetCATapult.this.ocelots.get(ocelot)).getX() / 2.0, ((Vector)GadgetCATapult.this.ocelots.get(ocelot)).getY() / 2.0, ((Vector)GadgetCATapult.this.ocelots.get(ocelot)).getZ() / 2.0));
                    }
                }
                ++this.step;
                if (this.step == 1 || this.step == 5 || this.step == 10 || this.step == 15 || this.step == 20) {
                    GOcelotType randomType = types[GadgetsMenu.random().nextInt(types.length)];
                    if (VersionManager.is1_14OrAbove() && randomType != GOcelotType.WILD_OCELOT) {
                        Cat cat = (Cat)GadgetCATapult.this.getPlayer().getWorld().spawn(GadgetCATapult.this.getPlayer().getEyeLocation(), Cat.class);
                        cat.setCatType(randomType.getType());
                        cat.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
                        GadgetCATapult.this.ocelots.put(cat, GadgetCATapult.this.getPlayer().getLocation().getDirection());
                    } else {
                        Animals ocelot;
                        ocelot = (Ocelot)GadgetCATapult.this.getPlayer().getWorld().spawn(GadgetCATapult.this.getPlayer().getEyeLocation(), Ocelot.class);
                        if (!VersionManager.is1_14OrAbove()) {
                            ocelot.setCatType(randomType.getDepracatedType());
                        }
                        ocelot.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
                        GadgetCATapult.this.ocelots.put(ocelot, GadgetCATapult.this.getPlayer().getLocation().getDirection());
                    }
                    SoundEffect.ENTITY_FIREWORK_ROCKET_LAUNCH.playSound(GadgetCATapult.this.getPlayer());
                } else if (this.step == 40) {
                    int step2 = 0;
                    for (final Animals ocelot : GadgetCATapult.this.ocelots.keySet()) {
                        if (step2 < 3) {
                            FireworkUtils.displayFirework(ocelot.getLocation(), FireworkEffect.Type.BURST, false, false, Arrays.asList(Color.RED), Arrays.asList(Color.RED));
                            final EnumMaterial[] materials = new EnumMaterial[]{EnumMaterial.POPPY, EnumMaterial.BONE, EnumMaterial.STRING};
                            new BukkitRunnable(){
                                int step3 = 0;

                                public void run() {
                                    if (!GadgetCATapult.this.getPlayer().isOnline() || GadgetsMenu.getPlayerManager(GadgetCATapult.this.getPlayer()).getCurrentGadget() == null || GadgetsMenu.getPlayerManager(GadgetCATapult.this.getPlayer()).getCurrentGadget().getType() != GadgetCATapult.this.getType()) {
                                        this.step3 = 55;
                                        GadgetCATapult.this.onClear();
                                        this.cancel();
                                        return;
                                    }
                                    ++this.step3;
                                    for (Item item : GadgetCATapult.this.items) {
                                        if (item.getTicksLived() <= 50) continue;
                                        item.remove();
                                    }
                                    if (this.step3 == 1) {
                                        for (int i = 0; i <= 25; ++i) {
                                            Item item;
                                            item = GadgetCATapult.this.getPlayer().getWorld().dropItem(ocelot.getEyeLocation(), ItemUtils.item(UUID.randomUUID().toString(), materials[GadgetsMenu.random().nextInt(materials.length)], 0));
                                            item.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
                                            item.setVelocity(new Vector((GadgetsMenu.random().nextDouble() - 0.5) / 1.7, 0.4, (GadgetsMenu.random().nextDouble() - 0.5) / 1.7));
                                            GadgetCATapult.this.items.add(item);
                                        }
                                    } else if (this.step3 == 2) {
                                        if (ocelot.isOnGround()) {
                                            ParticleEffect.BLOCK_CRACK.display(new ParticleEffect.ItemData(EnumMaterial.REDSTONE_BLOCK, 0), ocelot.getLocation(), 1.0f, 0.0f, 1.0f, 0.0f, 5);
                                        }
                                    } else if (this.step3 >= 40) {
                                        GadgetCATapult.this.clearAll();
                                        this.cancel();
                                    }
                                }
                            }.runTaskTimer((Plugin)GadgetsMenu.getInstance(), 0L, 1L);
                        }
                        ++step2;
                        ocelot.remove();
                    }
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)GadgetsMenu.getInstance(), 0L, 1L);
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public void onClear() {
        this.clearAll();
        HandlerList.unregisterAll((Listener)this);
    }

    private void clearAll() {
        if (!this.items.isEmpty()) {
            for (Item item : this.items) {
                item.remove();
            }
            this.items.clear();
        }
        this.activated = false;
        for (Animals ocelot : this.ocelots.keySet()) {
            ocelot.remove();
        }
        this.ocelots.clear();
    }
}

