/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.GadgetType;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types.Gadget;
import com.yapzhenyie.GadgetsMenu.utils.CuboID;
import com.yapzhenyie.GadgetsMenu.utils.EnumMaterial;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.ParticleEffect;
import com.yapzhenyie.GadgetsMenu.utils.ReflectionUtils;
import com.yapzhenyie.GadgetsMenu.utils.VersionManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class GadgetCryotube
extends Gadget {
    private boolean activated = false;
    private ArrayList<Block> blocks = new ArrayList();
    private HashMap<Location, String> floorBlocks = new HashMap();

    public GadgetCryotube(UUID uuid) {
        super(uuid, GadgetType.CRYOTUBE);
    }

    @Override
    protected boolean checkRequirements() {
        Location loc2;
        if (this.activated) {
            this.getPlayer().sendMessage(MessageType.GADGET_IS_ACTIVATED.getFormatMessage().replace("{GADGET}", this.getType().getDisplayNameStripColor()));
            return false;
        }
        if (!this.getPlayer().isOnGround()) {
            this.getPlayer().sendMessage(MessageType.NOT_ON_GROUND.getFormatMessage());
            return false;
        }
        Location loc1 = this.getPlayer().getLocation().clone().add(0.0, 0.0, 0.0);
        CuboID cuboid = new CuboID(loc1, loc2 = this.getPlayer().getLocation().clone().add(0.0, 2.0, 0.0));
        if (!cuboid.isEmpty() || cuboid.hasHangingEntities()) {
            this.getPlayer().sendMessage(MessageType.NOT_ENOUGH_SPACE.getFormatMessage());
            return false;
        }
        return true;
    }

    @Override
    public void onClick() {
        this.activated = true;
        final Location location = this.getPlayer().getLocation();
        final Location centerLocation = location.clone().getBlock().getLocation();
        this.getPlayer().teleport(centerLocation.clone().add(0.5, 0.0, 0.5).setDirection(this.getPlayer().getLocation().getDirection()));
        Block fblock = location.clone().subtract(0.0, 1.0, 0.0).getBlock();
        if (VersionManager.is1_13OrAbove()) {
            try {
                this.floorBlocks.put(fblock.getLocation(), fblock.getBlockData().getAsString());
            }
            catch (NoSuchMethodError noSuchMethodError) {}
        } else {
            try {
                this.floorBlocks.put(fblock.getLocation(), fblock.getType().toString() + "," + fblock.getData());
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }
        fblock.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
        new BukkitRunnable(){
            int step = 0;

            public void run() {
                if (!GadgetCryotube.this.getPlayer().isOnline() || GadgetsMenu.getPlayerManager(GadgetCryotube.this.getPlayer()).getCurrentGadget() == null || GadgetsMenu.getPlayerManager(GadgetCryotube.this.getPlayer()).getCurrentGadget().getType() != GadgetCryotube.this.getType()) {
                    this.step = 40;
                    GadgetCryotube.this.onClear();
                    this.cancel();
                    return;
                }
                ++this.step;
                if (this.step <= 40) {
                    ParticleEffect.SPELL_INSTANT.display(centerLocation.clone().add(0.5, 2.0, 0.5), 1.0f, 10);
                    ParticleEffect.FLAME.display(centerLocation.clone().add(0.5, 2.0, 0.5), 0.0f, 10);
                    ParticleEffect.SNOWBALL.display(centerLocation.clone().add(0.5, 2.0, 0.5), 0.0f, 10);
                    for (int i = 0; i <= 1; ++i) {
                        Block ice = location.clone().add(0.0, (double)i, 0.0).getBlock();
                        if (ice.getType() == EnumMaterial.ICE.getType()) continue;
                        ice.setType(EnumMaterial.ICE.getType());
                        ice.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
                        GadgetCryotube.this.blocks.add(ice);
                    }
                    Block step = location.clone().add(0.0, 2.0, 0.0).getBlock();
                    if (step.getType() != EnumMaterial.SMOOTH_STONE_SLAB.getType()) {
                        step.setType(EnumMaterial.SMOOTH_STONE_SLAB.getType());
                        step.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
                        GadgetCryotube.this.blocks.add(step);
                    }
                    GadgetsMenu.getPlayerManager(GadgetCryotube.this.getPlayer()).disableBlockDamage();
                } else {
                    GadgetCryotube.this.clearAll();
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)GadgetsMenu.getInstance(), 0L, 5L);
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public void onClear() {
        this.clearAll();
        HandlerList.unregisterAll((Listener)this);
    }

    private void clearAll() {
        for (Block block : this.blocks) {
            block.removeMetadata(GadgetsMenu.getInstance().getPluginName(), (Plugin)GadgetsMenu.getInstance());
            block.setType(Material.AIR);
        }
        this.blocks.clear();
        GadgetsMenu.getPlayerManager(this.getPlayer()).enableBlockDamage();
        this.forceRestore();
        this.activated = false;
    }

    private void forceRestore() {
        if (this.floorBlocks.isEmpty()) {
            return;
        }
        for (Location loc : this.floorBlocks.keySet()) {
            Block b = loc.getBlock();
            if (VersionManager.is1_13OrAbove()) {
                try {
                    BlockData blockData = Bukkit.getServer().createBlockData(this.floorBlocks.get(loc));
                    b.setBlockData(blockData);
                }
                catch (NoSuchMethodError blockData) {}
            } else {
                String s = this.floorBlocks.get(loc);
                Material m = Material.valueOf((String)s.split(",")[0]);
                byte d = Byte.valueOf(s.split(",")[1]);
                b.setType(m);
                ReflectionUtils.setData(b, d);
            }
            b.removeMetadata(GadgetsMenu.getInstance().getPluginName(), (Plugin)GadgetsMenu.getInstance());
        }
        this.floorBlocks.clear();
    }
}

