/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.configuration.FileManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.GadgetType;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types.Gadget;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types.GadgetDiscoBall;
import com.yapzhenyie.GadgetsMenu.utils.BlockUtil;
import com.yapzhenyie.GadgetsMenu.utils.CuboID;
import com.yapzhenyie.GadgetsMenu.utils.EnumMaterial;
import com.yapzhenyie.GadgetsMenu.utils.EnumPermission;
import com.yapzhenyie.GadgetsMenu.utils.GMaterial;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.PermissionUtils;
import com.yapzhenyie.GadgetsMenu.utils.ReflectionUtils;
import com.yapzhenyie.GadgetsMenu.utils.VersionManager;
import depend.xxmicloxx.NoteBlockAPI.model.Song;
import depend.xxmicloxx.NoteBlockAPI.songplayer.PositionSongPlayer;
import depend.xxmicloxx.NoteBlockAPI.utils.NBSDecoder;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.EulerAngle;

public class GadgetDJBooth
extends Gadget {
    private static int duration = FileManager.getGadgetsFile().get("Gadgets.Musical.Types.DJ Booth.Duration-Seconds") == null ? 60 : FileManager.getGadgetsFile().getInt("Gadgets.Musical.Types.DJ Booth.Duration-Seconds");
    public static HashMap<GadgetDJBooth, Location> DJ_BOOTH = new HashMap();
    private boolean activated = false;
    private Location location;
    private CuboID danceFloorCuboid;
    private PositionSongPlayer positionSongPlayer;
    private HashMap<Location, String> blocks = new HashMap();
    private ArrayList<ArmorStand> armorstands = new ArrayList();
    private static File files = new File(GadgetsMenu.getInstance().getDataFolder().getPath() + "/songs/DjBoothGadget/");
    private static List<File> songs = new ArrayList<File>();
    private static final List<String> blackList = FileManager.getGadgetsFile().getStringList(GadgetType.DJ_BOOTH.getFilePath() + ".Blacklist");

    public GadgetDJBooth(UUID uuid) {
        super(uuid, GadgetType.DJ_BOOTH);
        if (songs.isEmpty()) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)GadgetsMenu.getInstance(), () -> {
                if (files.exists() && files.listFiles().length > 0) {
                    for (File f : files.listFiles()) {
                        if (!f.getName().contains(".nbs") || songs.contains(f)) continue;
                        songs.add(f);
                    }
                }
            });
        }
    }

    @Override
    protected boolean checkRequirements() {
        if (this.activated) {
            this.getPlayer().sendMessage(MessageType.GADGET_IS_ACTIVATED.getFormatMessage().replace("{GADGET}", this.getType().getDisplayNameStripColor()));
            return false;
        }
        for (Location loc : DJ_BOOTH.values()) {
            if (!loc.getWorld().equals(this.getPlayer().getWorld())) continue;
            this.getPlayer().sendMessage(MessageType.SAME_TYPE_GADGET_ACTIVATED.getFormatMessage().replace("{GADGET}", this.getType().getDisplayNameStripColor()));
            return false;
        }
        for (Location loc : GadgetDiscoBall.DISCO_BALLS.values()) {
            if (!loc.getWorld().equals(this.getPlayer().getWorld()) || !(loc.distanceSquared(this.getPlayer().getLocation()) <= 625.0)) continue;
            this.getPlayer().sendMessage(MessageType.SAME_TYPE_GADGET_ACTIVATED.getFormatMessage().replace("{GADGET}", GadgetType.DISCO_BALL.getDisplayNameStripColor()));
            return false;
        }
        if (!this.getPlayer().isOnGround()) {
            this.getPlayer().sendMessage(MessageType.NOT_ON_GROUND.getFormatMessage());
            return false;
        }
        Location loc1 = this.getPlayer().getLocation().clone().add(0.0, 0.0, -2.0);
        Location loc2 = this.getPlayer().getLocation().clone().add(2.0, 5.0, 2.0);
        Location danceFloorLoc1 = this.getPlayer().getLocation().clone().add(2.0, -1.0, -2.0);
        Location danceFloorLoc2 = this.getPlayer().getLocation().clone().add(6.0, 3.0, 2.0);
        CuboID cuboid = new CuboID(loc1, loc2);
        this.danceFloorCuboid = new CuboID(danceFloorLoc1, danceFloorLoc2);
        if (!cuboid.isEmpty()) {
            this.getPlayer().sendMessage(MessageType.NOT_ENOUGH_SPACE.getFormatMessage());
            return false;
        }
        for (Block block : this.danceFloorCuboid.getBlocks()) {
            if (block.hasMetadata(GadgetsMenu.getInstance().getPluginName())) {
                this.getPlayer().sendMessage(MessageType.GADGET_ACTIVATED_IN_SAME_AREA.getFormatMessage());
                return false;
            }
            for (String blackList : GadgetDJBooth.blackList) {
                GMaterial gMaterial = new GMaterial(blackList);
                if (block.getType() != gMaterial.getEnumMaterial().getType() || block.getData() != gMaterial.getData()) continue;
                this.getPlayer().sendMessage(MessageType.NOT_ALLOWED_COSMETICS_IN_THIS_LOCATION.getFormatMessage());
                return false;
            }
            if (!block.isLiquid() && !block.getType().toString().toLowerCase().contains("banner") && block.getType() != EnumMaterial.BREWING_STAND.getType() && block.getType() != EnumMaterial.BROWN_MUSHROOM.getType() && block.getType() != EnumMaterial.CACTUS.getType() && block.getType() != EnumMaterial.CAKE.getType() && !block.getType().toString().toLowerCase().contains("cake_block") && !block.getType().toString().toLowerCase().contains("carpet") && block.getType() != EnumMaterial.CARROT.getType() && block.getType() != EnumMaterial.CARROTS.getType() && block.getType() != EnumMaterial.CHEST.getType() && block.getType() != EnumMaterial.COBWEB.getType() && !block.getType().toString().toLowerCase().contains("command") && !block.getType().toString().toLowerCase().contains("crops") && block.getType() != EnumMaterial.DANDELION.getType() && block.getType() != EnumMaterial.DEAD_BUSH.getType() && !block.getType().toString().toLowerCase().contains("double_plant") && block.getType() != EnumMaterial.FARMLAND.getType() && block.getType() != EnumMaterial.FERN.getType() && block.getType() != EnumMaterial.FIRE.getType() && block.getType() != EnumMaterial.FLOWER_POT.getType() && !block.getType().toString().toLowerCase().contains("flower_pot") && block.getType() != EnumMaterial.GRASS.getType() && !block.getType().toString().toLowerCase().contains("head") && block.getType() != EnumMaterial.LADDER.getType() && block.getType() != EnumMaterial.LARGE_FERN.getType() && block.getType() != EnumMaterial.LEVER.getType() && block.getType() != EnumMaterial.LILAC.getType() && block.getType() != EnumMaterial.LILY_PAD.getType() && !block.getType().toString().toLowerCase().contains("long_grass") && block.getType() != EnumMaterial.MELON_STEM.getType() && block.getType() != EnumMaterial.MUSHROOM_STEM.getType() && block.getType() != EnumMaterial.NETHER_WART.getType() && block.getType() != EnumMaterial.PEONY.getType() && !block.getType().toString().toLowerCase().contains("plate") && block.getType() != EnumMaterial.POTATO.getType() && block.getType() != EnumMaterial.POTATOES.getType() && !block.getType().toString().toLowerCase().contains("potted_") && block.getType() != EnumMaterial.PUMPKIN_STEM.getType() && !block.getType().toString().toLowerCase().contains("redstone_comparator") && !block.getType().toString().toLowerCase().contains("redstone_lamp") && !block.getType().toString().toLowerCase().contains("redstone_torch") && block.getType() != EnumMaterial.REDSTONE_WIRE.getType() && block.getType() != EnumMaterial.REPEATER.getType() && block.getType() != EnumMaterial.RED_MUSHROOM.getType() && !block.getType().toString().toLowerCase().contains("red_rose") && block.getType() != EnumMaterial.ROSE_BUSH.getType() && !block.getType().toString().toLowerCase().contains("sapling") && !block.getType().toString().toLowerCase().contains("seeds") && !block.getType().toString().toLowerCase().contains("sign") && !block.getType().toString().toLowerCase().contains("shulker_box") && !block.getType().toString().toLowerCase().contains("skull") && block.getType() != EnumMaterial.SNOW.getType() && block.getType() != EnumMaterial.SUGAR_CANE.getType() && !block.getType().toString().toLowerCase().contains("sugar_cane_block") && block.getType() != EnumMaterial.SUNFLOWER.getType() && block.getType() != EnumMaterial.TALL_GRASS.getType() && block.getType() != EnumMaterial.TORCH.getType() && block.getType() != EnumMaterial.TRIPWIRE.getType() && block.getType() != EnumMaterial.TRIPWIRE_HOOK.getType() && !block.getType().toString().toLowerCase().contains("tulip") && block.getType() != EnumMaterial.VINE.getType() && block.getType() != EnumMaterial.WHEAT.getType() && !block.getType().toString().toLowerCase().contains("_button") && !BlockUtil.hasHangingEntities(block.getLocation()) && !BlockUtil.isCocoaBlock(block)) continue;
            this.getPlayer().sendMessage(MessageType.NOT_ON_FLAT_GROUND.getFormatMessage());
            return false;
        }
        return true;
    }

    @Override
    public void onClick() {
        this.location = this.getPlayer().getLocation().clone();
        Location teleportLoc = this.getPlayer().getLocation().getBlock().getLocation().clone().add(0.5, 2.0, 0.5);
        teleportLoc.setYaw(-90.0f);
        this.getPlayer().teleport(teleportLoc);
        this.genetateDanceFloor();
        Bukkit.getScheduler().runTaskTimer((Plugin)GadgetsMenu.getInstance(), () -> {
            if (!this.getPlayer().isOnline() || GadgetsMenu.getPlayerManager(this.getPlayer()).getCurrentGadget() == null || GadgetsMenu.getPlayerManager(this.getPlayer()).getCurrentGadget().getType() != this.getType() || !this.activated) {
                return;
            }
            for (int i = 2; i <= 6; ++i) {
                this.changeDanceFloorBlock(this.getLocation(i, -1, -2), EnumMaterial.valueOf(35, GadgetsMenu.random().nextInt(16)));
                this.changeDanceFloorBlock(this.getLocation(i, -1, -1), EnumMaterial.valueOf(35, GadgetsMenu.random().nextInt(16)));
                this.changeDanceFloorBlock(this.getLocation(i, -1, 0), EnumMaterial.valueOf(35, GadgetsMenu.random().nextInt(16)));
                this.changeDanceFloorBlock(this.getLocation(i, -1, 1), EnumMaterial.valueOf(35, GadgetsMenu.random().nextInt(16)));
                this.changeDanceFloorBlock(this.getLocation(i, -1, 2), EnumMaterial.valueOf(35, GadgetsMenu.random().nextInt(16)));
            }
        }, 10L, 10L);
        if (!DJ_BOOTH.containsKey(this)) {
            DJ_BOOTH.put(this, this.getPlayer().getLocation());
        }
        File song = songs.get(new Random().nextInt(songs.size()));
        Song s = NBSDecoder.parse(song);
        this.positionSongPlayer = new PositionSongPlayer(s);
        this.positionSongPlayer.setTargetLocation(this.getLocation(1, 1, 0).getLocation().add(-0.5, -0.5, -0.5));
        this.positionSongPlayer.setPlaying(true);
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (p.getWorld() != this.location.getWorld() || !p.isOnline()) continue;
            this.positionSongPlayer.addPlayer(p);
        }
        this.positionSongPlayer.setVolume((byte)100);
        this.positionSongPlayer.getFadeIn().setFadeStart((byte)25);
        this.positionSongPlayer.getFadeOut().setFadeStart((byte)25);
        int dura = duration;
        if (!PermissionUtils.noPermission(this.getPlayer(), EnumPermission.BYPASS_DJ_BOOTH_DURATION.getPermission(), false)) {
            dura = this.positionSongPlayer.getSong().getLength() / 20;
        }
        if (dura > this.positionSongPlayer.getSong().getLength() / 20) {
            dura = this.positionSongPlayer.getSong().getLength() / 20;
        }
        new BukkitRunnable(){

            public void run() {
                if (!GadgetDJBooth.this.getPlayer().isOnline() || GadgetsMenu.getPlayerManager(GadgetDJBooth.this.getPlayer()).getCurrentGadget() == null || GadgetsMenu.getPlayerManager(GadgetDJBooth.this.getPlayer()).getCurrentGadget().getType() != GadgetDJBooth.this.getType() || !GadgetDJBooth.this.activated) {
                    return;
                }
                GadgetDJBooth.this.clearAll();
            }
        }.runTaskLater((Plugin)GadgetsMenu.getInstance(), (long)(20 * dura));
        this.activated = true;
    }

    @Override
    public void onUpdate() {
        if (this.activated) {
            Bukkit.getScheduler().runTask((Plugin)GadgetsMenu.getInstance(), () -> {
                if (!this.getPlayer().isOnline() || GadgetsMenu.getPlayerManager(this.getPlayer()).getCurrentGadget() == null || GadgetsMenu.getPlayerManager(this.getPlayer()).getCurrentGadget().getType() != this.getType() || !this.activated) {
                    return;
                }
                for (Player p : Bukkit.getOnlinePlayers()) {
                    if (!p.isOnline() || p.getWorld() != this.location.getWorld() || this.positionSongPlayer.getPlayerList().contains(p)) continue;
                    this.positionSongPlayer.addPlayer(p);
                }
            });
        }
    }

    @Override
    public void onClear() {
        this.clearAll();
        HandlerList.unregisterAll((Listener)this);
    }

    private void clearAll() {
        for (Location location : this.blocks.keySet()) {
            Block b = location.clone().getBlock();
            if (VersionManager.is1_13OrAbove()) {
                try {
                    BlockData blockData = Bukkit.getServer().createBlockData(this.blocks.get(location));
                    b.setBlockData(blockData);
                }
                catch (NoSuchMethodError blockData) {}
            } else {
                String s = this.blocks.get(location);
                Material m = Material.valueOf((String)s.split(",")[0]);
                byte d = Byte.valueOf(s.split(",")[1]);
                b.setType(m);
                ReflectionUtils.setData(b, d);
            }
            b.removeMetadata(GadgetsMenu.getInstance().getPluginName(), (Plugin)GadgetsMenu.getInstance());
        }
        this.blocks.clear();
        for (ArmorStand as : this.armorstands) {
            as.remove();
        }
        this.armorstands.clear();
        if (this.positionSongPlayer != null && this.positionSongPlayer.isPlaying()) {
            this.positionSongPlayer.setPlaying(false);
        }
        this.positionSongPlayer = null;
        this.location = null;
        if (DJ_BOOTH.containsKey(this)) {
            DJ_BOOTH.remove(this);
        }
        this.activated = false;
    }

    private void genetateDanceFloor() {
        this.setBlock(this.getLocation(0, 0, 0), EnumMaterial.DARK_OAK_STAIRS, true, (byte)0);
        this.setBlock(this.getLocation(0, 0, -1), EnumMaterial.DARK_OAK_STAIRS, true, (byte)0);
        this.setBlock(this.getLocation(0, 0, -2), EnumMaterial.DARK_OAK_STAIRS, true, (byte)2);
        this.setBlock(this.getLocation(1, 0, -2), EnumMaterial.DARK_OAK_STAIRS, true, (byte)2);
        this.setBlock(this.getLocation(0, 0, 1), EnumMaterial.DARK_OAK_STAIRS, true, (byte)0);
        this.setBlock(this.getLocation(0, 0, 2), EnumMaterial.DARK_OAK_STAIRS, true, (byte)3);
        this.setBlock(this.getLocation(1, 0, 2), EnumMaterial.DARK_OAK_STAIRS, true, (byte)3);
        this.setBlock(this.getLocation(1, 0, -1), EnumMaterial.DARK_OAK_PLANKS, false, (byte)0);
        this.setBlock(this.getLocation(1, 0, 0), EnumMaterial.DARK_OAK_PLANKS, false, (byte)0);
        this.setBlock(this.getLocation(1, 0, 1), EnumMaterial.DARK_OAK_PLANKS, false, (byte)0);
        this.setBlock(this.getLocation(1, 1, 0), EnumMaterial.NOTE_BLOCK, false, (byte)0);
        Location armorStandLoc1 = this.getPlayer().getLocation().getBlock().getLocation().clone();
        armorStandLoc1.setYaw(180.0f);
        armorStandLoc1.add(1.3, -0.8, 1.1);
        ArmorStand as = (ArmorStand)this.getPlayer().getWorld().spawnEntity(armorStandLoc1, EntityType.ARMOR_STAND);
        as.setVisible(false);
        as.setGravity(false);
        as.setSmall(false);
        as.setArms(true);
        as.setRightArmPose(new EulerAngle(0.0, 0.0, 0.0));
        try {
            if (VersionManager.is1_9OrAbove()) {
                as.setSilent(true);
            }
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        as.setItemInHand(new ItemStack(EnumMaterial.MUSIC_DISC_BLOCKS.getType()));
        as.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
        this.armorstands.add(as);
        Location armorStandLoc2 = this.getPlayer().getLocation().getBlock().getLocation().clone();
        armorStandLoc2.setYaw(0.0f);
        armorStandLoc2.add(2.015, -0.8, -0.1);
        ArmorStand as2 = (ArmorStand)this.getPlayer().getWorld().spawnEntity(armorStandLoc2, EntityType.ARMOR_STAND);
        as2.setVisible(false);
        as2.setGravity(false);
        as2.setSmall(false);
        as2.setArms(true);
        as2.setRightArmPose(new EulerAngle(0.0, 0.0, 0.0));
        try {
            if (VersionManager.is1_9OrAbove()) {
                as2.setSilent(true);
            }
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        as2.setItemInHand(new ItemStack(EnumMaterial.MUSIC_DISC_BLOCKS.getType()));
        as2.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
        this.armorstands.add(as2);
        for (int i = 2; i <= 6; ++i) {
            this.setBlock(this.getLocation(i, -1, -2), EnumMaterial.valueOf(159, GadgetsMenu.random().nextInt(16)), false, (byte)0);
            this.setBlock(this.getLocation(i, -1, -1), EnumMaterial.valueOf(159, GadgetsMenu.random().nextInt(16)), false, (byte)0);
            this.setBlock(this.getLocation(i, -1, 0), EnumMaterial.valueOf(159, GadgetsMenu.random().nextInt(16)), false, (byte)0);
            this.setBlock(this.getLocation(i, -1, 1), EnumMaterial.valueOf(159, GadgetsMenu.random().nextInt(16)), false, (byte)0);
            this.setBlock(this.getLocation(i, -1, 2), EnumMaterial.valueOf(159, GadgetsMenu.random().nextInt(16)), false, (byte)0);
        }
    }

    private void setBlock(Block block, EnumMaterial material, boolean changeFacing, byte facing) {
        if (!this.blocks.containsKey(block.getLocation())) {
            if (VersionManager.is1_13OrAbove()) {
                try {
                    this.blocks.put(block.getLocation(), block.getBlockData().getAsString());
                }
                catch (NoSuchMethodError noSuchMethodError) {}
            } else {
                try {
                    this.blocks.put(block.getLocation(), block.getType().toString() + "," + block.getData());
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
            }
            block.setType(material.getType());
            if (VersionManager.is1_13OrAbove()) {
                if (changeFacing) {
                    BlockData blockData = block.getBlockData();
                    ((Directional)blockData).setFacing(BlockUtil.getBlockFace(facing));
                    block.setBlockData(blockData);
                }
            } else {
                ReflectionUtils.setData(block, changeFacing ? facing : material.getData());
            }
            block.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
        }
    }

    private void changeDanceFloorBlock(Block block, EnumMaterial material) {
        block.setType(material.getType());
        ReflectionUtils.setData(block, material.getData());
        block.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
    }

    private Block getLocation(int x, int y, int z) {
        return this.location.getBlock().getRelative(x, y, z);
    }
}

