/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.GadgetType;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types.Gadget;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.ParticleEffect;
import com.yapzhenyie.GadgetsMenu.utils.SoundEffect;
import java.util.UUID;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.hanging.HangingBreakEvent;
import org.bukkit.event.vehicle.VehicleDestroyEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class GadgetExplosiveBow
extends Gadget {
    private Arrow arrow;
    private TNTPrimed TNT;
    private boolean activated = false;

    public GadgetExplosiveBow(UUID uuid) {
        super(uuid, GadgetType.EXPLOSIVE_BOW);
    }

    @Override
    protected boolean checkRequirements() {
        if (this.activated) {
            this.getPlayer().sendMessage(MessageType.GADGET_IS_ACTIVATED.getFormatMessage().replace("{GADGET}", this.getType().getDisplayNameStripColor()));
            return false;
        }
        return super.checkRequirements();
    }

    @Override
    public void onClick() {
        final Arrow projectileArrow = (Arrow)this.getPlayer().launchProjectile(Arrow.class, this.getPlayer().getLocation().getDirection().multiply(1.25).add(new Vector(0.0, 0.1, 0.0)));
        projectileArrow.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
        this.arrow = projectileArrow;
        this.activated = true;
        new BukkitRunnable(){
            int step = 0;

            public void run() {
                ++this.step;
                if (!GadgetExplosiveBow.this.getPlayer().isOnline() || GadgetsMenu.getPlayerManager(GadgetExplosiveBow.this.getPlayer()).getCurrentGadget() == null || GadgetsMenu.getPlayerManager(GadgetExplosiveBow.this.getPlayer()).getCurrentGadget().getType() != GadgetExplosiveBow.this.getType()) {
                    this.step = 7;
                    GadgetExplosiveBow.this.onClear();
                    this.cancel();
                    return;
                }
                if (this.step <= 6) {
                    ParticleEffect.FLAME.display(projectileArrow.getLocation(), 0.3f, 10);
                    ParticleEffect.LAVA.display(projectileArrow.getLocation(), 1.0f, 3);
                    SoundEffect.ENTITY_ARROW_SHOOT.playSound((Entity)projectileArrow);
                } else {
                    TNTPrimed tnt = (TNTPrimed)GadgetExplosiveBow.this.getPlayer().getWorld().spawn(projectileArrow.getLocation(), TNTPrimed.class);
                    tnt.setFuseTicks(20);
                    tnt.setVelocity(projectileArrow.getLocation().getDirection().multiply(0.4));
                    tnt.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
                    GadgetExplosiveBow.this.TNT = tnt;
                    if (GadgetExplosiveBow.this.arrow != null) {
                        GadgetExplosiveBow.this.arrow.remove();
                    }
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)GadgetsMenu.getInstance(), 6L, 5L);
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public void onClear() {
        this.clearAll();
        HandlerList.unregisterAll((Listener)this);
    }

    private void clearAll() {
        if (this.TNT != null) {
            this.TNT.remove();
        }
        this.TNT = null;
        if (this.arrow != null) {
            this.arrow.remove();
        }
        this.arrow = null;
        this.activated = false;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onItemFrameBreak(HangingBreakEvent e) {
        if (e.getCause() == HangingBreakEvent.RemoveCause.EXPLOSION) {
            if (this.TNT == null) {
                return;
            }
            if (this.TNT.getWorld() == e.getEntity().getWorld()) {
                if (this.TNT.getLocation().distance(e.getEntity().getLocation()) > 15.0) {
                    return;
                }
                e.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onVehicleDestroy(VehicleDestroyEvent e) {
        if (this.TNT == null) {
            return;
        }
        if (this.TNT.getWorld() == e.getVehicle().getWorld()) {
            if (this.TNT.getLocation().distance(e.getVehicle().getLocation()) > 10.0) {
                return;
            }
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEntityExplode(EntityExplodeEvent e) {
        if (this.TNT != null && this.TNT.equals(e.getEntity())) {
            ParticleEffect.EXPLOSION_LARGE.display(e.getEntity().getLocation(), 0.1f);
            ParticleEffect.SMOKE_LARGE.display(e.getEntity().getLocation());
            SoundEffect.ENTITY_GENERIC_EXPLODE.playSound(e.getEntity());
            e.setCancelled(true);
            this.clearAll();
        }
    }
}

