/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.GadgetType;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types.Gadget;
import com.yapzhenyie.GadgetsMenu.utils.BlockUtil;
import com.yapzhenyie.GadgetsMenu.utils.EnumMaterial;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.ReflectionUtils;
import com.yapzhenyie.GadgetsMenu.utils.VersionManager;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class GadgetFireTrail
extends Gadget {
    private boolean activated = false;
    private HashMap<Location, String> blocks = new HashMap();

    public GadgetFireTrail(UUID uuid) {
        super(uuid, GadgetType.FIRE_TRAIL);
    }

    @Override
    protected boolean checkRequirements() {
        if (this.activated) {
            this.getPlayer().sendMessage(MessageType.GADGET_IS_ACTIVATED.getFormatMessage().replace("{GADGET}", this.getType().getDisplayNameStripColor()));
            return false;
        }
        return true;
    }

    @Override
    public void onClick() {
        this.getPlayer().addPotionEffect(new PotionEffect(PotionEffectType.SPEED, 160, 1));
        this.activated = true;
        new BukkitRunnable(){
            int step = 0;

            public void run() {
                ++this.step;
                if (!GadgetFireTrail.this.getPlayer().isOnline() || GadgetsMenu.getPlayerManager(GadgetFireTrail.this.getPlayer()).getCurrentGadget() == null || GadgetsMenu.getPlayerManager(GadgetFireTrail.this.getPlayer()).getCurrentGadget().getType() != GadgetFireTrail.this.getType()) {
                    this.step = 161;
                    GadgetFireTrail.this.onClear();
                    this.cancel();
                    return;
                }
                if (this.step <= 160) {
                    Block block = GadgetFireTrail.this.getPlayer().getLocation().getBlock();
                    Block downBlock = GadgetFireTrail.this.getPlayer().getLocation().add(0.0, -1.0, 0.0).getBlock();
                    if (block.isEmpty() && !downBlock.isEmpty() && !downBlock.isLiquid() && GadgetFireTrail.this.getPlayer().isOnGround()) {
                        GadgetFireTrail.this.setToRestore(GadgetFireTrail.this.getPlayer(), block, EnumMaterial.FIRE, 60);
                    }
                } else {
                    GadgetFireTrail.this.clearAll();
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)GadgetsMenu.getInstance(), 0L, 1L);
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public void onClear() {
        this.clearAll();
        HandlerList.unregisterAll((Listener)this);
    }

    private void clearAll() {
        this.forceRestore();
        this.getPlayer().setFireTicks(0);
        this.activated = false;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onBlockSpread(BlockSpreadEvent e) {
        for (Location loc : this.blocks.keySet()) {
            if (loc.getWorld() != e.getBlock().getWorld()) {
                return;
            }
            if (e.getBlock().getLocation().distance(loc) > 5.0) {
                return;
            }
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBlockFade(BlockFadeEvent e) {
        for (Location loc : this.blocks.keySet()) {
            if (loc.getWorld() != e.getBlock().getWorld()) {
                return;
            }
            if (e.getBlock().getLocation().distance(loc) > 10.0) {
                return;
            }
            if (e.getBlock().getType() != Material.ICE && e.getBlock().getType() != Material.SNOW && e.getBlock().getType() != Material.SNOW_BLOCK) continue;
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBlockBurn(BlockBurnEvent e) {
        for (Location loc : this.blocks.keySet()) {
            if (loc.getWorld() != e.getBlock().getWorld()) {
                return;
            }
            if (e.getBlock().getLocation().distance(loc) > 10.0) {
                return;
            }
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEntityDamage(EntityDamageEvent e) {
        if (this.blocks.isEmpty()) {
            return;
        }
        if (e.getCause() == EntityDamageEvent.DamageCause.FIRE || e.getCause() == EntityDamageEvent.DamageCause.FIRE_TICK) {
            for (Location loc : this.blocks.keySet()) {
                if (loc.getWorld() != e.getEntity().getWorld()) {
                    return;
                }
                if (!(e.getEntity().getLocation().distance(loc) < 3.0)) continue;
                e.getEntity().setFireTicks(0);
                e.setCancelled(true);
            }
        }
    }

    private void setToRestore(final Player player, final Block block, EnumMaterial material, int tickDelay) {
        if (this.blocks.containsKey(block.getLocation())) {
            return;
        }
        if (!(block.getType().toString().toLowerCase().contains("banner") || block.getType() == EnumMaterial.BARRIER.getType() || block.getType().toString().toLowerCase().contains("bed") || block.getType() == EnumMaterial.BREWING_STAND.getType() || block.getType() == EnumMaterial.BROWN_MUSHROOM.getType() || block.getType() == EnumMaterial.CACTUS.getType() || block.getType() == EnumMaterial.CAKE.getType() || block.getType().toString().toLowerCase().contains("cake_block") || block.getType() == EnumMaterial.CARROT.getType() || block.getType() == EnumMaterial.CARROTS.getType() || block.getType().toString().toLowerCase().contains("carpet") || block.getType() == EnumMaterial.COBWEB.getType() || block.getType() == EnumMaterial.COCOA.getType() || block.getType().toString().toLowerCase().contains("crops") || block.getType() == EnumMaterial.DANDELION.getType() || block.getType() == EnumMaterial.DEAD_BUSH.getType() || block.getType().toString().toLowerCase().contains("double_plant") || block.getType() == EnumMaterial.DRAGON_EGG.getType() || block.getType() == EnumMaterial.END_PORTAL.getType() || block.getType() == EnumMaterial.END_PORTAL_FRAME.getType() || block.getType() == EnumMaterial.FARMLAND.getType() || block.getType() == EnumMaterial.FERN.getType() || block.getType() == EnumMaterial.FIRE.getType() || block.getType() == EnumMaterial.FLOWER_POT.getType() || block.getType().toString().toLowerCase().contains("flower_pot") || block.getType() == EnumMaterial.GRASS.getType() || block.getType().toString().toLowerCase().contains("head") || block.getType() == EnumMaterial.LADDER.getType() || block.getType() == EnumMaterial.LARGE_FERN.getType() || block.getType().toString().toLowerCase().endsWith("lava") || block.getType() == EnumMaterial.LEVER.getType() || block.getType() == EnumMaterial.LILY_PAD.getType() || block.getType() == EnumMaterial.LILAC.getType() || block.getType().toString().toLowerCase().contains("long_grass") || block.getType() == EnumMaterial.MELON_STEM.getType() || block.getType() == EnumMaterial.MUSHROOM_STEM.getType() || block.getType() == EnumMaterial.NETHER_PORTAL.getType() || block.getType() == EnumMaterial.NETHER_WART.getType() || block.getType() == EnumMaterial.PEONY.getType() || block.getType().toString().toLowerCase().contains("piston_") || block.getType() == EnumMaterial.POTATO.getType() || block.getType() == EnumMaterial.POTATOES.getType() || block.getType().toString().toLowerCase().contains("potted_") || block.getType() == EnumMaterial.PUMPKIN_STEM.getType() || block.getType() == EnumMaterial.RED_MUSHROOM.getType() || block.getType().toString().toLowerCase().contains("redstone_lamp") || block.getType().toString().toLowerCase().contains("redstone_torch") || block.getType().toString().toLowerCase().contains("red_rose") || block.getType() == EnumMaterial.REDSTONE_WIRE.getType() || block.getType() == EnumMaterial.ROSE_BUSH.getType() || block.getType().toString().toLowerCase().contains("sapling") || block.getType().toString().toLowerCase().contains("seeds") || block.getType().toString().toLowerCase().contains("sign") || block.getType().toString().toLowerCase().contains("skull") || block.getType() == EnumMaterial.SNOW.getType() || block.getType() == EnumMaterial.SPAWNER.getType() || block.getType() == EnumMaterial.SUGAR_CANE.getType() || block.getType().toString().toLowerCase().contains("sugar_cane_block") || block.getType() == EnumMaterial.SUNFLOWER.getType() || block.getType() == EnumMaterial.TALL_GRASS.getType() || block.getType() == EnumMaterial.TORCH.getType() || block.getType() == EnumMaterial.TRIPWIRE.getType() || block.getType() == EnumMaterial.TRIPWIRE_HOOK.getType() || block.getType().toString().toLowerCase().contains("tulip") || block.getType() == EnumMaterial.VINE.getType() || block.getType().toString().toLowerCase().endsWith("water") || block.getType() == EnumMaterial.WHEAT.getType() || block.getType().toString().toLowerCase().contains("_button") || block.getType().toString().toLowerCase().contains("_plate") || BlockUtil.isPortalBlock(block) || BlockUtil.isCocoaBlock(block) || BlockUtil.isChorusPlant(block) || block.hasMetadata(GadgetsMenu.getInstance().getPluginName()) || this.blocks.containsKey(block.getLocation()))) {
            if (VersionManager.is1_13OrAbove()) {
                try {
                    this.blocks.put(block.getLocation(), block.getBlockData().getAsString());
                }
                catch (NoSuchMethodError noSuchMethodError) {}
            } else {
                try {
                    this.blocks.put(block.getLocation(), block.getType().toString() + "," + block.getData());
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
            }
            block.setType(material.getType());
            block.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
            Bukkit.getScheduler().runTaskLater((Plugin)GadgetsMenu.getInstance(), new Runnable(){

                @Override
                public void run() {
                    GadgetFireTrail.this.restoreBlock(player, block.getLocation());
                }
            }, (long)tickDelay);
        }
    }

    private void forceRestore() {
        if (this.blocks.isEmpty()) {
            return;
        }
        for (Location loc : this.blocks.keySet()) {
            Block b = loc.getBlock();
            if (VersionManager.is1_13OrAbove()) {
                try {
                    BlockData blockData = Bukkit.getServer().createBlockData(this.blocks.get(loc));
                    b.setBlockData(blockData);
                }
                catch (Exception blockData) {}
            } else {
                String s = this.blocks.get(loc);
                Material m = Material.valueOf((String)s.split(",")[0]);
                byte d = Byte.valueOf(s.split(",")[1]);
                b.setType(m);
                ReflectionUtils.setData(b, d);
            }
            b.removeMetadata(GadgetsMenu.getInstance().getPluginName(), (Plugin)GadgetsMenu.getInstance());
        }
        this.blocks.clear();
    }

    private void restoreBlock(Player player, Location location) {
        if (!this.blocks.containsKey(location)) {
            return;
        }
        Block b = location.getBlock();
        if (VersionManager.is1_13OrAbove()) {
            try {
                BlockData blockData = Bukkit.getServer().createBlockData(this.blocks.get(location));
                b.setBlockData(blockData);
            }
            catch (Exception blockData) {}
        } else {
            String s = this.blocks.get(location);
            Material m = Material.valueOf((String)s.split(",")[0]);
            byte d = Byte.valueOf(s.split(",")[1]);
            b.setType(m);
            ReflectionUtils.setData(b, d);
        }
        b.removeMetadata(GadgetsMenu.getInstance().getPluginName(), (Plugin)GadgetsMenu.getInstance());
        this.blocks.remove(location);
    }
}

