/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.configuration.FileManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.GadgetType;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types.Gadget;
import com.yapzhenyie.GadgetsMenu.nms.interfaces.ArmorStandSlot;
import com.yapzhenyie.GadgetsMenu.nms.interfaces.entity.NMSArmorStand;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.EnumMaterial;
import com.yapzhenyie.GadgetsMenu.utils.PlayerUtils;
import com.yapzhenyie.GadgetsMenu.utils.VersionManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class GadgetFlowerGiver
extends Gadget {
    public static ArrayList<Player> pendingPlayers = new ArrayList();
    public static HashMap<Player, NMSArmorStand> acceptedFlowerPlayers = new HashMap();
    public static ArrayList<Player> declinedFlowerPlayers = new ArrayList();
    private ArrayList<Player> privateTargetPlayers = new ArrayList();
    private Player targetPlayer = null;
    private static String targetAPlayerMessage = FileManager.getGadgetsFile().getString("Gadgets.Fun And Games.Types.Flower Giver.Messages.Target-A-Player");
    private static String alreadyHadAFlowerMessage = FileManager.getGadgetsFile().getString("Gadgets.Fun And Games.Types.Flower Giver.Messages.Already-Had-A-Flower");
    private static String sentAFlowerMessage = FileManager.getGadgetsFile().getString("Gadgets.Fun And Games.Types.Flower Giver.Messages.Sent-A-Flower");
    private static String alreadySentARequestMessage = FileManager.getGadgetsFile().getString("Gadgets.Fun And Games.Types.Flower Giver.Messages.Already-Sent-A-Request");
    private static String receivedFlowerMessage = FileManager.getGadgetsFile().getString("Gadgets.Fun And Games.Types.Flower Giver.Messages.Received-Flower");
    private static String acceptMessage = FileManager.getGadgetsFile().getString("Gadgets.Fun And Games.Types.Flower Giver.Messages.Accept");
    private static String declineMessage = FileManager.getGadgetsFile().getString("Gadgets.Fun And Games.Types.Flower Giver.Messages.Decline");
    private static String acceptJsonMessage = FileManager.getGadgetsFile().getString("Gadgets.Fun And Games.Types.Flower Giver.Messages.Accept-Json-message");
    private static String declineJsonMessage = FileManager.getGadgetsFile().getString("Gadgets.Fun And Games.Types.Flower Giver.Messages.Decline-Json-message");
    public static String noPendingInviteMessage = FileManager.getGadgetsFile().getString("Gadgets.Fun And Games.Types.Flower Giver.Messages.No-Pending-Invite");
    private static String acceptedFlowerMessage = FileManager.getGadgetsFile().getString("Gadgets.Fun And Games.Types.Flower Giver.Messages.Accepted-Flower");
    private static String declinedFlowerMessage = FileManager.getGadgetsFile().getString("Gadgets.Fun And Games.Types.Flower Giver.Messages.Declined-Flower");
    private static String rightClickToRemoveFlowerMessage = FileManager.getGadgetsFile().getString("Gadgets.Fun And Games.Types.Flower Giver.Messages.Right-Click-To-Remove-Flower");
    private static ItemStack[] flowers = new ItemStack[]{new ItemStack(EnumMaterial.DANDELION.getType()), new ItemStack(EnumMaterial.POPPY.getType(), 0), new ItemStack(EnumMaterial.BLUE_ORCHID.getType(), 1), new ItemStack(EnumMaterial.ALLIUM.getType(), 2), new ItemStack(EnumMaterial.AZURE_BLUET.getType(), 3), new ItemStack(EnumMaterial.RED_TULIP.getType(), 4), new ItemStack(EnumMaterial.ORANGE_TULIP.getType(), 5), new ItemStack(EnumMaterial.WHITE_TULIP.getType(), 6), new ItemStack(EnumMaterial.PINK_TULIP.getType(), 7), new ItemStack(EnumMaterial.OXEYE_DAISY.getType(), 8)};

    public GadgetFlowerGiver(UUID uuid) {
        super(uuid, GadgetType.FLOWER_GIVER);
    }

    @Override
    protected boolean checkRequirements() {
        Entity target = PlayerUtils.getEntityPlayerLookingAt(this.getPlayer(), 10);
        if (target == null) {
            this.getPlayer().sendMessage(ChatUtil.format(targetAPlayerMessage));
            return false;
        }
        if (!(target instanceof Player)) {
            this.getPlayer().sendMessage(ChatUtil.format(targetAPlayerMessage));
            return false;
        }
        if (!this.getPlayer().canSee((Player)target)) {
            this.getPlayer().sendMessage(ChatUtil.format(targetAPlayerMessage));
            return false;
        }
        if (this.targetPlayer != null && target == this.targetPlayer) {
            this.getPlayer().sendMessage(ChatUtil.format(alreadySentARequestMessage).replace("{PLAYER}", this.targetPlayer.getName()));
            return false;
        }
        if (acceptedFlowerPlayers.containsKey(target)) {
            this.getPlayer().sendMessage(ChatUtil.format(alreadyHadAFlowerMessage));
            return false;
        }
        if (pendingPlayers.contains(target)) {
            this.getPlayer().sendMessage(ChatUtil.format(alreadyHadAFlowerMessage));
            return false;
        }
        this.targetPlayer = (Player)target;
        return true;
    }

    @Override
    public void onClick() {
        if (this.targetPlayer != null && this.targetPlayer.isOnline()) {
            this.getPlayer().sendMessage(ChatUtil.format(sentAFlowerMessage).replace("{PLAYER}", this.targetPlayer.getName()));
            this.targetPlayer.sendMessage(ChatUtil.format(receivedFlowerMessage).replace("{PLAYER}", this.getPlayer().getName()));
            GadgetsMenu.getNMSManager().newJSONMessage(ChatUtil.format(acceptMessage)).showText(ChatUtil.format(acceptJsonMessage)).runCommand("/flowergiver accept {PLAYER}".replace("{PLAYER}", this.getPlayer().getName())).then(" ").then(ChatUtil.format(declineMessage)).showText(ChatUtil.format(declineJsonMessage)).runCommand("/flowergiver decline {PLAYER}".replace("{PLAYER}", this.getPlayer().getName())).send(this.targetPlayer);
            if (!pendingPlayers.contains(this.targetPlayer)) {
                pendingPlayers.add(this.targetPlayer);
            }
            if (!this.privateTargetPlayers.contains(this.targetPlayer)) {
                this.privateTargetPlayers.add(this.targetPlayer);
            }
        } else {
            this.getPlayer().sendMessage(ChatUtil.format(targetAPlayerMessage));
            return;
        }
    }

    @Override
    public void onUpdate() {
        for (Player player : this.privateTargetPlayers) {
            if (!declinedFlowerPlayers.contains(player)) continue;
            if (pendingPlayers.contains(player)) {
                pendingPlayers.remove(player);
            }
            if (this.targetPlayer == player) {
                this.targetPlayer = null;
            }
            declinedFlowerPlayers.remove(player);
            this.privateTargetPlayers.remove(player);
            break;
        }
    }

    @Override
    public void onClear() {
        this.clearAll();
        HandlerList.unregisterAll((Listener)this);
    }

    private void clearAll() {
        for (Player player : this.privateTargetPlayers) {
            if (pendingPlayers.contains(player)) {
                pendingPlayers.remove(player);
            }
            if (acceptedFlowerPlayers.containsKey(player)) {
                Bukkit.getScheduler().runTask((Plugin)GadgetsMenu.getInstance(), () -> {
                    NMSArmorStand as = acceptedFlowerPlayers.get(player);
                    if (!as.isDeadNMS()) {
                        as.killEntityNMS();
                    }
                    acceptedFlowerPlayers.remove(player);
                });
            }
            if (!declinedFlowerPlayers.contains(player)) continue;
            declinedFlowerPlayers.remove(player);
        }
        this.privateTargetPlayers.clear();
        this.targetPlayer = null;
    }

    public static void removeFlower(Player player) {
        if (player == null) {
            return;
        }
        if (pendingPlayers.contains(player)) {
            pendingPlayers.remove(player);
        }
        Bukkit.getScheduler().runTask((Plugin)GadgetsMenu.getInstance(), () -> {
            if (acceptedFlowerPlayers.containsKey(player)) {
                NMSArmorStand as = acceptedFlowerPlayers.get(player);
                if (!as.isDeadNMS()) {
                    as.killEntityNMS();
                }
                acceptedFlowerPlayers.remove(player);
            }
        });
    }

    @EventHandler
    public void onPlayerExecuteFlowerGiverCommand(PlayerCommandPreprocessEvent event) {
        Player player = event.getPlayer();
        if (player == this.targetPlayer && pendingPlayers.contains(player) && event.getMessage().startsWith("/flowergiver")) {
            Player sender;
            if (event.getMessage().contains("accept")) {
                Player sender2 = Bukkit.getPlayer((String)event.getMessage().replace("/flowergiver accept ", ""));
                if (sender2 != null && sender2.isOnline()) {
                    sender2.sendMessage(ChatUtil.format(acceptedFlowerMessage).replace("{PLAYER}", player.getName()));
                    player.sendMessage(ChatUtil.format(rightClickToRemoveFlowerMessage));
                    Location loc = player.getLocation();
                    double y = VersionManager.is1_9OrAbove() ? (VersionManager.is1_11OrAbove() ? 1.8 : 1.73) : 2.0;
                    NMSArmorStand as = GadgetsMenu.getNMSManager().spawnNMSArmorStandFollower(loc.getWorld(), loc.getX(), loc.getY() + y, loc.getZ(), player, y, null, ArmorStandSlot.HEAD, flowers[GadgetsMenu.random().nextInt(flowers.length)]);
                    if (!acceptedFlowerPlayers.containsKey(player)) {
                        acceptedFlowerPlayers.put(player, as);
                    }
                }
            } else if (event.getMessage().contains("decline") && (sender = Bukkit.getPlayer((String)event.getMessage().replace("/flowergiver decline ", ""))) != null && sender.isOnline()) {
                sender.sendMessage(ChatUtil.format(declinedFlowerMessage).replace("{PLAYER}", player.getName()));
                if (!declinedFlowerPlayers.contains(player)) {
                    declinedFlowerPlayers.add(player);
                }
            }
            pendingPlayers.remove(player);
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onPlayerClick(PlayerInteractEvent e) {
        if (acceptedFlowerPlayers.isEmpty()) {
            return;
        }
        if ((e.getAction() == Action.RIGHT_CLICK_AIR || e.getAction() == Action.RIGHT_CLICK_BLOCK) && acceptedFlowerPlayers.containsKey(e.getPlayer())) {
            if (e.getPlayer().getItemInHand().getType() != Material.AIR) {
                return;
            }
            GadgetFlowerGiver.removeFlower(e.getPlayer());
            if (this.targetPlayer == e.getPlayer()) {
                this.targetPlayer = null;
            }
            e.setCancelled(true);
        }
    }
}

