/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.configuration.FileManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.GadgetType;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types.Gadget;
import com.yapzhenyie.GadgetsMenu.utils.BlockUtil;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.CuboID;
import com.yapzhenyie.GadgetsMenu.utils.EnumMaterial;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.ReflectionUtils;
import com.yapzhenyie.GadgetsMenu.utils.VersionManager;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.bukkit.Axis;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.Openable;
import org.bukkit.block.data.Orientable;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class GadgetIceCreamStand
extends Gadget {
    private boolean activated = false;
    private HashMap<Location, String> blocks = new HashMap();
    private Location centerLocation;
    private ArrayList<ArmorStand> armorstands = new ArrayList();
    private static String[] textures = new String[]{"95366ca17974892e4fd4c7b9b18feb11f05ba2ec47aa5035c81a9533b28", "06be02de9f61a2cc7c52a73cfadc810b5e4555a2e876d569a54691a226c3b", "3b77d9ec42ce6dc394145025d8baedf4ff9582026b36adf74c4c6ad9cc390", "32c1c0209b10e1b997b461287f9d426e316a4a6672278d4e463b19925fff26", "1149cb7f616a7b59845f4a27b955635bb1bb2b66fb6d9f3f331557e6f52fb7", "ab671c0206e2aead0a5e9b545f707966ca15563f17e019db16ab59d563d", "a6bc364673c34dc34a9578292f30aa9f2d4b9468115b86129e76786cff8299d", "7a19e875a0853fec2d36e8328ec6f664624ae991ffdd932f53489e3d314e", "c59f4b4f1a8bf4f4ad6874f930ac7d7e93e99061f879ab80428f52e757a29"};
    private static List<String> messages = FileManager.getGadgetsFile().getStringList("Gadgets.Fun And Games.Types.Ice Cream Stand.Messages");

    public GadgetIceCreamStand(UUID uuid) {
        super(uuid, GadgetType.ICE_CREAM_STAND);
    }

    @Override
    protected boolean checkRequirements() {
        Location loc2;
        if (this.activated) {
            this.getPlayer().sendMessage(MessageType.GADGET_IS_ACTIVATED.getFormatMessage().replace("{GADGET}", this.getType().getDisplayNameStripColor()));
            return false;
        }
        if (!this.getPlayer().isOnGround()) {
            this.getPlayer().sendMessage(MessageType.NOT_ON_GROUND.getFormatMessage());
            return false;
        }
        Location loc1 = this.getPlayer().getLocation().clone().add(1.0, 0.0, -1.0);
        CuboID cuboid = new CuboID(loc1, loc2 = this.getPlayer().getLocation().clone().add(3.0, 4.0, 1.0));
        if (!cuboid.isEmpty()) {
            this.getPlayer().sendMessage(MessageType.NOT_ENOUGH_SPACE.getFormatMessage());
            return false;
        }
        return true;
    }

    @Override
    public void onClick() {
        this.centerLocation = this.getPlayer().getLocation().getBlock().getLocation().add(0.5, 0.0, 0.5).clone();
        this.setBlock(this.getLocation(3, 0, 0), EnumMaterial.OAK_FENCE_GATE, true, (byte)5);
        this.setBlock(this.getLocation(1, 0, 0), EnumMaterial.QUARTZ_PILLAR, true, (byte)4);
        this.setBlock(this.getLocation(2, 0, 0), EnumMaterial.QUARTZ_PILLAR, true, (byte)4);
        this.setBlock(this.getLocation(1, 0, -1), EnumMaterial.OAK_TRAPDOOR, true, (byte)4);
        this.setBlock(this.getLocation(2, 0, -1), EnumMaterial.OAK_TRAPDOOR, true, (byte)4);
        this.setBlock(this.getLocation(1, 0, 1), EnumMaterial.OAK_TRAPDOOR, true, (byte)5);
        this.setBlock(this.getLocation(2, 0, 1), EnumMaterial.OAK_TRAPDOOR, true, (byte)5);
        this.setBlock(this.getLocation(1, 1, 0), EnumMaterial.OAK_FENCE, false, (byte)0);
        this.setBlock(this.getLocation(1, 2, 0), EnumMaterial.OAK_FENCE, false, (byte)0);
        this.setBlock(this.getLocation(1, 3, 0), EnumMaterial.OAK_SLAB, false, (byte)0);
        for (int i = -1; i <= 1; i += 2) {
            this.setBlock(this.getLocation(1 + i, 3, -1), EnumMaterial.OAK_SLAB, false, (byte)0);
            this.setBlock(this.getLocation(1 + i, 3, 1), EnumMaterial.OAK_SLAB, false, (byte)0);
        }
        this.setBlock(this.getLocation(0, 3, 0), EnumMaterial.DARK_OAK_SLAB, false, (byte)5);
        this.setBlock(this.getLocation(2, 3, 0), EnumMaterial.DARK_OAK_SLAB, false, (byte)5);
        this.setBlock(this.getLocation(1, 3, -1), EnumMaterial.DARK_OAK_SLAB, false, (byte)5);
        this.setBlock(this.getLocation(1, 3, 1), EnumMaterial.DARK_OAK_SLAB, false, (byte)5);
        for (int x = 1; x <= 2; ++x) {
            for (int z = -1; z <= 1; z += 2) {
                ArmorStand as = (ArmorStand)this.getPlayer().getWorld().spawnEntity(this.centerLocation.clone().add((double)x, -0.7, (double)z), EntityType.ARMOR_STAND);
                as.setVisible(false);
                as.setGravity(false);
                as.setSmall(true);
                as.setArms(false);
                as.setBasePlate(false);
                try {
                    if (VersionManager.is1_9OrAbove()) {
                        as.setSilent(true);
                    }
                    as.setMarker(false);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
                as.setHelmet(this.getRandomIceCream(textures[GadgetsMenu.random().nextInt(textures.length)]));
                as.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
                as.setMetadata("GadgetsMenu-IceCream", (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
                this.armorstands.add(as);
            }
        }
        ArmorStand as = (ArmorStand)this.getPlayer().getWorld().spawnEntity(this.centerLocation.clone().add(2.0, 0.3, 0.0), EntityType.ARMOR_STAND);
        as.setVisible(false);
        as.setGravity(false);
        as.setSmall(true);
        as.setArms(false);
        as.setBasePlate(false);
        try {
            if (VersionManager.is1_9OrAbove()) {
                as.setSilent(true);
            }
            as.setMarker(false);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        as.setHelmet(this.getRandomIceCream("239299c36b54bb11e57c686bfe53a5c1c441310f90f69347bacddbf343609d"));
        as.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
        as.setMetadata("GadgetsMenu-IceCreamStand", (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
        this.armorstands.add(as);
        Bukkit.getScheduler().runTaskLater((Plugin)GadgetsMenu.getInstance(), () -> {
            if (!this.getPlayer().isOnline() || GadgetsMenu.getPlayerManager(this.getPlayer()).getCurrentGadget() == null || GadgetsMenu.getPlayerManager(this.getPlayer()).getCurrentGadget().getType() != this.getType() || !this.activated) {
                return;
            }
            this.clearAll();
        }, 400L);
        this.activated = true;
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public void onClear() {
        this.clearAll();
        HandlerList.unregisterAll((Listener)this);
    }

    private void clearAll() {
        if (this.activated && this.centerLocation != null) {
            this.getLocation(1, 0, -1).setType(Material.AIR);
            this.getLocation(2, 0, -1).setType(Material.AIR);
            this.getLocation(1, 0, 1).setType(Material.AIR);
            this.getLocation(2, 0, 1).setType(Material.AIR);
        }
        for (Location location : this.blocks.keySet()) {
            Block b = location.clone().getBlock();
            b.setType(Material.AIR);
            b.removeMetadata(GadgetsMenu.getInstance().getPluginName(), (Plugin)GadgetsMenu.getInstance());
        }
        this.blocks.clear();
        this.centerLocation = null;
        for (ArmorStand as : this.armorstands) {
            if (!as.isValid()) continue;
            as.remove();
        }
        this.armorstands.clear();
        this.activated = false;
    }

    private ItemStack getRandomIceCream(String url) {
        ItemStack head = new ItemStack(EnumMaterial.PLAYER_HEAD.getType(), 1, (short)EnumMaterial.PLAYER_HEAD.getData());
        SkullMeta skullMeta = (SkullMeta)head.getItemMeta();
        GameProfile profile = new GameProfile(UUID.randomUUID(), null);
        byte[] encodedData = Base64.getEncoder().encode(String.format("{textures:{SKIN:{url:\"%s\"}}}", "http://textures.minecraft.net/texture/" + url).getBytes());
        profile.getProperties().put((Object)"textures", (Object)new Property("textures", new String(encodedData)));
        try {
            Field profileField = skullMeta.getClass().getDeclaredField("profile");
            profileField.setAccessible(true);
            profileField.set(skullMeta, profile);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException e1) {
            e1.printStackTrace();
        }
        head.setItemMeta((ItemMeta)skullMeta);
        return head;
    }

    private void setBlock(Block block, EnumMaterial material, boolean changeFacing, byte facing) {
        if (!this.blocks.containsKey(block.getLocation())) {
            if (VersionManager.is1_13OrAbove()) {
                try {
                    this.blocks.put(block.getLocation(), block.getBlockData().getAsString());
                }
                catch (NoSuchMethodError noSuchMethodError) {}
            } else {
                try {
                    this.blocks.put(block.getLocation(), block.getType().toString() + "," + block.getData());
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
            }
            block.setType(material.getType());
            if (VersionManager.is1_13OrAbove()) {
                if (changeFacing) {
                    BlockData blockData = block.getBlockData();
                    if (material != EnumMaterial.QUARTZ_PILLAR) {
                        ((Directional)blockData).setFacing(BlockUtil.getBlockFace(material == EnumMaterial.OAK_TRAPDOOR && facing == 5 ? facing - 3 : facing - 1));
                        if (blockData instanceof Openable) {
                            Openable orientable = (Openable)blockData;
                            orientable.setOpen(true);
                        }
                    } else if (blockData instanceof Orientable) {
                        Orientable orientable = (Orientable)blockData;
                        orientable.setAxis(Axis.X);
                    }
                    block.setBlockData(blockData);
                }
            } else {
                ReflectionUtils.setData(block, changeFacing ? facing : material.getData());
            }
            block.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
        }
    }

    private Block getLocation(int x, int y, int z) {
        return this.centerLocation.getBlock().getRelative(x, y, z);
    }

    @EventHandler
    public void onPlayerInteractEntity(PlayerInteractAtEntityEvent event) {
        if (event.getPlayer() == this.getPlayer() && event.getRightClicked().hasMetadata(GadgetsMenu.getInstance().getPluginName())) {
            if (event.getRightClicked().hasMetadata("GadgetsMenu-IceCreamStand")) {
                if (event.getRightClicked().isValid()) {
                    event.getRightClicked().remove();
                }
                event.setCancelled(true);
                return;
            }
            if (event.getRightClicked().hasMetadata("GadgetsMenu-IceCream")) {
                event.getPlayer().sendMessage(ChatUtil.format(messages.get(GadgetsMenu.random().nextInt(messages.size()))));
                event.setCancelled(true);
                return;
            }
        }
    }
}

