/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.configuration.FileManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.GadgetType;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types.Gadget;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.EnumItem;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.StringUtils;
import com.yapzhenyie.GadgetsMenu.utils.VersionManager;
import com.yapzhenyie.GadgetsMenu.utils.cosmetics.gadgets.JukeboxTrack;
import com.yapzhenyie.GadgetsMenu.utils.items.InventoryUtils;
import com.yapzhenyie.GadgetsMenu.utils.items.ItemUtils;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Effect;
import org.bukkit.SoundCategory;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class GadgetJukebox
extends Gadget {
    private static String JukeboxGUIName = FileManager.getGadgetsFile().getString("Gadgets.Musical.Types.Jukebox.Items.GUI-Name");
    private JukeboxTrack track = null;

    public GadgetJukebox(UUID uuid) {
        super(uuid, GadgetType.JUKEBOX);
        this.addCooldownAfterClick = false;
    }

    @Override
    void onClick() {
        this.openJukeboxMenu(this.getPlayer());
    }

    @Override
    void onUpdate() {
    }

    @Override
    public void onClear() {
        this.clearAll();
        HandlerList.unregisterAll((Listener)this);
    }

    private void clearAll() {
        if (this.track != null) {
            if (VersionManager.is1_13OrAbove()) {
                try {
                    this.getPlayer().stopSound(this.track.getSoundTrack(), SoundCategory.RECORDS);
                }
                catch (NoSuchMethodError noSuchMethodError) {}
            } else if (VersionManager.is1_9OrAbove()) {
                try {
                    this.getPlayer().stopSound(this.track.getSoundTrack());
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
            }
        }
        this.track = null;
    }

    private void openJukeboxMenu(Player player) {
        Inventory invJukebox = Bukkit.createInventory(null, (int)36, (String)ChatUtil.format(JukeboxGUIName));
        if (VersionManager.is1_9OrAbove()) {
            for (JukeboxTrack disc : JukeboxTrack.values()) {
                InventoryUtils.inventory(invJukebox, StringUtils.addPlaceholder(EnumItem.JUKEBOX_TRACK.getDisplayName(), "{TRACK}", disc.getDisplayName()), disc.getMaterial(), EnumItem.JUKEBOX_TRACK.getLore(), disc.getSlot());
            }
        }
        InventoryUtils.inventory(invJukebox, EnumItem.JUKEBOX_STOP_TRACK.getItemStack(), EnumItem.JUKEBOX_STOP_TRACK.getSlot());
        InventoryUtils.fillItems(invJukebox);
        player.openInventory(invJukebox);
    }

    @EventHandler
    public void onInvClickDisc(InventoryClickEvent e) {
        final Player player = (Player)e.getWhoClicked();
        if (player == this.getPlayer() && GadgetsMenu.getPlayerManager(this.getPlayer()).getCurrentGadget() != null && GadgetsMenu.getPlayerManager(this.getPlayer()).getCurrentGadget().getType() == this.getType() && e.getView().getTitle().equals(ChatUtil.format(JukeboxGUIName))) {
            if (e.getClickedInventory() == null || e.getClickedInventory().getSize() != 36 || e.getClickedInventory().getType() != InventoryType.CHEST) {
                e.setCancelled(true);
                return;
            }
            if (e.getCurrentItem() == null || e.getCurrentItem().getItemMeta() == null || e.getCurrentItem().getItemMeta().getDisplayName() == null) {
                e.setCancelled(true);
                return;
            }
            if (e.getClick() == ClickType.SHIFT_LEFT || e.getClick() == ClickType.SHIFT_RIGHT || e.getClick() == ClickType.NUMBER_KEY || e.getClick() == ClickType.UNKNOWN) {
                e.setCancelled(true);
                player.updateInventory();
                return;
            }
            if (ItemUtils.getCurrentItem(e, EnumItem.JUKEBOX_STOP_TRACK.getItemStack(), EnumItem.JUKEBOX_STOP_TRACK.getSlot())) {
                this.clearAll();
                player.closeInventory();
                e.setCancelled(true);
                return;
            }
            if (VersionManager.is1_9OrAbove()) {
                for (final JukeboxTrack disc : JukeboxTrack.values()) {
                    if (!ItemUtils.getCurrentItem(e, StringUtils.addPlaceholder(EnumItem.JUKEBOX_TRACK.getDisplayName(), "{TRACK}", disc.getDisplayName()), disc.getMaterial())) continue;
                    this.clearAll();
                    this.getPlayer().playEffect(this.getPlayer().getLocation(), Effect.RECORD_PLAY, (Object)disc.getMaterial().getEnumMaterial().getType());
                    super.addCooldownTimer();
                    BukkitRunnable runnable = new BukkitRunnable(){
                        int times = 0;

                        public void run() {
                            if (!GadgetJukebox.this.getPlayer().isOnline() || GadgetsMenu.getPlayerManager(GadgetJukebox.this.getPlayer()).getCurrentGadget() == null || GadgetsMenu.getPlayerManager(GadgetJukebox.this.getPlayer()).getCurrentGadget().getType() != GadgetJukebox.this.getType()) {
                                GadgetJukebox.this.showCooldownBar = true;
                                this.cancel();
                                return;
                            }
                            if (this.times > 5) {
                                GadgetJukebox.this.showCooldownBar = true;
                                this.cancel();
                                return;
                            }
                            GadgetJukebox.this.showCooldownBar = false;
                            GadgetsMenu.getPlayerManager(player).sendActionMessage(MessageType.PLAYING_SONG.getFormatMessage().replace("{RANDOM_COLOR}", ChatUtil.getRandomColor()).replace("{SONG}", disc.getDisplayName()));
                            ++this.times;
                        }
                    };
                    runnable.runTaskTimer((Plugin)GadgetsMenu.getInstance(), 0L, 10L);
                    this.track = disc;
                    player.closeInventory();
                    e.setCancelled(true);
                    return;
                }
            }
            player.closeInventory();
            e.setCancelled(true);
            return;
        }
    }
}

