/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.GadgetType;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types.Gadget;
import com.yapzhenyie.GadgetsMenu.utils.BlockUtil;
import com.yapzhenyie.GadgetsMenu.utils.EnumMaterial;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.ParticleEffect;
import com.yapzhenyie.GadgetsMenu.utils.ReflectionUtils;
import com.yapzhenyie.GadgetsMenu.utils.SoundEffect;
import com.yapzhenyie.GadgetsMenu.utils.VersionManager;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class GadgetLetItSnow
extends Gadget {
    private boolean activated = false;
    private HashMap<Location, String> blocks = new HashMap();

    public GadgetLetItSnow(UUID uuid) {
        super(uuid, GadgetType.LET_IT_SNOW);
    }

    @Override
    protected boolean checkRequirements() {
        if (this.activated) {
            this.getPlayer().sendMessage(MessageType.GADGET_IS_ACTIVATED.getFormatMessage().replace("{GADGET}", this.getType().getDisplayNameStripColor()));
            return false;
        }
        return true;
    }

    @Override
    public void onClick() {
        SoundEffect.ENTITY_ZOMBIE_VILLAGER_CURE.playSound(this.getPlayer());
        this.activated = true;
        new BukkitRunnable(){
            int step = 0;
            int step2 = 25;

            public void run() {
                ++this.step;
                ++this.step2;
                if (!GadgetLetItSnow.this.getPlayer().isOnline() || GadgetsMenu.getPlayerManager(GadgetLetItSnow.this.getPlayer()).getCurrentGadget() == null || GadgetsMenu.getPlayerManager(GadgetLetItSnow.this.getPlayer()).getCurrentGadget().getType() != GadgetLetItSnow.this.getType()) {
                    this.step = 200;
                    GadgetLetItSnow.this.onClear();
                    this.cancel();
                    return;
                }
                if (this.step <= 200) {
                    Location snow = GadgetLetItSnow.this.getPlayer().getLocation().clone().add(0.0, 3.0, 0.0);
                    ParticleEffect.SNOW_SHOVEL.display(snow, 2.5f, 2.5f, 2.5f, 10);
                    if (this.step2 == 30) {
                        SoundEffect.WEATHER_RAIN_ABOVE.playSound(GadgetLetItSnow.this.getPlayer());
                        this.step2 = 0;
                    }
                    for (Block block : BlockUtil.getBlocksInRadiusXZ(GadgetLetItSnow.this.getPlayer().getLocation(), 3, false)) {
                        if (!block.isLiquid() || VersionManager.is1_13OrAbove() && !block.getBlockData().getAsString().contains("level=0")) continue;
                        EnumMaterial material = EnumMaterial.ICE;
                        if (block.getType() == Material.LAVA || block.getType().toString().toLowerCase().contains("_LAVA")) {
                            material = EnumMaterial.OBSIDIAN;
                        }
                        GadgetLetItSnow.this.setToRestore(GadgetLetItSnow.this.getPlayer(), block, material, 80);
                    }
                } else {
                    GadgetLetItSnow.this.clearAll();
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)GadgetsMenu.getInstance(), 0L, 1L);
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public void onClear() {
        this.clearAll();
        HandlerList.unregisterAll((Listener)this);
    }

    private void clearAll() {
        this.forceRestore();
        this.activated = false;
    }

    private void forceRestore() {
        if (this.blocks.isEmpty()) {
            return;
        }
        for (Location loc : this.blocks.keySet()) {
            Block b = loc.getBlock();
            if (VersionManager.is1_13OrAbove()) {
                try {
                    BlockData blockData = Bukkit.getServer().createBlockData(this.blocks.get(loc));
                    b.setBlockData(blockData);
                }
                catch (Exception blockData) {}
            } else {
                String s = this.blocks.get(loc);
                Material m = Material.valueOf((String)s.split(",")[0]);
                byte d = Byte.valueOf(s.split(",")[1]);
                b.setType(m);
                ReflectionUtils.setData(b, d);
            }
            b.removeMetadata(GadgetsMenu.getInstance().getPluginName(), (Plugin)GadgetsMenu.getInstance());
        }
        this.blocks.clear();
    }

    private void restoreBlock(Player player, Location location) {
        if (!this.blocks.containsKey(location)) {
            return;
        }
        Block b = location.getBlock();
        if (VersionManager.is1_13OrAbove()) {
            try {
                BlockData blockData = Bukkit.getServer().createBlockData(this.blocks.get(location));
                b.setBlockData(blockData);
            }
            catch (Exception blockData) {}
        } else {
            String s = this.blocks.get(location);
            Material m = Material.valueOf((String)s.split(",")[0]);
            byte d = Byte.valueOf(s.split(",")[1]);
            b.setType(m);
            ReflectionUtils.setData(b, d);
        }
        b.removeMetadata(GadgetsMenu.getInstance().getPluginName(), (Plugin)GadgetsMenu.getInstance());
        this.blocks.remove(location);
    }

    private void setToRestore(final Player player, final Block block, EnumMaterial material, int tickDelay) {
        if (this.blocks.containsKey(block.getLocation())) {
            return;
        }
        if (block.isLiquid() && !this.blocks.containsKey(block.getLocation()) && !block.hasMetadata(GadgetsMenu.getInstance().getPluginName())) {
            if (VersionManager.is1_13OrAbove()) {
                try {
                    this.blocks.put(block.getLocation(), block.getBlockData().getAsString());
                }
                catch (NoSuchMethodError noSuchMethodError) {}
            } else {
                try {
                    this.blocks.put(block.getLocation(), block.getType().toString() + "," + block.getData());
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
            }
            block.setType(material.getType());
            block.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
            ParticleEffect.BLOCK_CRACK.display(new ParticleEffect.BlockData(material, 0), block.getLocation().clone().add(0.0, 0.8, 0.0), 0.15f, 0.15f, 0.15f, 1.0f, 3);
            ParticleEffect.SNOWBALL.display(block.getLocation(), 0.7f, 0.7f, 0.7f, 1.0f, 10);
            Bukkit.getScheduler().runTaskLater((Plugin)GadgetsMenu.getInstance(), new Runnable(){

                @Override
                public void run() {
                    GadgetLetItSnow.this.restoreBlock(player, block.getLocation());
                }
            }, (long)tickDelay);
        }
    }
}

