/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.GadgetType;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types.Gadget;
import com.yapzhenyie.GadgetsMenu.utils.EnumMaterial;
import com.yapzhenyie.GadgetsMenu.utils.MathUtil;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.ParticleEffect;
import com.yapzhenyie.GadgetsMenu.utils.SoundEffect;
import java.util.ArrayList;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityUnleashEvent;
import org.bukkit.event.entity.PlayerLeashEntityEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class GadgetParachute
extends Gadget {
    private boolean activated = false;
    private ArrayList<Chicken> chickens = new ArrayList();
    private boolean run = true;
    private int step = 0;
    private ArmorStand armorstand;
    private boolean enableFlyByDefault = false;

    public GadgetParachute(UUID uuid) {
        super(uuid, GadgetType.PARACHUTE);
    }

    @Override
    protected boolean checkRequirements() {
        if (this.activated) {
            this.getPlayer().sendMessage(MessageType.GADGET_IS_ACTIVATED.getFormatMessage().replace("{GADGET}", this.getType().getDisplayNameStripColor()));
            return false;
        }
        if (!this.getPlayer().isOnGround()) {
            this.getPlayer().sendMessage(MessageType.NOT_ON_GROUND.getFormatMessage());
            return false;
        }
        return super.checkRequirements();
    }

    @Override
    public void onClick() {
        boolean allowFlight;
        this.activated = true;
        ParticleEffect.EXPLOSION_HUGE.display(this.getPlayer().getLocation(), 0.5f, 3);
        SoundEffect.ENTITY_GENERIC_EXPLODE.playSound(this.getPlayer().getLocation());
        if (this.getPlayer().isFlying()) {
            this.getPlayer().setFlying(false);
            this.enableFlyByDefault = true;
        }
        if (!(allowFlight = this.getPlayer().getAllowFlight())) {
            this.getPlayer().setAllowFlight(true);
        }
        ArmorStand armorStand = (ArmorStand)this.getPlayer().getWorld().spawn(this.getPlayer().getLocation(), ArmorStand.class);
        armorStand.setVisible(false);
        armorStand.setGravity(true);
        armorStand.setSmall(true);
        armorStand.setBasePlate(false);
        armorStand.setPassenger((Entity)this.getPlayer());
        this.armorstand = armorStand;
        this.armorstand.teleport(this.armorstand.getLocation().add(0.0, 1.0, 0.0));
        this.armorstand.setVelocity(new Vector(0, 5, 0));
        GadgetsMenu.getPlayerManager(this.getPlayer()).disableFallDamage();
        if (!allowFlight) {
            this.getPlayer().setAllowFlight(false);
        }
    }

    @Override
    public void onUpdate() {
        if (this.activated) {
            if (!this.getPlayer().isOnline() || GadgetsMenu.getPlayerManager(this.getPlayer()).getCurrentGadget() == null || GadgetsMenu.getPlayerManager(this.getPlayer()).getCurrentGadget().getType() != this.getType()) {
                Bukkit.getScheduler().runTask((Plugin)GadgetsMenu.getInstance(), () -> this.onClear());
                return;
            }
            ++this.step;
            Bukkit.getScheduler().runTask((Plugin)GadgetsMenu.getInstance(), () -> {
                if (this.getPlayer().getGameMode() != GameMode.SPECTATOR && this.getPlayer().isFlying()) {
                    this.getPlayer().setFlying(false);
                    this.enableFlyByDefault = true;
                }
            });
            if (this.getPlayer().getLocation().add(0.0, 1.0, 0.0).getBlock().getType() != Material.AIR || this.step >= 30 && !this.getPlayer().isOnGround() && !this.armorstand.isOnGround()) {
                if (this.run) {
                    if (this.armorstand.getVelocity().getY() < -0.2) {
                        MathUtil.applyVelocity((Entity)this.armorstand, this.armorstand.getVelocity().add(new Vector(0.0, 0.3, 0.0)));
                    }
                    this.run = false;
                    BukkitRunnable runnable = new BukkitRunnable(){

                        public void run() {
                            if (GadgetParachute.this.getPlayer().isOnGround() || GadgetParachute.this.armorstand == null || GadgetParachute.this.armorstand.isOnGround() || GadgetParachute.this.armorstand.getPassenger() == null) {
                                GadgetParachute.this.clearAll();
                                this.cancel();
                                return;
                            }
                            for (int i = 1; i <= 10; ++i) {
                                Chicken chicken = (Chicken)GadgetParachute.this.getPlayer().getWorld().spawnEntity(GadgetParachute.this.getPlayer().getLocation().add(MathUtil.randomDouble(0.5, 1.0), 3.0, MathUtil.randomDouble(0.5, 1.0)), EntityType.CHICKEN);
                                GadgetParachute.this.chickens.add(chicken);
                                chicken.setLeashHolder((Entity)GadgetParachute.this.getPlayer());
                                chicken.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
                            }
                        }
                    };
                    runnable.runTaskLater((Plugin)GadgetsMenu.getInstance(), 20L);
                }
                if (!this.armorstand.isOnGround()) {
                    if (this.armorstand.getVelocity().getY() < -0.33) {
                        MathUtil.applyVelocity((Entity)this.armorstand, this.armorstand.getVelocity().add(new Vector(0.0, 0.2, 0.0)));
                    }
                    for (Chicken c : this.chickens) {
                        if (!(c.getVelocity().getY() < -0.1)) continue;
                        MathUtil.applyVelocity((Entity)c, c.getVelocity().add(new Vector(0.0, 0.1, 0.0)));
                    }
                } else {
                    try {
                        MathUtil.applyVelocity((Entity)this.armorstand, new Vector(0.0, 0.2, 0.0));
                        Bukkit.getScheduler().runTask((Plugin)GadgetsMenu.getInstance(), () -> this.onClear());
                    }
                    catch (Exception ex) {
                        MathUtil.applyVelocity((Entity)this.armorstand, new Vector(0.0, 0.2, 0.0));
                        this.clearAll();
                    }
                }
            }
            if (this.step > 5 && (this.getPlayer().isSneaking() || this.step >= 500 || this.getPlayer().isOnGround() || this.armorstand != null && this.armorstand.isOnGround())) {
                Bukkit.getScheduler().runTask((Plugin)GadgetsMenu.getInstance(), () -> this.onClear());
            }
            if (this.run && this.step >= 45) {
                Bukkit.getScheduler().runTask((Plugin)GadgetsMenu.getInstance(), () -> this.onClear());
            }
        }
    }

    @Override
    public void onClear() {
        this.clearAll();
        HandlerList.unregisterAll((Listener)this);
    }

    private void clearAll() {
        for (Chicken chicken : this.chickens) {
            chicken.setLeashHolder(null);
            chicken.remove();
        }
        this.chickens.clear();
        if (this.armorstand != null) {
            this.armorstand.remove();
        }
        this.armorstand = null;
        if (this.getPlayer().isOnGround()) {
            GadgetsMenu.getPlayerManager(this.getPlayer()).enableFallDamage();
        }
        if (this.enableFlyByDefault) {
            Bukkit.getScheduler().runTask((Plugin)GadgetsMenu.getInstance(), () -> this.getPlayer().setAllowFlight(true));
        }
        this.step = 0;
        this.run = true;
        this.activated = false;
        this.enableFlyByDefault = false;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onLeashBreak(EntityUnleashEvent e) {
        if (this.chickens.contains(e.getEntity())) {
            for (Entity ent : e.getEntity().getNearbyEntities(1.0, 1.0, 1.0)) {
                if (!(ent instanceof Item) || !((Item)ent).getItemStack().getType().equals((Object)EnumMaterial.LEAD.getType())) continue;
                ent.remove();
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onLeashEntity(PlayerLeashEntityEvent event) {
        if (event.getPlayer().getItemInHand() != null && event.getPlayer().getItemInHand().hasItemMeta() && GadgetsMenu.getNMSManager().hasNBTTag(event.getPlayer().getItemInHand(), "Cosmetics")) {
            event.setCancelled(true);
            event.getPlayer().updateInventory();
        }
    }
}

