/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.configuration.FileManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.GadgetType;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types.Gadget;
import com.yapzhenyie.GadgetsMenu.utils.EnumMaterial;
import com.yapzhenyie.GadgetsMenu.utils.MathUtil;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.SoundEffect;
import com.yapzhenyie.GadgetsMenu.utils.items.ItemUtils;
import java.util.ArrayList;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class GadgetPartyPopper
extends Gadget {
    private boolean activated = false;
    private ArrayList<Item> items = new ArrayList();
    private static boolean isAffectPlayers = FileManager.getGadgetsFile().getBoolean("Gadgets.Visual.Types.Party Popper.Affect-Players");

    public GadgetPartyPopper(UUID uuid) {
        super(uuid, GadgetType.PARTY_POPPER);
    }

    @Override
    protected boolean checkRequirements() {
        if (this.activated) {
            this.getPlayer().sendMessage(MessageType.GADGET_IS_ACTIVATED.getFormatMessage().replace("{GADGET}", this.getType().getDisplayNameStripColor()));
            return false;
        }
        return true;
    }

    @Override
    public void onClick() {
        this.activated = true;
        new BukkitRunnable(){
            int step = 0;

            public void run() {
                ++this.step;
                if (!GadgetPartyPopper.this.getPlayer().isOnline() || GadgetsMenu.getPlayerManager(GadgetPartyPopper.this.getPlayer()).getCurrentGadget() == null || GadgetsMenu.getPlayerManager(GadgetPartyPopper.this.getPlayer()).getCurrentGadget().getType() != GadgetPartyPopper.this.getType()) {
                    this.step = 100;
                    GadgetPartyPopper.this.onClear();
                    this.cancel();
                    return;
                }
                for (Item item : GadgetPartyPopper.this.items) {
                    if (item.getTicksLived() <= 10) continue;
                    item.remove();
                }
                if (this.step <= 100) {
                    Location loc = GadgetPartyPopper.this.getPlayer().getLocation().add(0.0, 2.0, 0.0);
                    EnumMaterial material = EnumMaterial.valueOf(35, GadgetsMenu.random().nextInt(15));
                    Item item = GadgetPartyPopper.this.getPlayer().getWorld().dropItem(loc, ItemUtils.item(UUID.randomUUID().toString(), material, material.getData()));
                    item.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
                    item.setVelocity(new Vector((GadgetsMenu.random().nextDouble() - 0.5) / 1.7, 0.4, (GadgetsMenu.random().nextDouble() - 0.5) / 1.7));
                    item.setPickupDelay(Integer.MAX_VALUE);
                    GadgetPartyPopper.this.items.add(item);
                    SoundEffect.ENTITY_CHICKEN_EGG.playSound((Entity)item, GadgetPartyPopper.this.getPlayer().getLocation());
                    for (Entity entity : GadgetPartyPopper.this.getPlayer().getNearbyEntities(1.5, 2.5, 1.5)) {
                        if (!(entity instanceof Player) || !isAffectPlayers) continue;
                        MathUtil.applyVelocity(entity, new Vector(0.0, 0.5, 0.0).add(MathUtil.getRandomCircleVector().multiply(0.1)));
                    }
                } else {
                    GadgetPartyPopper.this.clearAll();
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)GadgetsMenu.getInstance(), 0L, 2L);
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public void onClear() {
        this.clearAll();
        HandlerList.unregisterAll((Listener)this);
    }

    private void clearAll() {
        for (Item item : this.items) {
            item.remove();
        }
        this.items.clear();
        this.activated = false;
    }
}

