/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.GadgetType;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types.Gadget;
import com.yapzhenyie.GadgetsMenu.utils.EnumMaterial;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.SoundEffect;
import com.yapzhenyie.GadgetsMenu.utils.VersionManager;
import com.yapzhenyie.GadgetsMenu.utils.items.ItemUtils;
import java.util.ArrayList;
import java.util.UUID;
import org.bukkit.entity.Item;
import org.bukkit.entity.Pig;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class GadgetPiggyBank
extends Gadget {
    private boolean activated = false;
    private Pig pig;
    private ArrayList<Item> items = new ArrayList();

    public GadgetPiggyBank(UUID uuid) {
        super(uuid, GadgetType.PIGGY_BANK);
    }

    @Override
    protected boolean checkRequirements() {
        if (this.activated) {
            this.getPlayer().sendMessage(MessageType.GADGET_IS_ACTIVATED.getFormatMessage().replace("{GADGET}", this.getType().getDisplayNameStripColor()));
            return false;
        }
        return super.checkRequirements();
    }

    @Override
    public void onClick() {
        final Pig entityPig = (Pig)this.getPlayer().getLocation().getWorld().spawn(this.getPlayer().getLocation(), Pig.class);
        entityPig.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
        try {
            if (VersionManager.is1_9OrAbove()) {
                entityPig.setSilent(true);
            }
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        this.pig = entityPig;
        this.activated = true;
        new BukkitRunnable(){
            int step = 0;

            public void run() {
                ++this.step;
                if (!GadgetPiggyBank.this.getPlayer().isOnline() || GadgetsMenu.getPlayerManager(GadgetPiggyBank.this.getPlayer()).getCurrentGadget() == null || GadgetsMenu.getPlayerManager(GadgetPiggyBank.this.getPlayer()).getCurrentGadget().getType() != GadgetPiggyBank.this.getType()) {
                    this.step = 4;
                    GadgetPiggyBank.this.onClear();
                    this.cancel();
                    return;
                }
                if (this.step <= 3) {
                    entityPig.setVelocity(new Vector(0.0, 0.7, 0.0));
                } else {
                    EnumMaterial[] materials = new EnumMaterial[]{EnumMaterial.GOLD_BLOCK, EnumMaterial.GOLD_INGOT, EnumMaterial.GOLDEN_HELMET, EnumMaterial.GOLDEN_CHESTPLATE, EnumMaterial.GOLDEN_LEGGINGS, EnumMaterial.GOLDEN_BOOTS, EnumMaterial.GOLDEN_SWORD, EnumMaterial.GOLDEN_PICKAXE, EnumMaterial.GOLDEN_SHOVEL};
                    for (int i = 0; i <= 50; ++i) {
                        Item item = GadgetPiggyBank.this.getPlayer().getWorld().dropItem(entityPig.getLocation(), ItemUtils.item(UUID.randomUUID().toString(), materials[GadgetsMenu.random().nextInt(materials.length)], 0));
                        item.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
                        item.setVelocity(new Vector((GadgetsMenu.random().nextDouble() - 0.5) / 4.0, 0.4, (GadgetsMenu.random().nextDouble() - 0.5) / 4.0));
                        item.setPickupDelay(Integer.MAX_VALUE);
                        GadgetPiggyBank.this.items.add(item);
                    }
                    SoundEffect.ENTITY_PLAYER_LEVELUP.playSound(entityPig.getLocation());
                    if (GadgetPiggyBank.this.pig != null) {
                        GadgetPiggyBank.this.pig.remove();
                    }
                    this.cancel();
                    new BukkitRunnable(){

                        public void run() {
                            GadgetPiggyBank.this.clearAll();
                        }
                    }.runTaskLater((Plugin)GadgetsMenu.getInstance(), 70L);
                }
            }
        }.runTaskTimer((Plugin)GadgetsMenu.getInstance(), 0L, 5L);
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public void onClear() {
        this.clearAll();
    }

    private void clearAll() {
        if (!this.items.isEmpty()) {
            for (Item item : this.items) {
                item.remove();
            }
            this.items.clear();
        }
        if (this.pig != null) {
            this.pig.remove();
        }
        this.pig = null;
        this.activated = false;
    }
}

