/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.configuration.FileManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.GadgetType;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types.Gadget;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.EnumItem;
import com.yapzhenyie.GadgetsMenu.utils.GInventory;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.StringUtils;
import com.yapzhenyie.GadgetsMenu.utils.items.InventoryUtils;
import com.yapzhenyie.GadgetsMenu.utils.items.ItemUtils;
import depend.xxmicloxx.NoteBlockAPI.songplayer.RadioSongPlayer;
import depend.xxmicloxx.NoteBlockAPI.utils.NBSDecoder;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class GadgetRadio
extends Gadget {
    private static String radioGUIName = FileManager.getGadgetsFile().getString("Gadgets.Musical.Types.Radio.Items.GUI-Name");
    private RadioSongPlayer songPlayer;
    private static File files = new File(GadgetsMenu.getInstance().getDataFolder().getPath() + "/songs/RadioGadget/");
    private static List<File> songs = new ArrayList<File>();

    public GadgetRadio(UUID uuid) {
        super(uuid, GadgetType.RADIO);
        this.addCooldownAfterClick = false;
        if (songs.isEmpty()) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)GadgetsMenu.getInstance(), new Runnable(){

                @Override
                public void run() {
                    if (files.exists() && files.listFiles().length > 0) {
                        for (File f : files.listFiles()) {
                            if (!f.getName().contains(".nbs") || songs.contains(f)) continue;
                            songs.add(f);
                        }
                    }
                }
            });
        }
    }

    @Override
    void onClick() {
        this.openRadioMenu(this.getPlayer(), 1);
    }

    @Override
    void onUpdate() {
    }

    @Override
    public void onClear() {
        this.clearAll();
        HandlerList.unregisterAll((Listener)this);
    }

    private void clearAll() {
        if (this.songPlayer != null && this.songPlayer.isPlaying()) {
            this.songPlayer.setPlaying(false);
        }
        this.songPlayer = null;
    }

    private void openRadioMenu(Player player, int page) {
        if (files.exists() && files.listFiles().length > 0) {
            for (File f : files.listFiles()) {
                if (!f.getName().contains(".nbs") || songs.contains(f)) continue;
                songs.add(f);
            }
        }
        int size = songs.size();
        int maxPages = GInventory.getMaxPagesAmount(27, size);
        if (page <= 0) {
            page = 1;
        }
        if (page > 1 && maxPages < page) {
            page = 1;
        }
        Inventory invradio = Bukkit.createInventory(null, (int)54, (String)ChatUtil.format(radioGUIName + StringUtils.addPlaceholders(EnumItem.PAGES.getDisplayName(), Arrays.asList("{CURRENT_PAGE}", "{MAX_PAGES}"), Arrays.asList(String.valueOf(page), String.valueOf(maxPages)))));
        int i = 0;
        int from = 1;
        if (page > 1) {
            from = 27 * (page - 1) + 1;
        }
        int to = 27;
        if (size < 27) {
            to = size;
        }
        if (page > 1) {
            to = size >= 27 * page ? 27 * page : size;
        }
        for (int h = from; h <= to; ++h) {
            try {
                if (h > size) break;
                File disc = songs.get(h - 1);
                InventoryUtils.inventory(invradio, StringUtils.addPlaceholders(EnumItem.RADIO_TRACK.getDisplayName(), Arrays.asList("{TRACK}", ".nbs"), Arrays.asList(disc.getName(), "")), EnumItem.RADIO_TRACK.getMaterial(), EnumItem.RADIO_TRACK.getLore(), GInventory.LAY_OUT_27.getLayOut()[i++]);
                continue;
            }
            catch (Exception Ex) {
                Ex.printStackTrace();
                player.sendMessage(MessageType.ERROR.getFormatMessage());
                return;
            }
        }
        if (page > 1) {
            InventoryUtils.inventory(invradio, EnumItem.PREVIOUS_PAGE.getItemStack(), "{PAGE}", String.valueOf(page - 1), EnumItem.PREVIOUS_PAGE.getSlot());
        }
        if (page < maxPages) {
            InventoryUtils.inventory(invradio, EnumItem.NEXT_PAGE.getItemStack(), "{PAGE}", String.valueOf(page + 1), EnumItem.NEXT_PAGE.getSlot());
        }
        InventoryUtils.inventory(invradio, EnumItem.RADIO_STOP_TRACK.getItemStack(), EnumItem.RADIO_STOP_TRACK.getSlot());
        InventoryUtils.fillItems(invradio);
        player.openInventory(invradio);
        GadgetsMenu.getPlayerManager(player).setCurrentRadioGadgetPage(page);
    }

    @EventHandler
    public void onInvClickDisc(InventoryClickEvent e) {
        final Player player = (Player)e.getWhoClicked();
        if (player == this.getPlayer() && GadgetsMenu.getPlayerManager(this.getPlayer()).getCurrentGadget() != null && GadgetsMenu.getPlayerManager(this.getPlayer()).getCurrentGadget().getType() == this.getType() && e.getView().getTitle().startsWith(ChatUtil.format(radioGUIName))) {
            if (e.getClickedInventory() == null || e.getClickedInventory().getSize() != 54 || e.getClickedInventory().getType() != InventoryType.CHEST) {
                e.setCancelled(true);
                return;
            }
            if (e.getCurrentItem() == null || e.getCurrentItem().getItemMeta() == null || e.getCurrentItem().getItemMeta().getDisplayName() == null) {
                e.setCancelled(true);
                return;
            }
            if (e.getClick() == ClickType.SHIFT_LEFT || e.getClick() == ClickType.SHIFT_RIGHT || e.getClick() == ClickType.NUMBER_KEY || e.getClick() == ClickType.UNKNOWN) {
                e.setCancelled(true);
                player.updateInventory();
                return;
            }
            if (ItemUtils.getCurrentItem(e, EnumItem.RADIO_STOP_TRACK.getItemStack(), EnumItem.RADIO_STOP_TRACK.getSlot())) {
                this.clearAll();
                player.closeInventory();
                e.setCancelled(true);
                return;
            }
            if (ItemUtils.getCurrentItem(e, EnumItem.PREVIOUS_PAGE.getDisplayName(), EnumItem.PREVIOUS_PAGE.getSlot())) {
                this.openRadioMenu(player, GadgetsMenu.getPlayerManager(player).getCurrentRadioGadgetPage() - 1);
                e.setCancelled(true);
                return;
            }
            if (ItemUtils.getCurrentItem(e, EnumItem.NEXT_PAGE.getDisplayName(), EnumItem.NEXT_PAGE.getSlot())) {
                this.openRadioMenu(player, GadgetsMenu.getPlayerManager(player).getCurrentRadioGadgetPage() + 1);
                player.updateInventory();
                e.setCancelled(true);
                return;
            }
            for (final File disc : songs) {
                if (!e.getCurrentItem().getItemMeta().getDisplayName().equals(ChatUtil.format(FileManager.getGadgetsFile().getString("Gadgets.Musical.Types.Radio.Items.Track.Name").replace("{TRACK}", disc.getName()).replace(".nbs", "")))) continue;
                this.clearAll();
                super.addCooldownTimer();
                this.songPlayer = new RadioSongPlayer(NBSDecoder.parse(disc));
                this.songPlayer.setPlaying(true);
                if (!this.songPlayer.getPlayerList().contains(this.getPlayer())) {
                    this.songPlayer.addPlayer(this.getPlayer());
                }
                this.songPlayer.setVolume((byte)100);
                this.songPlayer.getFadeIn().setFadeStart((byte)25);
                this.songPlayer.getFadeOut().setFadeStart((byte)25);
                BukkitRunnable runnable = new BukkitRunnable(){
                    int times = 0;

                    public void run() {
                        if (!GadgetRadio.this.getPlayer().isOnline() || GadgetsMenu.getPlayerManager(GadgetRadio.this.getPlayer()).getCurrentGadget() == null || GadgetsMenu.getPlayerManager(GadgetRadio.this.getPlayer()).getCurrentGadget().getType() != GadgetRadio.this.getType()) {
                            GadgetRadio.this.showCooldownBar = true;
                            this.cancel();
                            return;
                        }
                        if (this.times > 5) {
                            GadgetRadio.this.showCooldownBar = true;
                            this.cancel();
                            return;
                        }
                        GadgetRadio.this.showCooldownBar = false;
                        GadgetsMenu.getPlayerManager(player).sendActionMessage(MessageType.PLAYING_SONG.getFormatMessage().replace("{RANDOM_COLOR}", ChatUtil.getRandomColor()).replace("{SONG}", disc.getName().replace(".nbs", "")));
                        ++this.times;
                    }
                };
                runnable.runTaskTimer((Plugin)GadgetsMenu.getInstance(), 0L, 10L);
                player.closeInventory();
                e.setCancelled(true);
                return;
            }
            e.setCancelled(true);
            return;
        }
    }
}

