/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.GadgetType;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types.Gadget;
import com.yapzhenyie.GadgetsMenu.utils.BlockUtil;
import com.yapzhenyie.GadgetsMenu.utils.CuboID;
import com.yapzhenyie.GadgetsMenu.utils.EnumMaterial;
import com.yapzhenyie.GadgetsMenu.utils.MathUtil;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import java.util.ArrayList;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LeashHitch;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.hanging.HangingBreakEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class GadgetTetherball
extends Gadget {
    private boolean activated = false;
    private ArrayList<Block> blocks = new ArrayList();
    private Chicken chicken;
    private Location targetBlockLocation;
    private LeashHitch chickenLeash;

    public GadgetTetherball(UUID uuid) {
        super(uuid, GadgetType.TETHERBALL);
    }

    @Override
    protected boolean checkRequirements() {
        Location loc2;
        if (this.activated) {
            this.getPlayer().sendMessage(MessageType.GADGET_IS_ACTIVATED.getFormatMessage().replace("{GADGET}", this.getType().getDisplayNameStripColor()));
            return false;
        }
        Location location = BlockUtil.getTargetBlock(this.getPlayer(), 7).getLocation();
        if (location.getBlock().isEmpty()) {
            this.getPlayer().sendMessage(MessageType.TARGET_A_BLOCK.getFormatMessage());
            return false;
        }
        Location loc1 = location.clone().add(0.0, 1.0, 0.0);
        CuboID checkCuboid = new CuboID(loc1, loc2 = location.clone().add(0.0, 7.0, 0.0));
        if (!checkCuboid.isEmpty() || this.getPlayer().getLocation().add(0.0, 7.0, 0.0).getBlockY() >= 256 || checkCuboid.hasHangingEntities()) {
            Location loc2_2;
            Location location2 = ((Block)this.getPlayer().getLastTwoTargetBlocks((Set)null, 7).get(0)).getLocation();
            Location loc2_1 = location2.clone();
            CuboID checkCuboid2 = new CuboID(loc2_1, loc2_2 = location2.clone().add(0.0, 7.0, 0.0));
            if (checkCuboid2.isEmpty() && this.getPlayer().getLocation().add(0.0, 7.0, 0.0).getBlockY() < 256 && !checkCuboid.hasHangingEntities()) {
                this.targetBlockLocation = location2;
                return true;
            }
            this.getPlayer().sendMessage(MessageType.NOT_ENOUGH_SPACE.getFormatMessage());
            return false;
        }
        this.targetBlockLocation = location.clone().add(0.0, 1.0, 0.0);
        return true;
    }

    @Override
    public void onClick() {
        for (int i = 0; i <= 7; ++i) {
            Block fence = this.targetBlockLocation.clone().add(0.0, (double)i, 0.0).getBlock();
            fence.setType(EnumMaterial.OAK_FENCE.getType());
            fence.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
            this.blocks.add(fence);
        }
        Chicken entityChicken = (Chicken)this.getPlayer().getWorld().spawnEntity(this.getPlayer().getLocation().add(MathUtil.randomDouble(0.0, 0.5), 3.0, MathUtil.randomDouble(0.0, 0.5)), EntityType.CHICKEN);
        LeashHitch hitch = (LeashHitch)this.getPlayer().getWorld().spawnEntity(this.blocks.get(this.blocks.size() - 1).getLocation(), EntityType.LEASH_HITCH);
        hitch.setFacingDirection(BlockFace.SELF, true);
        hitch.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
        entityChicken.setMetadata("Tetherball-Chicken", (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
        entityChicken.setMaxHealth(28.0);
        entityChicken.setHealth(28.0);
        entityChicken.setLeashHolder((Entity)hitch);
        this.chickenLeash = hitch;
        this.chicken = entityChicken;
        this.activated = true;
        new BukkitRunnable(){

            public void run() {
                if (!GadgetTetherball.this.getPlayer().isOnline() || GadgetsMenu.getPlayerManager(GadgetTetherball.this.getPlayer()).getCurrentGadget() == null || GadgetsMenu.getPlayerManager(GadgetTetherball.this.getPlayer()).getCurrentGadget().getType() != GadgetTetherball.this.getType()) {
                    GadgetTetherball.this.onClear();
                    this.cancel();
                    return;
                }
                GadgetTetherball.this.clearAll();
            }
        }.runTaskLater((Plugin)GadgetsMenu.getInstance(), 300L);
    }

    @Override
    public void onUpdate() {
        if (this.activated && this.chicken != null && this.chicken.getHealth() < 20.0) {
            this.chicken.setHealth(28.0);
            MathUtil.applyVelocity((Entity)this.chicken, new Vector(0.0, 0.1, 0.0));
        }
    }

    @Override
    public void onClear() {
        this.clearAll();
        HandlerList.unregisterAll((Listener)this);
    }

    private void clearAll() {
        for (Block block : this.blocks) {
            block.removeMetadata(GadgetsMenu.getInstance().getPluginName(), (Plugin)GadgetsMenu.getInstance());
            if (block.getType() != EnumMaterial.OAK_FENCE.getType()) continue;
            block.setType(Material.AIR);
        }
        if (this.chickenLeash != null && this.chickenLeash.isValid()) {
            this.chickenLeash.remove();
        }
        if (this.chicken != null) {
            this.chicken.remove();
            this.chicken.setLeashHolder(null);
        }
        this.chicken = null;
        this.chickenLeash = null;
        this.activated = false;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onLeashBreak(HangingBreakByEntityEvent event) {
        LeashHitch leash;
        if (event.getCause() == HangingBreakEvent.RemoveCause.ENTITY && event.getRemover() == this.getPlayer() && event.getEntity() instanceof LeashHitch && (leash = (LeashHitch)event.getEntity()).hasMetadata(GadgetsMenu.getInstance().getPluginName())) {
            event.setCancelled(true);
        }
    }
}

