/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.GadgetType;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types.Gadget;
import com.yapzhenyie.GadgetsMenu.utils.BlockUtil;
import com.yapzhenyie.GadgetsMenu.utils.CuboID;
import com.yapzhenyie.GadgetsMenu.utils.EntityUtils;
import com.yapzhenyie.GadgetsMenu.utils.EnumMaterial;
import com.yapzhenyie.GadgetsMenu.utils.MathUtil;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.ReflectionUtils;
import com.yapzhenyie.GadgetsMenu.utils.VersionManager;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.entity.Entity;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class GadgetTrampoline
extends Gadget {
    private boolean activated = false;
    private Location location;
    private CuboID cuboid;
    private HashMap<Location, String> blocks = new HashMap();

    public GadgetTrampoline(UUID uuid) {
        super(uuid, GadgetType.TRAMPOLINE);
    }

    @Override
    protected boolean checkRequirements() {
        if (this.activated) {
            this.getPlayer().sendMessage(MessageType.GADGET_IS_ACTIVATED.getFormatMessage().replace("{GADGET}", this.getType().getDisplayNameStripColor()));
            return false;
        }
        if (!this.getPlayer().isOnGround()) {
            this.getPlayer().sendMessage(MessageType.NOT_ON_GROUND.getFormatMessage());
            return false;
        }
        Location loc1 = this.getPlayer().getLocation().clone().add(-3.0, 0.0, -3.0);
        Location loc2 = this.getPlayer().getLocation().clone().add(3.0, 20.0, 3.0);
        Block stair = this.getPlayer().getLocation().clone().getBlock().getRelative(-4, 1, 0);
        Block stair2 = this.getPlayer().getLocation().clone().getBlock().getRelative(-5, 0, 0);
        this.cuboid = new CuboID(loc1, loc2);
        if (!this.cuboid.isEmpty() || stair.getType() != Material.AIR || stair2.getType() != Material.AIR) {
            this.getPlayer().sendMessage(MessageType.NOT_ENOUGH_SPACE.getFormatMessage());
            return false;
        }
        return true;
    }

    @Override
    public void onClick() {
        this.location = this.getPlayer().getLocation().clone();
        this.getPlayer().teleport(this.getPlayer().getLocation().clone().add(0.0, 5.0, 0.0));
        this.genetateTrampoline();
        for (Entity entity : EntityUtils.getNearbyLivingEntities(this.location, 3.0)) {
            entity.teleport(entity.getLocation().clone().add(0.0, 2.0, 0.0));
        }
        new BukkitRunnable(){

            public void run() {
                if (!GadgetTrampoline.this.getPlayer().isOnline() || GadgetsMenu.getPlayerManager(GadgetTrampoline.this.getPlayer()).getCurrentGadget() == null || GadgetsMenu.getPlayerManager(GadgetTrampoline.this.getPlayer()).getCurrentGadget().getType() != GadgetTrampoline.this.getType() || !GadgetTrampoline.this.activated) {
                    return;
                }
                GadgetTrampoline.this.clearAll();
            }
        }.runTaskLater((Plugin)GadgetsMenu.getInstance(), 300L);
        this.activated = true;
    }

    @Override
    public void onUpdate() {
        if (this.activated) {
            Bukkit.getScheduler().runTask((Plugin)GadgetsMenu.getInstance(), new Runnable(){

                @Override
                public void run() {
                    for (Entity entity : EntityUtils.getNearbyLivingEntities(GadgetTrampoline.this.location, 4.0)) {
                        Block b = entity.getLocation().getBlock().getRelative(BlockFace.DOWN);
                        if (b.getType() != EnumMaterial.BLACK_WOOL.getType() || b.getData() != 15 || !GadgetTrampoline.this.cuboid.contains(b)) continue;
                        MathUtil.applyVelocity(entity, new Vector(0, 3, 0));
                    }
                }
            });
        }
    }

    @Override
    public void onClear() {
        this.clearAll();
        HandlerList.unregisterAll((Listener)this);
    }

    private void clearAll() {
        for (Location location : this.blocks.keySet()) {
            Block b = location.clone().getBlock();
            b.setType(Material.AIR);
            b.removeMetadata(GadgetsMenu.getInstance().getPluginName(), (Plugin)GadgetsMenu.getInstance());
        }
        this.blocks.clear();
        this.activated = false;
    }

    private void genetateTrampoline() {
        this.setBlock(this.getLocation(3, 0, 3), EnumMaterial.OAK_FENCE, false, (byte)0);
        this.setBlock(this.getLocation(-3, 0, 3), EnumMaterial.OAK_FENCE, false, (byte)0);
        this.setBlock(this.getLocation(3, 0, -3), EnumMaterial.OAK_FENCE, false, (byte)0);
        this.setBlock(this.getLocation(-3, 0, -3), EnumMaterial.OAK_FENCE, false, (byte)0);
        this.setBlock(this.getLocation(3, 1, 3), EnumMaterial.BLUE_WOOL, false, (byte)11);
        this.setBlock(this.getLocation(2, 1, 3), EnumMaterial.BLUE_WOOL, false, (byte)11);
        this.setBlock(this.getLocation(1, 1, 3), EnumMaterial.BLUE_WOOL, false, (byte)11);
        this.setBlock(this.getLocation(0, 1, 3), EnumMaterial.BLUE_WOOL, false, (byte)11);
        this.setBlock(this.getLocation(-1, 1, 3), EnumMaterial.BLUE_WOOL, false, (byte)11);
        this.setBlock(this.getLocation(-2, 1, 3), EnumMaterial.BLUE_WOOL, false, (byte)11);
        this.setBlock(this.getLocation(-3, 1, 3), EnumMaterial.BLUE_WOOL, false, (byte)11);
        this.setBlock(this.getLocation(3, 1, 2), EnumMaterial.BLUE_WOOL, false, (byte)11);
        this.setBlock(this.getLocation(3, 1, 1), EnumMaterial.BLUE_WOOL, false, (byte)11);
        this.setBlock(this.getLocation(3, 1, 0), EnumMaterial.BLUE_WOOL, false, (byte)11);
        this.setBlock(this.getLocation(3, 1, -1), EnumMaterial.BLUE_WOOL, false, (byte)11);
        this.setBlock(this.getLocation(3, 1, -2), EnumMaterial.BLUE_WOOL, false, (byte)11);
        this.setBlock(this.getLocation(-3, 1, 2), EnumMaterial.BLUE_WOOL, false, (byte)11);
        this.setBlock(this.getLocation(-3, 1, 1), EnumMaterial.BLUE_WOOL, false, (byte)11);
        this.setBlock(this.getLocation(-3, 1, 0), EnumMaterial.BLUE_WOOL, false, (byte)11);
        this.setBlock(this.getLocation(-3, 1, -1), EnumMaterial.BLUE_WOOL, false, (byte)11);
        this.setBlock(this.getLocation(-3, 1, -2), EnumMaterial.BLUE_WOOL, false, (byte)11);
        this.setBlock(this.getLocation(3, 1, -3), EnumMaterial.BLUE_WOOL, false, (byte)11);
        this.setBlock(this.getLocation(2, 1, -3), EnumMaterial.BLUE_WOOL, false, (byte)11);
        this.setBlock(this.getLocation(1, 1, -3), EnumMaterial.BLUE_WOOL, false, (byte)11);
        this.setBlock(this.getLocation(0, 1, -3), EnumMaterial.BLUE_WOOL, false, (byte)11);
        this.setBlock(this.getLocation(-1, 1, -3), EnumMaterial.BLUE_WOOL, false, (byte)11);
        this.setBlock(this.getLocation(-2, 1, -3), EnumMaterial.BLUE_WOOL, false, (byte)11);
        this.setBlock(this.getLocation(-3, 1, -3), EnumMaterial.BLUE_WOOL, false, (byte)11);
        this.setBlock(this.getLocation(2, 1, 2), EnumMaterial.BLACK_WOOL, false, (byte)15);
        this.setBlock(this.getLocation(1, 1, 2), EnumMaterial.BLACK_WOOL, false, (byte)15);
        this.setBlock(this.getLocation(0, 1, 2), EnumMaterial.BLACK_WOOL, false, (byte)15);
        this.setBlock(this.getLocation(-1, 1, 2), EnumMaterial.BLACK_WOOL, false, (byte)15);
        this.setBlock(this.getLocation(-2, 1, 2), EnumMaterial.BLACK_WOOL, false, (byte)15);
        this.setBlock(this.getLocation(2, 1, 1), EnumMaterial.BLACK_WOOL, false, (byte)15);
        this.setBlock(this.getLocation(1, 1, 1), EnumMaterial.BLACK_WOOL, false, (byte)15);
        this.setBlock(this.getLocation(0, 1, 1), EnumMaterial.BLACK_WOOL, false, (byte)15);
        this.setBlock(this.getLocation(-1, 1, 1), EnumMaterial.BLACK_WOOL, false, (byte)15);
        this.setBlock(this.getLocation(-2, 1, 1), EnumMaterial.BLACK_WOOL, false, (byte)15);
        this.setBlock(this.getLocation(2, 1, 0), EnumMaterial.BLACK_WOOL, false, (byte)15);
        this.setBlock(this.getLocation(1, 1, 0), EnumMaterial.BLACK_WOOL, false, (byte)15);
        this.setBlock(this.getLocation(0, 1, 0), EnumMaterial.BLACK_WOOL, false, (byte)15);
        this.setBlock(this.getLocation(-1, 1, 0), EnumMaterial.BLACK_WOOL, false, (byte)15);
        this.setBlock(this.getLocation(-2, 1, 0), EnumMaterial.BLACK_WOOL, false, (byte)15);
        this.setBlock(this.getLocation(2, 1, -1), EnumMaterial.BLACK_WOOL, false, (byte)15);
        this.setBlock(this.getLocation(1, 1, -1), EnumMaterial.BLACK_WOOL, false, (byte)15);
        this.setBlock(this.getLocation(0, 1, -1), EnumMaterial.BLACK_WOOL, false, (byte)15);
        this.setBlock(this.getLocation(-1, 1, -1), EnumMaterial.BLACK_WOOL, false, (byte)15);
        this.setBlock(this.getLocation(-2, 1, -1), EnumMaterial.BLACK_WOOL, false, (byte)15);
        this.setBlock(this.getLocation(2, 1, -2), EnumMaterial.BLACK_WOOL, false, (byte)15);
        this.setBlock(this.getLocation(1, 1, -2), EnumMaterial.BLACK_WOOL, false, (byte)15);
        this.setBlock(this.getLocation(0, 1, -2), EnumMaterial.BLACK_WOOL, false, (byte)15);
        this.setBlock(this.getLocation(-1, 1, -2), EnumMaterial.BLACK_WOOL, false, (byte)15);
        this.setBlock(this.getLocation(-2, 1, -2), EnumMaterial.BLACK_WOOL, false, (byte)15);
        this.setBlock(this.getLocation(-4, 1, 0), EnumMaterial.OAK_STAIRS, true, (byte)0);
        this.setBlock(this.getLocation(-5, 0, 0), EnumMaterial.OAK_STAIRS, true, (byte)0);
    }

    private void setBlock(Block block, EnumMaterial material, boolean changeFacing, byte facing) {
        if (!this.blocks.containsKey(block.getLocation())) {
            if (VersionManager.is1_13OrAbove()) {
                try {
                    this.blocks.put(block.getLocation(), block.getBlockData().getAsString());
                }
                catch (NoSuchMethodError noSuchMethodError) {}
            } else {
                try {
                    this.blocks.put(block.getLocation(), block.getType().toString() + "," + block.getData());
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
            }
            block.setType(material.getType());
            if (VersionManager.is1_13OrAbove()) {
                if (changeFacing) {
                    BlockData blockData = block.getBlockData();
                    ((Directional)blockData).setFacing(BlockUtil.getBlockFace(facing));
                    block.setBlockData(blockData);
                }
            } else {
                ReflectionUtils.setData(block, changeFacing ? facing : material.getData());
            }
            block.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
        }
    }

    private Block getLocation(int x, int y, int z) {
        return this.location.getBlock().getRelative(x, y, z);
    }
}

