/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.hats.animated;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.cosmetics.Category;
import com.yapzhenyie.GadgetsMenu.cosmetics.CategoryManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.hats.animated.AnimatedHat;
import com.yapzhenyie.GadgetsMenu.cosmetics.hats.animated.AnimatedHatType;
import com.yapzhenyie.GadgetsMenu.player.PlayerManager;
import com.yapzhenyie.GadgetsMenu.utils.EnumEquipType;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class AnimatedHatManager {
    public static void equipAnimatedHat(Player player, AnimatedHatType type) {
        if (!type.isEnabled() || !Category.ANIMATED_HATS.isEnabled()) {
            return;
        }
        if (player == null) {
            return;
        }
        PlayerManager pManager = GadgetsMenu.getPlayerManager(player);
        if (pManager == null) {
            return;
        }
        if (player.getInventory().getHelmet() != null) {
            CategoryManager.removeHelmetCosmetic(player);
            if (player.getInventory().getHelmet() != null) {
                if (CategoryManager.checkEquipRequirement(player, MessageType.REMOVE_HELMET_TO_EQUIP_ANIMATED_HAT.getFormatMessage())) {
                    return;
                }
                if (GadgetsMenu.getGadgetsMenuData().getEquipCosmeticItemToSlotAction() == EnumEquipType.DROP) {
                    Bukkit.getScheduler().runTask((Plugin)GadgetsMenu.getInstance(), () -> {
                        player.getWorld().dropItemNaturally(player.getLocation(), player.getInventory().getHelmet().clone());
                        player.getInventory().setHelmet(null);
                        player.updateInventory();
                    });
                }
            }
        }
        if (pManager.getSelectedMorph() != null) {
            pManager.unequipMorph();
        }
        new AnimatedHat(player.getUniqueId(), type);
        pManager.setSelectedAnimatedHat(type);
    }

    public static void unequipAnimatedHat(Player player) {
        if (player == null) {
            return;
        }
        PlayerManager pManager = GadgetsMenu.getPlayerManager(player);
        if (pManager == null) {
            return;
        }
        if (player.getInventory().getHelmet() != null || pManager.getSelectedAnimatedHat() != null) {
            if (player.getInventory().getHelmet() != null && player.getInventory().getHelmet().getItemMeta() != null && GadgetsMenu.getNMSManager().isNBTTagEqual(player.getInventory().getHelmet(), "Category", "Animated_Hat")) {
                player.getInventory().setHelmet(null);
                player.updateInventory();
            }
            if (pManager.getSelectedAnimatedHat() != null) {
                pManager.setSelectedAnimatedHat(null);
            }
            if (pManager.getCurrentAnimatedHat() != null) {
                pManager.removeAnimatedHat();
            }
        }
    }

    public static boolean checkRequirement(Player player, AnimatedHatType type) {
        if (!type.isEnabled() || !Category.ANIMATED_HATS.isEnabled()) {
            return false;
        }
        if (player == null) {
            return false;
        }
        PlayerManager pManager = GadgetsMenu.getPlayerManager(player);
        if (pManager == null) {
            return false;
        }
        if (player.getInventory().getHelmet() != null) {
            CategoryManager.removeHelmetCosmetic(player);
            if (player.getInventory().getHelmet() != null) {
                if (CategoryManager.checkEquipRequirement(player, MessageType.REMOVE_HELMET_TO_EQUIP_ANIMATED_HAT.getFormatMessage())) {
                    return false;
                }
                if (GadgetsMenu.getGadgetsMenuData().getEquipCosmeticItemToSlotAction() == EnumEquipType.DROP) {
                    Bukkit.getScheduler().runTask((Plugin)GadgetsMenu.getInstance(), () -> {
                        player.getWorld().dropItemNaturally(player.getLocation(), player.getInventory().getHelmet().clone());
                        player.getInventory().setHelmet(null);
                        player.updateInventory();
                    });
                }
            }
        }
        return true;
    }
}

