/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.morphs;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.cosmetics.Category;
import com.yapzhenyie.GadgetsMenu.cosmetics.CategoryManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.morphs.MorphType;
import com.yapzhenyie.GadgetsMenu.player.PlayerManager;
import com.yapzhenyie.GadgetsMenu.utils.EnumEquipType;
import com.yapzhenyie.GadgetsMenu.utils.EnumItem;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class MorphManager {
    public static void equipMorph(Player player, MorphType type) {
        if (!type.isEnabled() || !Category.MORPHS.isEnabled()) {
            return;
        }
        if (player == null) {
            return;
        }
        PlayerManager pManager = GadgetsMenu.getPlayerManager(player);
        if (pManager == null) {
            return;
        }
        if (!GadgetsMenu.getGadgetsMenuData().isLibsDisguiseEnabled() && !GadgetsMenu.getGadgetsMenuData().isIDisguiseEnabled()) {
            return;
        }
        CategoryManager.removeArmorSlotCosmetic(player);
        int slot = GadgetsMenu.getGadgetsMenuData().getGadgetSlot();
        if (player.getInventory().getItem(slot) != null) {
            CategoryManager.removeHotbarCosmetic(player);
            if (player.getInventory().getItem(slot) != null) {
                if (CategoryManager.checkEquipRequirement(player, MessageType.REMOVE_ITEM_FROM_SLOT_TO_EQUIP_MORPH.getFormatMessage().replace("{SLOT}", String.valueOf(slot + 1)).replace("{ITEM}", player.getInventory().getItem(slot).getType().name()))) {
                    return;
                }
                if (GadgetsMenu.getGadgetsMenuData().getEquipCosmeticItemToSlotAction() == EnumEquipType.DROP) {
                    Bukkit.getScheduler().runTask((Plugin)GadgetsMenu.getInstance(), () -> {
                        player.getWorld().dropItemNaturally(player.getLocation(), player.getInventory().getItem(slot).clone());
                        player.getInventory().setItem(slot, null);
                        player.updateInventory();
                    });
                }
            }
        }
        pManager.setSelectedMorph(type);
        GadgetsMenu.getGDisguise().disguise(player, type.getDisguiseType());
        if (GadgetsMenu.getGadgetsMenuData().isLibsDisguiseEnabled() && type.isAbilityEnabled()) {
            MorphManager.giveSlimeball(player);
        }
        type.equip(player);
    }

    public static void unequipMorph(Player player) {
        if (!GadgetsMenu.getGadgetsMenuData().isLibsDisguiseEnabled() && !GadgetsMenu.getGadgetsMenuData().isIDisguiseEnabled()) {
            return;
        }
        PlayerManager pManager = GadgetsMenu.getPlayerManager(player);
        if (player == null || pManager == null) {
            return;
        }
        MorphManager.removeSlimeball(player);
        if (GadgetsMenu.getGDisguise().isDisguised(player) || pManager.getSelectedMorph() != null) {
            if (GadgetsMenu.getGDisguise().isDisguised(player)) {
                GadgetsMenu.getGDisguise().undisguise(player);
            }
            if (pManager.getSelectedMorph() != null) {
                pManager.setSelectedMorph(null);
            }
            if (pManager.getCurrentMorph() != null) {
                pManager.getCurrentMorph().onClear();
                pManager.removeMorph();
            }
        }
    }

    public static void giveSlimeball(Player player) {
        MorphManager.giveSlimeballSilently(player);
    }

    public static void giveSlimeballSilently(Player player) {
        if (player == null) {
            return;
        }
        PlayerManager pManager = GadgetsMenu.getPlayerManager(player);
        if (pManager == null) {
            return;
        }
        int slot = GadgetsMenu.getGadgetsMenuData().getGadgetSlot();
        if (player.getInventory().getItem(slot) != null) {
            if (player.getInventory().getItem(slot).getItemMeta().hasDisplayName() && player.getInventory().getItem(slot).getItemMeta().getDisplayName().equals(EnumItem.MORPH_SLIMEBALL.getDisplayName())) {
                player.getInventory().setItem(slot, null);
            } else if (pManager.getSelectedGadget() != null) {
                pManager.unequipGadget();
            } else if (pManager.getSelectedEmote() != null) {
                pManager.unequipEmote();
            } else {
                player.sendMessage(MessageType.REMOVE_ITEM_FROM_SLOT_TO_EQUIP_MORPH.getFormatMessage().replace("{SLOT}", String.valueOf(slot)).replace("{ITEM}", player.getInventory().getItem(slot).getType().name()));
                return;
            }
        }
        ItemStack item = EnumItem.MORPH_SLIMEBALL.getItemStack();
        item = GadgetsMenu.getNMSManager().setNBTTag(item, "Cosmetics", "true");
        item = GadgetsMenu.getNMSManager().setNBTTag(item, "Category", "Morph");
        player.getInventory().setItem(slot, item);
    }

    public static void removeSlimeball(Player player) {
        int slot = GadgetsMenu.getGadgetsMenuData().getGadgetSlot();
        if (player.getInventory().getItem(slot) != null && player.getInventory().getItem(slot).getItemMeta() != null && player.getInventory().getItem(slot).getItemMeta().hasDisplayName() && player.getInventory().getItem(slot).getItemMeta().getDisplayName().equals(EnumItem.MORPH_SLIMEBALL.getDisplayName())) {
            player.getInventory().setItem(slot, null);
        }
    }

    public static boolean checkRequirement(Player player, MorphType type) {
        if (!type.isEnabled() || !Category.MORPHS.isEnabled()) {
            return false;
        }
        if (player == null) {
            return false;
        }
        PlayerManager pManager = GadgetsMenu.getPlayerManager(player);
        if (pManager == null) {
            return false;
        }
        if (!GadgetsMenu.getGadgetsMenuData().isLibsDisguiseEnabled() && !GadgetsMenu.getGadgetsMenuData().isIDisguiseEnabled()) {
            return false;
        }
        CategoryManager.removeArmorSlotCosmetic(player);
        int slot = GadgetsMenu.getGadgetsMenuData().getGadgetSlot();
        if (player.getInventory().getItem(slot) != null) {
            CategoryManager.removeHotbarCosmetic(player);
            if (player.getInventory().getItem(slot) != null) {
                if (CategoryManager.checkEquipRequirement(player, MessageType.REMOVE_ITEM_FROM_SLOT_TO_EQUIP_MORPH.getFormatMessage().replace("{SLOT}", String.valueOf(slot + 1)).replace("{ITEM}", player.getInventory().getItem(slot).getType().name()))) {
                    return false;
                }
                if (GadgetsMenu.getGadgetsMenuData().getEquipCosmeticItemToSlotAction() == EnumEquipType.DROP) {
                    Bukkit.getScheduler().runTask((Plugin)GadgetsMenu.getInstance(), () -> {
                        player.getWorld().dropItemNaturally(player.getLocation(), player.getInventory().getItem(slot).clone());
                        player.getInventory().setItem(slot, null);
                        player.updateInventory();
                    });
                }
            }
        }
        return true;
    }
}

